/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.buddyChat;

import component.ChatProtoNavTool;
import component.ChatProtoNavUIListener;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import main.ChatExchange;
import main.ChatRoom;
import main.ChatRoomDesc;
import main.ChatRoomID;
import main.Nickname;
import main.Oscar;
import module.rendezvous.buddyChat.BuddyChat;
import module.rendezvous.buddyChat.ChatUI;
import tool.icbm.RendezvousEvent;
import uiutil.ChoiceUI;
import uiutil.SuperLayout;

class SendPanel
extends Panel
implements ActionListener,
ChatProtoNavUIListener {
    private BuddyChat buddyChat;
    private ChatUI chatUI;
    private TextArea namesArea;
    private TextField invitationField;
    private TextField roomNameField;
    private Button sendButton;
    private Button cancelButton;
    private Button helpButton;
    private byte[] roomIDCookie = new byte[]{114, 111, 111, 109};
    private Vector buddyNames;

    public SendPanel(BuddyChat buddyChat, ChatUI chatUI, RendezvousEvent rendezvousEvent) {
        this.buddyChat = buddyChat;
        this.chatUI = chatUI;
        String string = "namesL north=SIDE west=SIDE east=SIDE\nnamesTA north=namesL west=SIDE east=SIDE\nmessageL north=namesTA west=SIDE east=SIDE\nmessageTF north=messageL west=SIDE east=SIDE\nlocationL north=messageTF west=SIDE east=SIDE\nlocationTF north=locationL west=SIDE east=SIDE\nsendB north=locationTF west=SIDE\ncancelB north=locationTF west=sendB\nhelpB north=locationTF east=SIDE\n";
        SuperLayout superLayout = new SuperLayout();
        this.setLayout((LayoutManager)superLayout);
        this.add("namesL", new Label("Screen Names to Invite"));
        this.namesArea = new TextArea(4, 40);
        this.add("namesTA", this.namesArea);
        String string2 = Oscar.mainTool.getSelectedNickname();
        if (string2 != null) {
            this.namesArea.setText(string2);
        }
        this.add("messageL", new Label("Message To Send"));
        this.invitationField = new TextField(40);
        this.add("messageTF", this.invitationField);
        ((TextComponent)this.invitationField).setText("You are invited to: ");
        this.add("locationL", new Label("Location"));
        this.roomNameField = new TextField(40);
        this.add("locationTF", this.roomNameField);
        ((TextComponent)this.roomNameField).setText("chatroom");
        this.sendButton = new Button("Send");
        this.add("sendB", this.sendButton);
        this.cancelButton = new Button("Cancel");
        this.add("cancelB", this.cancelButton);
        this.helpButton = new Button("Help");
        this.add("helpB", this.helpButton);
        superLayout.setInput(new BufferedReader(new StringReader(string)));
        this.sendButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public void roomCreated(Object object, ChatRoom chatRoom) {
        chatRoom.getName();
        System.out.println("ChatUI:roomCreated ==> " + chatRoom);
        ((Component)((Object)this.chatUI)).setVisible(false);
        this.buddyChat.sendInvitation(this.chatUI.getCookie(), this.buddyNames, this.invitationField.getText(), chatRoom);
        this.chatUI.dispose();
    }

    public void setChatRights(Object object, int n, ChatExchange[] chatExchangeArray) {
    }

    public void setExchangeInfo(Object object, ChatExchange chatExchange, ChatRoom[] chatRoomArray) {
    }

    public void setRoomInfo() {
    }

    public void setMoreRoomInfo() {
    }

    public void setOccupantList() {
    }

    public void setRoomSearchResults() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sendButton) {
            this.buddyNames = this.getNames();
            if (this.buddyNames == null || this.buddyNames.size() < 1) {
                ChoiceUI.newChoiceUI((String)"Error", (String)"You must enter at least one name.");
                return;
            }
            ChatRoomID chatRoomID = new ChatRoomID(1, this.roomIDCookie, 0);
            ChatRoomDesc chatRoomDesc = new ChatRoomDesc();
            chatRoomDesc.setName(this.roomNameField.getText());
            ChatRoom chatRoom = new ChatRoom(chatRoomID, 1, chatRoomDesc, null);
            ChatProtoNavTool chatProtoNavTool = (ChatProtoNavTool)Oscar.tools.get("tool.chatnav");
            if (chatProtoNavTool != null) {
                chatProtoNavTool.requestRoomCreation((ChatProtoNavUIListener)this, chatRoom);
                return;
            }
        } else {
            if (object == this.cancelButton) {
                this.chatUI.dispose();
                return;
            }
            if (object == this.helpButton) {
                ChoiceUI.newChoiceUI((String)"Help", (String)"Enter a list of names to which \nto send a chat invitation.\nSeparate each name with a comma.\n");
            }
        }
    }

    private Vector getNames() {
        String string = this.namesArea.getText();
        if (string == null || string.equals("") || string.length() < 4) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 3) continue;
            vector.addElement(Nickname.normalize((String)string2));
        }
        return vector;
    }
}

