/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.buddyChat;

import component.ChatProtoTool;
import component.FolderInfo;
import component.SetupUI;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.Vector;
import main.ChatRoom;
import main.ChatRoomID;
import main.Nickname;
import main.Oscar;
import module.rendezvous.Rendezvous;
import module.rendezvous.buddyChat.ChatUI;
import snac.TLV;
import tool.BlockEvent;
import tool.EvilEvent;
import tool.ToolStatusEvent;
import tool.ToolStatusListener;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmSubModule;
import tool.icbm.RendezvousConstants;
import tool.icbm.RendezvousEvent;
import tool.icbm.RendezvousListener;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.JUtil;
import util.OutputBuffer;

public class BuddyChat
implements IcbmSubModule,
RendezvousConstants,
RendezvousListener,
ToolStatusListener,
UIPack,
ActionListener {
    public static final int roomTlvTag = 10001;
    public static final int roomNameTlvTag = 10011;
    private static final String MODULE = "BuddyChat";
    private static final String MODULE_NAME = "rendezvous.buddyChat";
    private static final String[] UIPACK_NAMES = new String[]{"rendezvous.buddyChat", "icbm.rendezvous", "tool.icbm"};
    private static final String DISPLAY_NAME = "Buddy Chat";
    EventBus eventBus;
    EventBus systemBus;
    Vector uis = new Vector(10);
    private byte[] myService = this.uuidFromString("748F2420-6287-11D1-8222-444553540000");
    private MenuItem chatItem;
    static /* synthetic */ Class class$tool$ToolStatusEvent;
    static /* synthetic */ Class class$tool$icbm$RendezvousEvent;

    public BuddyChat() {
        this.systemBus = EventBus.joinBus((String)EventBus.SYSTEM_BUS);
        this.systemBus.addListenerFor((EventListener)this, class$tool$ToolStatusEvent != null ? class$tool$ToolStatusEvent : (class$tool$ToolStatusEvent = BuddyChat.class$("tool.ToolStatusEvent")));
        if (Oscar.config.getValue("debug.testbuddychat") != null) {
            this.chatItem = new MenuItem(DISPLAY_NAME);
            this.chatItem.addActionListener(this);
            Oscar.addMenuItem((String)"People", (MenuItem)this.chatItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chatItem) {
            Rendezvous.initService = "748F2420-6287-11D1-8222-444553540000";
            Oscar.mainTool.rendezvousAction(Oscar.mainTool.getSelectedNickname());
        }
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        System.out.println("Rendezvous BuddyChat.initiate on channel " + icbmChannel + " bus=" + string);
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)this, class$tool$icbm$RendezvousEvent != null ? class$tool$icbm$RendezvousEvent : (class$tool$icbm$RendezvousEvent = BuddyChat.class$("tool.icbm.RendezvousEvent")));
    }

    void sendEvil(String string, boolean bl) {
        EvilEvent evilEvent = new EvilEvent((Object)this, 1110, new Nickname(string), bl);
        this.systemBus.postEvent((EventBusEvent)evilEvent);
    }

    void block(String string) {
        BlockEvent blockEvent = new BlockEvent((Object)this, 1120, new Nickname(string));
        this.systemBus.postEvent((EventBusEvent)blockEvent);
    }

    void sendIM(String string) {
        Oscar.mainTool.icbmAction(string);
    }

    void sendInvitation(byte[] byArray, Vector vector, String string, ChatRoom chatRoom) {
        byte[] byArray2 = chatRoom.getCookie();
        int n = byArray2.length;
        OutputBuffer outputBuffer = new OutputBuffer(12 + n);
        byte[] byArray3 = null;
        try {
            outputBuffer.writeShort(chatRoom.getExchange());
            outputBuffer.writeByte(n);
            outputBuffer.write(byArray2, 0, n);
            outputBuffer.writeShort(chatRoom.getInstance());
            byArray3 = outputBuffer.bytes();
        }
        catch (IOException iOException) {
            System.out.println("IOError while trying to create chatTlv.");
        }
        this.sendRequest(byArray, vector, string, chatRoom, byArray3);
        if (vector.contains(Oscar.nickname.toLowerCase())) {
            return;
        }
        ChatProtoTool chatProtoTool = (ChatProtoTool)Oscar.tools.get("tool.chat");
        if (chatProtoTool == null) {
            System.out.println("**** ChatTool is unavailable!!!");
            return;
        }
        chatProtoTool.joinRoom(chatRoom.getExchange(), byArray2, chatRoom.getInstance());
    }

    void sendRequest(byte[] byArray, Vector vector, String string, ChatRoom chatRoom, byte[] byArray2) {
        TLV tLV = new TLV(2);
        tLV.addTlvU16(0, 1);
        tLV.addTlvU16(10000, 10001);
        String string2 = "123.123.123.123";
        int n = 1234;
        tLV.addTlv(2, string2);
        tLV.addTlvU16(5, n);
        tLV.addTlv(6, string);
        System.out.println("BuddyChat: data = " + JUtil.bytesToHexString((byte[])byArray2));
        tLV.addTlv(10001, byArray2);
        tLV.addTlv(10011, chatRoom.getName());
        byte[] byArray3 = Oscar.bosCore.getCookie();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = (String)vector.elementAt(n3);
            RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string3), byArray3, false, tLV, this.myService, 0, byArray, 0);
            if (string3 != null) {
                this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
            }
            if (n3 + 1 < n2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
    }

    void sendAccept(byte[] byArray, byte[] byArray2, String string, TLV tLV, ChatRoomID chatRoomID) {
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, this.myService, 0, byArray2, 2);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
        ChatProtoTool chatProtoTool = (ChatProtoTool)Oscar.tools.get("tool.chat");
        if (chatProtoTool == null) {
            System.out.println("**** ChatTool is unavailable!!!");
            return;
        }
        chatProtoTool.joinRoom(chatRoomID.getExchange(), chatRoomID.getCookie(), chatRoomID.getInstance());
    }

    void sendExplicitIgnore(byte[] byArray, String string) {
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, this.myService, 1, byArray, 1);
        if (string != null) {
            this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
        }
    }

    void sendCancel(byte[] byArray, Vector vector) {
        new String(byArray);
        if (vector == null || vector.size() < 1) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, this.myService, 1, byArray, 1);
            if (string != null) {
                this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
            }
            if (n2 + 1 < n) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    void sendError(byte[] byArray, byte[] byArray2, String string, int n) {
        TLV tLV = new TLV(2);
        tLV.addTlv(n, byArray2);
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1106, 2, new Nickname(string), byArray, false, tLV, this.myService, 0, byArray2, 100);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    private byte[] uuidFromString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '-') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = null;
        try {
            byArray = JUtil.bytesFromHexString((String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn((String)MODULE, (String)("UUID caused number format exception. Id=" + string2));
        }
        return byArray;
    }

    private final boolean isMyService(byte[] byArray) {
        if (byArray == null || this.myService.length != byArray.length) {
            return false;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.myService[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void removeChatUI(ChatUI chatUI) {
        this.uis.removeElement((Object)chatUI);
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void receiveMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        this.uis.addElement(new ChatUI(this, rendezvousEvent));
    }

    public void sendMessage(RendezvousEvent rendezvousEvent) {
    }

    public void initiateMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        this.uis.addElement(new ChatUI(this, rendezvousEvent));
    }

    public void payloadError(RendezvousEvent rendezvousEvent) {
    }

    public void channelError(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        if (rendezvousEvent.getId() == 1105) {
            this.uis.addElement(new ChatUI(this, rendezvousEvent));
        }
    }

    public void connect(ToolStatusEvent toolStatusEvent) {
    }

    public void disconnect(ToolStatusEvent toolStatusEvent) {
    }

    public void enableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            int n = this.uis.size();
            int n2 = 0;
            while (n2 < n) {
                ChatUI chatUI = (ChatUI)((Object)this.uis.elementAt(n2));
                if (chatUI != null) {
                    chatUI.setEnabled(true);
                }
                ++n2;
            }
        }
    }

    public void disableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            int n = this.uis.size();
            int n2 = 0;
            while (n2 < n) {
                ChatUI chatUI = (ChatUI)((Object)this.uis.elementAt(n2));
                if (chatUI != null) {
                    chatUI.setEnabled(false);
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

