/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.tester;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import module.rendezvous.tester.TestUI;
import module.rendezvous.tester.Tester;
import snac.TLV;
import tool.icbm.RendezvousEvent;
import util.JUtil;

class ReceivePanel
extends Panel
implements ActionListener {
    Tester tester;
    TestUI testUI;
    Button accept;
    Button ignore;
    Button warn;
    Button unsupported;
    Button denied;
    Button badParams;
    Button notAvail;
    TextArea display;
    String nickname;
    byte[] cookie;
    byte[] rCookie;
    byte[] service;
    String ipAddress;
    int port;
    String[] renMsg = new String[]{"BEGIN_RESERVED_RANGE ", "RENDEZVOUS_CHANNEL", "RENDEZVOUS_IP_ADDR", "REQUESTER_IP_ADDR", "VERIFIED_IP_ADDR", "PORT", "INVITATION", "DOWNLOAD_URL", "VERIFIED_DOWNLOAD_URL"};
    String[] renType = new String[]{"REQUEST", "CANCEL", "ACCEPT"};
    String[] cancelType = new String[]{"NA or UNKNOWN", "USER_CANCEL", "TIMEOUT"};

    public ReceivePanel() {
    }

    public ReceivePanel(Tester tester, TestUI testUI, RendezvousEvent rendezvousEvent) {
        this.tester = tester;
        this.testUI = testUI;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.accept = new Button("Accept");
        panel.add(this.accept);
        this.ignore = new Button("Ignore");
        panel.add(this.ignore);
        this.warn = new Button("Warn");
        panel.add(this.warn);
        this.unsupported = new Button("Unsupported");
        panel.add(this.unsupported);
        this.denied = new Button("Denied");
        panel.add(this.denied);
        this.badParams = new Button("Bad Params");
        panel.add(this.badParams);
        this.notAvail = new Button("Not Avail");
        panel.add(this.notAvail);
        this.accept.addActionListener(this);
        this.ignore.addActionListener(this);
        this.warn.addActionListener(this);
        this.unsupported.addActionListener(this);
        this.denied.addActionListener(this);
        this.badParams.addActionListener(this);
        this.notAvail.addActionListener(this);
        this.add("South", panel);
        this.display = new TextArea(25, 50);
        this.add("Center", this.display);
        this.displayEventContents(rendezvousEvent);
        this.setSize(200, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.accept) {
                this.tester.sendAccept(this.rCookie, this.nickname, this.service);
                return;
            }
            if (button == this.warn) {
                this.tester.sendEvil(this.nickname, true);
                return;
            }
            if (button == this.unsupported) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 0);
                return;
            }
            if (button == this.denied) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 1);
                return;
            }
            if (button == this.badParams) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 3);
                return;
            }
            if (button == this.ignore) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 2);
                return;
            }
            if (button == this.badParams) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 3);
                return;
            }
            if (button == this.notAvail) {
                this.tester.sendError(this.cookie, this.rCookie, this.nickname, this.service, 5);
            }
        }
    }

    private final String getQuad(String string) {
        if (string.length() != 8) {
            return "xx.xx.xx.xx";
        }
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < 8) {
            String string3 = string.substring(n, n + 2);
            try {
                n2 = Integer.parseInt(string3, 16);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            string2 = String.valueOf(string2) + n2;
            if ((n += 2) >= 8) continue;
            string2 = String.valueOf(string2) + ".";
        }
        return string2;
    }

    private void displayEventContents(RendezvousEvent rendezvousEvent) {
        String string = "\n";
        if (rendezvousEvent == null) {
            this.display.append("Got NULL rendezvous event.\n\n");
        }
        String string2 = "Channel : ";
        if (rendezvousEvent != null) {
            string2 = String.valueOf(string2) + rendezvousEvent.getChannel();
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "Nickname : ";
        if (rendezvousEvent != null) {
            this.nickname = rendezvousEvent.getNickname().nickname;
            string2 = String.valueOf(string2) + this.nickname;
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "Cookie : ";
        if (rendezvousEvent != null) {
            this.cookie = rendezvousEvent.getCookie();
            string2 = String.valueOf(string2) + JUtil.bytesToHexString((byte[])this.cookie);
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "AutoResponse : ";
        if (rendezvousEvent != null) {
            string2 = String.valueOf(string2) + rendezvousEvent.isAutoResponse();
        }
        this.display.append(String.valueOf(string2) + string + string);
        string2 = "RendezvousType : ";
        if (rendezvousEvent != null) {
            string2 = String.valueOf(string2) + this.renType[rendezvousEvent.getRendezvousType()];
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "Cancel Reason : ";
        if (rendezvousEvent != null) {
            string2 = String.valueOf(string2) + this.cancelType[rendezvousEvent.getRendezvousCancelReason()];
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "RendezvousCookie : ";
        if (rendezvousEvent != null) {
            this.rCookie = rendezvousEvent.getRendezvousCookie();
            string2 = String.valueOf(string2) + JUtil.bytesToHexString((byte[])this.rCookie);
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "RendezvousService : ";
        if (rendezvousEvent != null) {
            this.service = rendezvousEvent.getRendezvousService();
            string2 = String.valueOf(string2) + JUtil.bytesToHexString((byte[])this.service);
        }
        this.display.append(String.valueOf(string2) + string);
        string2 = "RendezvousParams : \n";
        if (rendezvousEvent != null) {
            this.display.append(string2);
            TLV tLV = rendezvousEvent.getRendezvousParams();
            if (tLV != null) {
                int n = 1;
                while (n < 8) {
                    byte[] byArray = tLV.getTlvData(n);
                    if (byArray != null) {
                        if (n == 4) {
                            this.display.append("    " + this.renMsg[n] + " :\t" + this.getQuad(JUtil.bytesToHexString((byte[])byArray)) + string);
                        } else if (n == 1 || n == 5) {
                            this.display.append("    " + this.renMsg[n] + " :\t" + tLV.getTlvDataAsU16(n) + string);
                        } else {
                            this.display.append("    " + this.renMsg[n] + " :\t" + new String(byArray) + string);
                        }
                    }
                    ++n;
                }
                return;
            }
        } else {
            this.display.append(string2);
        }
    }

    public void update(RendezvousEvent rendezvousEvent) {
        if (this.display == null) {
            this.display = new TextArea(25, 50);
        }
        this.display.setText("");
        if (rendezvousEvent != null) {
            this.displayEventContents(rendezvousEvent);
        }
    }
}

