/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import main.Oscar;
import uiutil.DimFilter;
import uiutil.MediaStore;
import uiutil.UIPack;

public class ImageStore
extends Hashtable {
    public int MINI_ICON_SIZE = 12;
    public int MINI_ICON_PAD = 2;
    public final int EVIL_ICON = 1;
    public final int IDLE_ICON = 2;
    public String[] CLASS_ICON_FILES = new String[]{"Blank", "DT", "NBFree", "NBPay", "AOL16", "Admin", "DTI", "NBFreeI", "NBPayI", "AOL16I", "AdminI"};
    public String[] CLASS_ICON_LABELS = new String[]{"Unknown", "Trial", "Free", "Pay", "AOL", "Admin"};
    public String[] LOG_ICON_FILES = new String[]{"Login", "Logout", "LoginI", "LogoutI"};
    private int NARROW_BUTTON_WIDTH = 33;
    private int NARROW_BUTTON_HEIGHT = 45;
    private String IMAGE_DIR = "images";
    private String IMAGE_SUFFIX = ".gif";
    public static String NORMAL = "N";
    public static String PRESSED = "D";
    public static String HIGHLIGHTED = "H";
    public static String DISABLED = "S";
    public static int BUTTON_MARGIN = 8;
    private int BLACK = Color.black.getRGB();
    private int WHITE = Color.white.getRGB();
    private int GRAY = Color.lightGray.getRGB();
    private int DARK_GREEN = new Color(0, 102, 0).getRGB();
    private int AOL_WIDTH = 25;
    private int AOL_HEIGHT = 22;
    private int AOL_INSET = (this.NARROW_BUTTON_WIDTH - this.AOL_WIDTH) / 2;
    private int[] AOL_GREEN_PIXELS;
    private int[] AOL_BLACK_PIXELS;
    private int[] AOL_PATTERN = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public Image getDefaultTile(Component component) {
        int n = 16;
        int[] nArray = new int[n * n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n) {
                nArray[n2++] = (n4 + n3) % 2 == 0 ? this.WHITE : this.GRAY;
                ++n4;
            }
            ++n3;
        }
        return component.createImage(new MemoryImageSource(n, n, nArray, 0, n));
    }

    public Image getDefaultImage(int n, int n2, Component component) {
        int[] nArray = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray[n3++] = n5 == 0 || n5 == n - 1 || n4 == 0 || n4 == n2 - 1 || n5 == n4 || n5 + n4 == n - 1 ? this.BLACK : this.WHITE;
                ++n5;
            }
            ++n4;
        }
        return component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public Image getImage(UIPack uIPack, String string, Component component, boolean bl) {
        return this.getImage(uIPack, string, component, bl, null);
    }

    public Image[] getImages(UIPack uIPack, String[] stringArray, Component component, boolean bl) {
        return this.getImages(uIPack, stringArray, component, bl, true, null);
    }

    public Image[] getImages(UIPack uIPack, String[] stringArray, Component component, boolean bl, boolean bl2) {
        return this.getImages(uIPack, stringArray, component, bl, bl2, null);
    }

    public boolean unloadImage(UIPack uIPack, String string) {
        return MediaStore.unloadMedia(uIPack.getUIPackNames(), this.IMAGE_DIR, String.valueOf(string) + this.IMAGE_SUFFIX);
    }

    public boolean[] unloadImages(UIPack uIPack, String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            blArray[n] = MediaStore.unloadMedia(uIPack.getUIPackNames(), this.IMAGE_DIR, String.valueOf(stringArray[n]) + this.IMAGE_SUFFIX);
            ++n;
        }
        return blArray;
    }

    private static boolean confirmLoad(MediaTracker mediaTracker, int n) {
        boolean bl = true;
        if (mediaTracker == null) {
            return bl;
        }
        mediaTracker.statusAll(true);
        try {
            mediaTracker.waitForID(n);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
            interruptedException.printStackTrace();
        }
        return bl;
    }

    private Image createDefaultButtonImage(int[] nArray, int n, int n2, int n3, int n4, Component component) {
        int n5 = n * n2;
        int[] nArray2 = new int[n5];
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.AOL_HEIGHT) {
            int n8 = (n7 + n4) * n + n3;
            int n9 = 0;
            while (n9 < this.AOL_WIDTH) {
                nArray2[n8++] = nArray[n6++];
                ++n9;
            }
            ++n7;
        }
        return component.createImage(new MemoryImageSource(n, n2, nArray2, 0, n));
    }

    private int[] createPixelsAOLBlack() {
        int n = this.AOL_WIDTH * this.AOL_HEIGHT;
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.AOL_HEIGHT) {
            int n4 = 0;
            while (n4 < this.AOL_WIDTH) {
                nArray[n2] = this.AOL_PATTERN[n2] == 0 ? this.BLACK : this.WHITE;
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }

    private int[] createPixelsAOLGreen() {
        int n = this.AOL_WIDTH * this.AOL_HEIGHT;
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.AOL_HEIGHT) {
            int n4 = 0;
            while (n4 < this.AOL_WIDTH) {
                nArray[n2] = this.AOL_PATTERN[n2] == 0 ? (n4 != 0 && n3 != 0 && n4 != this.AOL_WIDTH - 1 && n3 != this.AOL_HEIGHT - 1 ? this.DARK_GREEN : this.BLACK) : this.WHITE;
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }

    private Image getImage(UIPack uIPack, String string, Component component, boolean bl, StringBuffer stringBuffer) {
        MediaTracker mediaTracker = new MediaTracker(component);
        if (Oscar.config.getValue("debug.turnOffBackgroundTiles") != null && string.equals("Bkgdtile")) {
            return null;
        }
        Image image = this.loadImage(uIPack, string, component, bl, mediaTracker, stringBuffer);
        if (image == null) {
            image = string.equals("Bkgdtile") ? this.getDefaultTile(component) : this.getDefaultImage(24, 24, component);
        } else {
            ImageStore.confirmLoad(mediaTracker, 0);
        }
        return image;
    }

    public Image[] getImages(UIPack uIPack, String[] stringArray, Component component, boolean bl, boolean bl2, String[] stringArray2) {
        Image[] imageArray = new Image[stringArray.length];
        MediaTracker mediaTracker = new MediaTracker(component);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringBuffer.setLength(0);
                imageArray[n] = this.loadImage(uIPack, stringArray[n], component, bl, mediaTracker, stringBuffer);
                if (imageArray[n] == null && bl2) {
                    imageArray[n] = this.getDefaultImage(16, 16, component);
                    if (stringArray2 != null) {
                        stringArray2[n] = "DEFAULT IMAGE16x16";
                    }
                } else if (stringArray2 != null) {
                    stringArray2[n] = stringBuffer.toString();
                }
            }
            ++n;
        }
        ImageStore.confirmLoad(mediaTracker, 0);
        return imageArray;
    }

    public Image[] getMissingButtonImages(Image[] imageArray, Component component) {
        MediaTracker mediaTracker = null;
        ImageStore.confirmLoad(mediaTracker, 0);
        if (imageArray[0] == null) {
            if (this.AOL_BLACK_PIXELS == null) {
                this.AOL_BLACK_PIXELS = this.createPixelsAOLBlack();
            }
            if (mediaTracker == null) {
                mediaTracker = new MediaTracker(component);
            }
            imageArray[0] = this.createDefaultButtonImage(this.AOL_BLACK_PIXELS, this.NARROW_BUTTON_WIDTH, this.NARROW_BUTTON_HEIGHT, this.AOL_INSET, this.AOL_INSET, component);
            mediaTracker.addImage(imageArray[0], 0);
        }
        if (imageArray[1] == null) {
            if (this.AOL_BLACK_PIXELS == null) {
                this.AOL_BLACK_PIXELS = this.createPixelsAOLBlack();
            }
            if (mediaTracker == null) {
                mediaTracker = new MediaTracker(component);
            }
            imageArray[1] = this.createDefaultButtonImage(this.AOL_BLACK_PIXELS, this.NARROW_BUTTON_WIDTH, this.NARROW_BUTTON_HEIGHT, this.AOL_INSET + 1, this.AOL_INSET + 3, component);
            mediaTracker.addImage(imageArray[0], 0);
        }
        if (imageArray[2] == null) {
            if (this.AOL_GREEN_PIXELS == null) {
                this.AOL_GREEN_PIXELS = this.createPixelsAOLGreen();
            }
            if (mediaTracker == null) {
                mediaTracker = new MediaTracker(component);
            }
            imageArray[2] = this.createDefaultButtonImage(this.AOL_GREEN_PIXELS, this.NARROW_BUTTON_WIDTH, this.NARROW_BUTTON_HEIGHT, this.AOL_INSET, this.AOL_INSET, component);
            mediaTracker.addImage(imageArray[0], 0);
        }
        if (mediaTracker != null) {
            ImageStore.confirmLoad(mediaTracker, 0);
        }
        return imageArray;
    }

    private Image loadImage(UIPack uIPack, String string, Component component, boolean bl, MediaTracker mediaTracker, StringBuffer stringBuffer) {
        Image image = null;
        image = uIPack == null ? MediaStore.getImage(null, String.valueOf(string) + this.IMAGE_SUFFIX, bl) : MediaStore.getImage(uIPack.getUIPackNames(), String.valueOf(string) + this.IMAGE_SUFFIX, bl);
        if (image != null && mediaTracker != null) {
            mediaTracker.addImage(image, 0);
        }
        if (stringBuffer != null) {
            String string2 = "tools/" + uIPack.getUIPackNames()[0].replace(' ', '_') + "/images/" + string + this.IMAGE_SUFFIX;
            stringBuffer.append(string2);
        }
        return image;
    }

    public Image makeDimImage(Image image, Component component, String string) {
        Image image2 = null;
        if (string != null) {
            image2 = (Image)this.get(string);
        }
        if (image2 != null) {
            return image2;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        DimFilter dimFilter = new DimFilter(0xC0C0C0);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), dimFilter);
        image2 = component.createImage(filteredImageSource);
        mediaTracker.addImage(image2, 0);
        ImageStore.confirmLoad(mediaTracker, 0);
        if (string != null) {
            this.put(string, image2);
        }
        return image2;
    }

    public Image evilIcon(int n, Component component, boolean bl) {
        Image image;
        int n2 = (n + 50) / 100;
        String string = "EVIL_ICON:" + n2;
        if (!bl) {
            string = String.valueOf(string) + "I";
        }
        if ((image = (Image)this.get(string)) != null) {
            return image;
        }
        image = component.createImage(this.MINI_ICON_SIZE, this.MINI_ICON_SIZE);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.MINI_ICON_SIZE, this.MINI_ICON_SIZE);
        this.evilIconPaint(graphics, n, bl);
        image = ImageStore.makeTransparent(image, Color.black, component);
        this.put(string, image);
        return image;
    }

    public static Image makeTransparent(Image image, Color color, Component component) {
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            if (pixelGrabber.grabPixels()) {
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = n6 * n + n7;
                        int n9 = (nArray[n8] & 0xFF000000) >> 24;
                        int n10 = (nArray[n8] & 0xFF0000) >> 16;
                        int n11 = (nArray[n8] & 0xFF00) >> 8;
                        int n12 = nArray[n8] & 0xFF;
                        if (n10 == n3 && n11 == n4 && n12 == n5) {
                            n9 = 0;
                            nArray[n8] = n9 | n10 << 16 | n11 << 8 | n12;
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        image = component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        mediaTracker.addImage(image, 0);
        ImageStore.confirmLoad(mediaTracker, 0);
        return image;
    }

    public void evilIconPaint(Graphics graphics, int n, boolean bl) {
        int n2;
        int n3 = 0;
        int n4 = this.MINI_ICON_SIZE;
        int n5 = this.MINI_ICON_PAD;
        if ((n = (n + 50) / 100) == 0) {
            n2 = n4 - 2 * n5;
            int n6 = n2 / 2;
            if (bl) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.drawArc((n4 - n2) / 2, (n4 - n6) / 2, n2, n6, 0, 360);
            graphics.drawArc((n4 - n2) / 2 + 1, (n4 - n6) / 2 - 1, n2, n6, 0, 360);
        }
        if (bl) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.white);
        }
        n2 = 0;
        while (n2 < n) {
            if (n2 == 4) {
                graphics.drawLine(0, n4 - 2 - n5, 7, n5 + 1);
                n3 = 1;
            } else if (n2 == 9) {
                graphics.drawLine(8, n4 - 2 - n5, n4 - 1, n5 + 1);
            } else {
                graphics.drawLine(n2 * 2 - n3, n5, n2 * 2 - n3, n4 - 1 - n5);
            }
            ++n2;
        }
    }

    public Image idleIcon(int n, Component component, boolean bl) {
        Image image;
        String string;
        if (n >= 60) {
            string = "IDLE_ICON:60";
            n = 60;
        } else {
            string = "IDLE_ICON:" + n % 60;
        }
        if (!bl) {
            string = String.valueOf(string) + "I";
        }
        if ((image = (Image)this.get(string)) != null) {
            return image;
        }
        image = component.createImage(this.MINI_ICON_SIZE, this.MINI_ICON_SIZE);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.MINI_ICON_SIZE, this.MINI_ICON_SIZE);
        this.idleIconPaint(graphics, n, bl);
        image = ImageStore.makeTransparent(image, Color.black, component);
        this.put(string, image);
        return image;
    }

    public void idleIconPaint(Graphics graphics, int n, boolean bl) {
        int n2 = this.MINI_ICON_SIZE - 2 * this.MINI_ICON_PAD;
        int n3 = this.MINI_ICON_PAD;
        if (bl) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawArc(n3, n3, n2, n2, 0, 360);
        if (n > 0) {
            graphics.fillArc(n3, n3, n2, n2, 90, -(n * 6));
        }
    }

    public Image makeDimImage(Image image, Component component) {
        return this.makeDimImage(image, component, null);
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        switch (n2) {
            case 1: {
                this.evilIconPaint(graphics, n, true);
                return;
            }
            case 2: {
                this.idleIconPaint(graphics, n, true);
                return;
            }
        }
    }

    public static void printColorMap(Component component) {
        Toolkit toolkit = component.getToolkit();
        ColorModel colorModel = toolkit.getColorModel();
        System.out.println("Color Model is " + colorModel.getClass().getName());
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n = indexColorModel.getMapSize();
            int n2 = 0;
            while (n2 < n) {
                int n3 = indexColorModel.getRGB(n2);
                System.out.println(String.valueOf(n2) + "\t" + ((n3 & 0xFF0000) >> 16) + "\t" + ((n3 & 0xFF00) >> 8) + "\t" + (n3 & 0xFF));
                ++n2;
            }
        }
    }
}

