/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import uiutil.ColorButtonListener;

class ColorButton
extends Component {
    public Color color;
    private ColorButtonListener listener;
    private boolean selected = false;

    ColorButton(Color color, ColorButtonListener colorButtonListener) {
        this.color = color;
        this.listener = colorButtonListener;
        this.enableEvents(16L);
    }

    public void destroy() {
        this.color = null;
        this.listener = null;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 501 && this.listener != null) {
            this.listener.colorButtonSelected(this);
            this.selected(true);
            return;
        }
        if (n == 504) {
            this.selected(true);
            return;
        }
        if (n == 505) {
            this.selected(false);
        }
    }

    public void selected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.color);
        graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
        if (this.selected) {
            graphics.setColor(Color.white);
            graphics.drawLine(2, 2, dimension.width - 3, 2);
            graphics.drawLine(2, 2, 2, dimension.height - 3);
            graphics.setColor(Color.black);
            graphics.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
            graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, dimension.height - 3);
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(2, 2, dimension.width - 3, 2);
        graphics.drawLine(2, 2, 2, dimension.height - 3);
        graphics.setColor(Color.white);
        graphics.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
        graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, dimension.height - 3);
    }
}

