/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import uiutil.TransparentPanel;

public class BoundedPanel
extends TransparentPanel {
    public static final int BORDER_SIMPLE = 0;
    public static final int BORDER_IN = 1;
    public static final int BORDER_OUT = 2;
    public static final int BORDER_3D = 3;
    private int borderType = 3;

    public BoundedPanel(Component component) {
        this.setLayout(new BorderLayout());
        this.add("Center", component);
    }

    public BoundedPanel(Component component, int n) {
        this.setLayout(new BorderLayout());
        this.add("Center", component);
        this.setBorder(n);
    }

    public Insets getInsets() {
        if (this.borderType < 3) {
            return new Insets(1, 1, 1, 1);
        }
        return new Insets(3, 3, 3, 3);
    }

    public void setBorder(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid border type value");
        }
        this.borderType = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private final void drawBox(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    private final void drawIn(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(Color.white);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    private final void drawOut(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    private final void draw3D(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.lightGray);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
        graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(2, 2, dimension.width - 3, 2);
        graphics.drawLine(2, 2, 2, dimension.height - 3);
        graphics.setColor(Color.white);
        graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
    }

    public void paint(Graphics graphics) {
        switch (this.borderType) {
            case 3: {
                this.draw3D(graphics);
                break;
            }
            case 0: {
                this.drawBox(graphics);
                break;
            }
            case 1: {
                this.drawIn(graphics);
                break;
            }
            case 2: {
                this.drawOut(graphics);
            }
        }
        super.paint(graphics);
    }
}

