/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import snac.SnacConstants;
import snac.SnacID;

public class SnacRateClassMembers
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int id;
    public int numMembers;
    public Vector snacidArray;

    public SnacRateClassMembers(int n, int n2, Vector vector) {
        this.id = n;
        this.numMembers = n2;
        this.snacidArray = vector;
    }

    SnacRateClassMembers(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readUnsignedShort();
        this.numMembers = dataInputStream.readUnsignedShort();
        this.snacidArray = new Vector();
        int n = 0;
        while (n < this.numMembers && dataInputStream.available() > 0) {
            this.snacidArray.addElement(new SnacID(dataInputStream));
            ++n;
        }
        if (n < this.numMembers) {
            throw new IOException("read underflow");
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.id);
        dataOutputStream.writeShort(this.numMembers);
        int n = 0;
        while (n < this.numMembers && n < this.snacidArray.size()) {
            ((SnacID)this.snacidArray.elementAt(n)).write(dataOutputStream);
            ++n;
        }
    }
}

