/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.ChatListener;
import snac.ChatRoomDesc;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacIcbmCookie;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class ChatHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ChatHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(14, 1, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRoomInfoUpdate(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatRoomInfoUpdate SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            ChatRoomDesc chatRoomDesc = new ChatRoomDesc(dataInputStream);
            int n = this.initHandledState();
            if (chatListener != null) {
                n = this.updateHandledState(n, chatListener.chatRoomInfoUpdate(fLAPSock, object, sNACHeader.reqID, n, chatRoomDesc));
            }
            int n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n)) {
                    return;
                }
                ChatListener chatListener2 = (ChatListener)vector.elementAt(n2);
                if (chatListener2 != chatListener) {
                    n = this.updateHandledState(n, chatListener2.chatRoomInfoUpdate(fLAPSock, object, sNACHeader.reqID, n, chatRoomDesc));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatRoomInfoUpdate " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeUsersJoined(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatUsersJoined SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWinfo> vector2;
                block7: {
                    vector2 = new Vector<SnacNicknameWinfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWinfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatListener != null) {
                        n2 = this.updateHandledState(n2, chatListener.chatUsersJoined(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatListener chatListener2;
                    if ((chatListener2 = (ChatListener)vector.elementAt(n)) != chatListener) {
                        n2 = this.updateHandledState(n2, chatListener2.chatUsersJoined(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatUsersJoined " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeUsersLeft(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatUsersLeft SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWinfo> vector2;
                block7: {
                    vector2 = new Vector<SnacNicknameWinfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWinfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatListener != null) {
                        n2 = this.updateHandledState(n2, chatListener.chatUsersLeft(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatListener chatListener2;
                    if ((chatListener2 = (ChatListener)vector.elementAt(n)) != chatListener) {
                        n2 = this.updateHandledState(n2, chatListener2.chatUsersLeft(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatUsersLeft " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void channelMsgTohost(FLAPSock fLAPSock, ChatListener chatListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing chatChannelMsgTohost SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer);
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, chatListener, object, 14, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatChannelMsgTohost " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeChannelMsgToclient(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatChannelMsgToclient SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                SnacIcbmCookie snacIcbmCookie;
                block7: {
                    snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatListener != null) {
                        n2 = this.updateHandledState(n2, chatListener.chatChannelMsgToclient(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatListener chatListener2;
                    if ((chatListener2 = (ChatListener)vector.elementAt(n)) != chatListener) {
                        n2 = this.updateHandledState(n2, chatListener2.chatChannelMsgToclient(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatChannelMsgToclient " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void evilRequest(FLAPSock fLAPSock, ChatListener chatListener, Object object, int n, SnacNickname snacNickname, int n2, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing chatEvilRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            snacNickname.write(outputBuffer);
            outputBuffer.writeShort(n2);
            int n3 = 0;
            while (n3 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n3)).write(outputBuffer);
                ++n3;
            }
            this.dispatcher.queueOutput(fLAPSock, chatListener, object, 14, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatEvilRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeEvilReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatEvilReply SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = this.initHandledState();
            if (chatListener != null) {
                n3 = this.updateHandledState(n3, chatListener.chatEvilReply(fLAPSock, object, sNACHeader.reqID, n3, n, n2));
            }
            int n4 = 0;
            while (vector != null) {
                if (n4 >= vector.size()) return;
                if (!this.proceed(n3)) {
                    return;
                }
                ChatListener chatListener2 = (ChatListener)vector.elementAt(n4);
                if (chatListener2 != chatListener) {
                    n3 = this.updateHandledState(n3, chatListener2.chatEvilReply(fLAPSock, object, sNACHeader.reqID, n3, n, n2));
                }
                ++n4;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatEvilReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void clientErr(FLAPSock fLAPSock, ChatListener chatListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname, int n2, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing chatClientErr SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer);
            outputBuffer.writeShort(n);
            snacNickname.write(outputBuffer);
            outputBuffer.writeShort(n2);
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, chatListener, object, 14, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeClientErr(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatClientErr SNAC");
        ChatListener chatListener = (ChatListener)listener;
        try {
            SnacIcbmCookie snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.available();
            if (n3 > 8192) {
                throw new IOException("read overflow");
            }
            if (n3 < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n3];
            if (n3 > 0) {
                dataInputStream.read(byArray, 0, n3);
            }
            int n4 = this.initHandledState();
            if (chatListener != null) {
                n4 = this.updateHandledState(n4, chatListener.chatClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
            }
            int n5 = 0;
            while (vector != null) {
                if (n5 >= vector.size()) return;
                if (!this.proceed(n4)) {
                    return;
                }
                ChatListener chatListener2 = (ChatListener)vector.elementAt(n5);
                if (chatListener2 != chatListener) {
                    n4 = this.updateHandledState(n4, chatListener2.chatClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
                }
                ++n5;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRoomInfoUpdate(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeUsersJoined(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeUsersLeft(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeChannelMsgToclient(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeEvilReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeClientErr(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Chat", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

