/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.AdvertListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.SnacTlvBlock;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class AdvertHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public AdvertHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(5, 1, this);
    }

    public void requestAds(FLAPSock fLAPSock, AdvertListener advertListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing advertRequestAds SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, advertListener, object, 5, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Advert", "got IOException in advertRequestAds " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAds(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got advertAds SNAC");
        AdvertListener advertListener = (AdvertListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacTlvBlock> vector2;
                block7: {
                    vector2 = new Vector<SnacTlvBlock>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacTlvBlock(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (advertListener != null) {
                        n2 = this.updateHandledState(n2, advertListener.advertAds(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdvertListener advertListener2;
                    if ((advertListener2 = (AdvertListener)vector.elementAt(n)) != advertListener) {
                        n2 = this.updateHandledState(n2, advertListener2.advertAds(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Advert", "got IOException in advertAds " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeAds(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Advert", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

