/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import main.ChatRoomID;
import snac.ChatExchangeDesc;
import snac.SnacConstants;
import snac.TLV;
import uiutil.ErrorMgr;

public class ChatExchange
implements SnacConstants {
    public static int CREATION_NOT_ALLOWED;
    public static int ROOM_CREATION_ALLOWED;
    public static int EXCHANGE_CREATION_ALLOWED;
    private int id;
    private String name;
    private int creationTime;
    private boolean isTree;
    private boolean isForDT;
    private boolean isForAdmin;
    private boolean isForAOL;
    private boolean isForOscarPay;
    private boolean isForOscarFree;
    private int maxConcurrentRooms;
    private int maxRoomNameLength;
    private int maxOccupancy;
    private int maxMessageLength;
    private int creationPermission;
    private ChatRoomID[] rootRooms;
    private int[] searchTags;
    private String MODULE = "ChatExchange";

    public ChatExchange(int n) {
        this.id = n;
    }

    public ChatExchange(ChatExchangeDesc chatExchangeDesc) {
        this.id = chatExchangeDesc.id;
        if (chatExchangeDesc.description != null) {
            int n;
            int n2;
            Vector<Object> vector;
            DataInputStream dataInputStream;
            ByteArrayInputStream byteArrayInputStream;
            TLV tLV = chatExchangeDesc.description.tlv;
            if (tLV.tlvTypePresent(1)) {
                this.isTree = true;
            }
            if (tLV.tlvTypePresent(211)) {
                this.name = tLV.getTlvDataAsString(211);
            }
            if (tLV.tlvTypePresent(202)) {
                this.creationTime = tLV.getTlvDataAsS32(202);
            }
            if (tLV.tlvTypePresent(2)) {
                int n3 = tLV.getTlvDataAsU16(2);
                this.isForDT = (n3 & 1) != 0;
                this.isForAdmin = (n3 & 2) != 0;
                this.isForAOL = (n3 & 4) != 0;
                this.isForOscarPay = (n3 & 8) != 0;
                boolean bl = this.isForOscarFree = (n3 & 0x10) != 0;
            }
            if (tLV.tlvTypePresent(3)) {
                byte[] byArray = tLV.getTlvData(3);
                this.maxConcurrentRooms = byArray[0];
            }
            if (tLV.tlvTypePresent(4)) {
                byte[] byArray = tLV.getTlvData(4);
                this.maxRoomNameLength = byArray[0];
            }
            if (tLV.tlvTypePresent(210)) {
                this.maxOccupancy = tLV.getTlvDataAsU16(210);
            }
            if (tLV.tlvTypePresent(209)) {
                this.maxOccupancy = tLV.getTlvDataAsU16(209);
            }
            if (tLV.tlvTypePresent(213)) {
                byte[] byArray = tLV.getTlvData(213);
                this.creationPermission = byArray[0];
            }
            if (tLV.tlvTypePresent(5)) {
                byte[] byArray = tLV.getTlvData(5);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                vector = new Vector<Object>();
                try {
                    while (dataInputStream.available() != 0) {
                        ChatRoomID chatRoomID = new ChatRoomID(dataInputStream);
                        vector.addElement(chatRoomID);
                    }
                    n2 = vector.size();
                    this.rootRooms = new ChatRoomID[n2];
                    n = 0;
                    while (n < n2) {
                        this.rootRooms[n] = (ChatRoomID)vector.elementAt(n);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    ErrorMgr.warn(this.MODULE, "Exception reading root room ids in chat exchange description.");
                }
            }
            if (tLV.tlvTypePresent(6)) {
                byte[] byArray = tLV.getTlvData(6);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                vector = new Vector();
                try {
                    while (dataInputStream.available() != 0) {
                        int n4 = dataInputStream.readUnsignedShort();
                        vector.addElement(new Integer(n4));
                    }
                    n2 = vector.size();
                    this.searchTags = new int[n2];
                    n = 0;
                    while (n < n2) {
                        this.searchTags[n] = (Integer)vector.elementAt(n);
                        ++n;
                    }
                    return;
                }
                catch (IOException iOException) {
                    ErrorMgr.warn(this.MODULE, "Exception reading search tags in chat exchange description.");
                    return;
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public boolean getIsTree() {
        return this.isTree;
    }

    public boolean getIsForDT() {
        return this.isForDT;
    }

    public boolean getIsForAdmin() {
        return this.isForAdmin;
    }

    public boolean getIsForAOL() {
        return this.isForAOL;
    }

    public boolean getIsForOscarPay() {
        return this.isForOscarPay;
    }

    public boolean getIsForOscarFree() {
        return this.isForOscarFree;
    }

    public int getMaxConcurrentRooms() {
        return this.maxConcurrentRooms;
    }

    public int getMaxRoomNameLength() {
        return this.maxRoomNameLength;
    }

    public int getMaxOccupancy() {
        return this.maxOccupancy;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public int getCreationPermission() {
        return this.creationPermission;
    }

    public ChatRoomID[] getRootRooms() {
        return this.rootRooms;
    }

    public int[] getSearchTags() {
        return this.searchTags;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCreationTime(int n) {
        this.creationTime = n;
    }

    public void setIsTree(boolean bl) {
        this.isTree = bl;
    }

    public void setIsForDT(boolean bl) {
        this.isForDT = bl;
    }

    public void setIsForAdmin(boolean bl) {
        this.isForAdmin = bl;
    }

    public void setIsForAOL(boolean bl) {
        this.isForAOL = bl;
    }

    public void setIsForOscarPay(boolean bl) {
        this.isForOscarPay = bl;
    }

    public void setIsForOscarFree(boolean bl) {
        this.isForOscarFree = bl;
    }

    public void setMaxConcurrentRooms(int n) {
        this.maxConcurrentRooms = n;
    }

    public void setMaxRoomNameLength(int n) {
        this.maxRoomNameLength = n;
    }

    public void setMaxOccupancy(int n) {
        this.maxOccupancy = n;
    }

    public void setMaxMessageLength(int n) {
        this.maxMessageLength = n;
    }

    public void setCreationPermission(int n) {
        this.creationPermission = n;
    }

    public void setRootRooms(ChatRoomID[] chatRoomIDArray) {
        this.rootRooms = chatRoomIDArray;
    }

    public void setSearchTags(int[] nArray) {
        this.searchTags = nArray;
    }

    public String toString(String string) {
        String string2 = String.valueOf(string) + "id: " + this.id + "\n";
        string2 = String.valueOf(string2) + string + "name: " + this.name + "\n";
        string2 = String.valueOf(string2) + string + "creation time: " + this.creationTime + "\n";
        string2 = String.valueOf(string2) + string + "browsable tree: " + this.isTree + "\n";
        string2 = String.valueOf(string2) + string + "exclusivity: [ ";
        if (this.isForDT) {
            string2 = String.valueOf(string2) + "DT ";
        }
        if (this.isForAdmin) {
            string2 = String.valueOf(string2) + "Admin ";
        }
        if (this.isForAOL) {
            string2 = String.valueOf(string2) + "AOL ";
        }
        if (this.isForOscarPay) {
            string2 = String.valueOf(string2) + "Pay ";
        }
        if (this.isForOscarFree) {
            string2 = String.valueOf(string2) + "Free ";
        }
        string2 = String.valueOf(string2) + "]\n";
        string2 = String.valueOf(string2) + string + "maxConcurrentRooms: " + this.maxConcurrentRooms + "\n";
        string2 = String.valueOf(string2) + string + "maxRoomNameLength: " + this.maxRoomNameLength + "\n";
        string2 = String.valueOf(string2) + string + "maxOccupancy: " + this.maxOccupancy + "\n";
        string2 = String.valueOf(string2) + string + "maxMessageLength: " + this.maxMessageLength + "\n";
        string2 = String.valueOf(string2) + string + "creationPermission: ";
        string2 = this.creationPermission == CREATION_NOT_ALLOWED ? String.valueOf(string2) + "Not allowed\n" : (this.creationPermission == ROOM_CREATION_ALLOWED ? String.valueOf(string2) + "Room creation allowed\n" : (this.creationPermission == EXCHANGE_CREATION_ALLOWED ? String.valueOf(string2) + "Exchange creation allowed\n" : String.valueOf(string2) + "Unknown value\n"));
        string2 = String.valueOf(string2) + string + "root rooms:\n";
        int n = 0;
        while (this.rootRooms != null && n < this.rootRooms.length) {
            string2 = String.valueOf(string2) + n + ") " + this.rootRooms[n].toString(String.valueOf(string) + " ");
            ++n;
        }
        string2 = String.valueOf(string2) + string + "search tags: ";
        int n2 = 0;
        while (this.searchTags != null && n2 < this.searchTags.length) {
            string2 = String.valueOf(string2) + this.searchTags[n2] + " ";
            ++n2;
        }
        string2 = String.valueOf(string2) + "\n";
        return string2;
    }

    static {
        ROOM_CREATION_ALLOWED = 1;
        EXCHANGE_CREATION_ALLOWED = 2;
    }
}

