/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.InviteUI;
import component.InviteUIListener;
import component.MainTool;
import component.OscarLabelButton;
import component.StatusFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Date;
import java.util.Vector;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.Spacer;
import uiutil.TransparentPanel;

public class InviteLookupUI
extends InviteUI
implements ActionListener,
ComponentListener,
InviteUIListener,
TextListener {
    private MainTool invite;
    private TextField emailField;
    private Object userReqId;
    private static String ACTION_LABEL = "Find";

    public InviteLookupUI(MainTool mainTool) {
        super("Find a Buddy", IUtil.format("To find a buddy's name on " + Oscar.FULL_NAME + ", enter that person's e-mail address below.", 60), ACTION_LABEL);
        this.setHelp("When someone becomes a member of " + Oscar.FULL_NAME + ", that person chooses a nickname and registers an e-mail " + "address. Thus, if you know a friend's e-mail address, " + "you may find your friend's nickname by using 'Find a Buddy'.");
        this.invite = mainTool;
        this.userReqId = null;
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        transparentPanel.add("West", new Spacer());
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(1, 0, 0));
        transparentPanel.add("Center", transparentPanel2);
        transparentPanel2.add(new ImageLabel("Email Address:", 3));
        this.emailField = new TextField(24);
        transparentPanel2.add(this.emailField);
        transparentPanel.add("East", new Spacer());
        this.emailField.addActionListener(this);
        this.emailField.addComponentListener(this);
        this.emailField.addTextListener(this);
        this.setContents(transparentPanel);
        this.invite.addInviteUIListener(this);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if ((object.equals(this.emailField) || object instanceof OscarLabelButton && ((OscarLabelButton)object).getLabel().equals(ACTION_LABEL)) && this.userReqId == null) {
            this.userReqId = new Date();
            String string = this.emailField.getText();
            if (string != null && string.length() > 7 && string.indexOf(64) != -1) {
                this.setStatus(StatusFrame.STATUS_WAITING, "Looking up " + string + "...");
                this.invite.lookupBuddy(string, this.userReqId);
                return;
            }
            this.userReqId = null;
            ChoiceUI.newChoiceUI("Alert", "Please enter a valid email address.", Oscar.WARNING_SOUND);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.emailField.requestFocus();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void invitationSent(String string, Object object) {
    }

    public void isMemberButDeclinesToRevealNickname(String string, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "This person is a member.");
            IUtil.playSound(this.invite, "Save");
        }
    }

    public void notAMember(String string, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "This person is not a member.");
            IUtil.playSound(this.invite, "Save");
        }
    }

    public void requestExpired(Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            object = null;
            this.setStatus(StatusFrame.STATUS_FAILURE, "The server did not respond.");
            IUtil.playSound(this.invite, Oscar.ERROR_SOUND);
        }
    }

    public void setNicknamesForEmail(String string, Vector vector, Object object) {
        if (this.userReqId != null && this.userReqId.equals(object)) {
            this.userReqId = null;
            this.setStatus(StatusFrame.STATUS_SUCCESS, "This person is a member.");
            IUtil.playSound(this.invite, "Save");
        }
    }

    public void removeNotify() {
        this.removeAll();
        if (this.invite != null) {
            this.invite.removeInviteUIListener(this);
            this.invite = null;
        }
        this.emailField = null;
        this.userReqId = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.userReqId == null) {
            this.setStatus(StatusFrame.STATUS_NORMAL, "");
        }
    }
}

