/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoNavTool;
import component.ChatProtoNavUIListener;
import component.ChatProtoTool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import main.ChatExchange;
import main.ChatRoom;
import main.Oscar;
import uiutil.ErrorMgr;
import uiutil.OFrame;
import uiutil.Spacer;
import util.Log;

class ChatMonitor
extends OFrame
implements ActionListener,
ChatProtoNavUIListener,
WindowListener {
    private static final String MODULE = "ChatMonitor";
    private static final int CONSOLE_ROWS = 15;
    private static final int CONSOLE_COLS = 45;
    private ChatProtoNavTool chatNavTool;
    private Tools tools;
    private TextField nameField;
    private TextField exchangeField;
    private TextField cookieField;
    private TextField instanceField;
    private Button createButton;
    private Button joinButton;
    private Button rightsButton;
    private TextArea chatConsole;
    private Vector requests;

    public ChatMonitor(ChatProtoNavTool chatProtoNavTool, Tools tools) {
        this.chatNavTool = chatProtoNavTool;
        this.tools = tools;
        this.requests = new Vector();
        this.setTitle("Chat Monitor");
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Chat Console"));
        panel.add("West", new Spacer());
        this.chatConsole = new TextArea(15, 45);
        panel.add("Center", this.chatConsole);
        this.chatConsole.setEditable(false);
        panel.add("East", new Spacer());
        Panel panel2 = new Panel();
        this.add("South", panel2);
        panel2.setLayout(new GridLayout(0, 1));
        panel2.add(new Label("Chat Room Characteristics"));
        panel = new Panel();
        panel2.add(panel);
        panel.setLayout(new FlowLayout(0));
        panel.add(new Spacer());
        panel.add(new Label("       Name:"));
        this.nameField = new TextField(15);
        panel.add(this.nameField);
        panel = new Panel();
        panel2.add(panel);
        panel.setLayout(new FlowLayout(0));
        panel.add(new Spacer());
        panel.add(new Label("Exchange:"));
        this.exchangeField = new TextField(4);
        panel.add(this.exchangeField);
        panel = new Panel();
        panel2.add(panel);
        panel.setLayout(new FlowLayout(0));
        panel.add(new Spacer());
        panel.add(new Label("     Cookie:"));
        this.cookieField = new TextField(15);
        panel.add(this.cookieField);
        panel = new Panel();
        panel2.add(panel);
        panel.setLayout(new FlowLayout(0));
        panel.add(new Spacer());
        panel.add(new Label("  Instance:"));
        this.instanceField = new TextField(4);
        panel.add(this.instanceField);
        panel = new Panel();
        panel2.add(panel);
        this.createButton = new Button("Create Room");
        panel.add(this.createButton);
        this.joinButton = new Button("Join Room");
        panel.add(this.joinButton);
        this.rightsButton = new Button("Get Rights");
        panel.add(this.rightsButton);
        this.createButton.addActionListener(this);
        this.joinButton.addActionListener(this);
        this.rightsButton.addActionListener(this);
        this.pack();
    }

    public void post(String string) {
        this.chatConsole.append(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.createButton)) {
            this.createAction();
            return;
        }
        if (object.equals(this.joinButton)) {
            this.joinAction();
            return;
        }
        if (object.equals(this.rightsButton)) {
            this.rightsAction();
        }
    }

    private void createAction() {
        Log.log(MODULE, Log.DEBUG, "createAction");
        ChatRoom chatRoom = this.getChatRoom();
        if (chatRoom != null) {
            this.chatNavTool.requestRoomCreation(this, chatRoom);
        }
    }

    private void joinAction() {
        Log.log(MODULE, Log.DEBUG, "joinAction");
        ChatProtoTool chatProtoTool = (ChatProtoTool)this.tools.get("tool.chat");
        Integer n = null;
        Integer n2 = null;
        try {
            n = this.getChatExchange();
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn(MODULE, "Please enter a valid exchange number.");
            return;
        }
        try {
            n2 = this.getChatInstance();
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn(MODULE, "Please enter a valid instance number.");
            return;
        }
        byte[] byArray = this.getChatCookie();
        if (byArray == null || byArray.length == 0) {
            ErrorMgr.warn(MODULE, "Please enter a valid cookie.");
            return;
        }
        chatProtoTool.joinRoom(n, byArray, n2);
    }

    private void rightsAction() {
        Log.log(MODULE, Log.DEBUG, "rightsAction");
        this.chatNavTool.requestChatRights(this);
    }

    public void setChatRights(Object object, int n, ChatExchange[] chatExchangeArray) {
        this.requests.removeElement(object);
    }

    public void setExchangeInfo(Object object, ChatExchange chatExchange, ChatRoom[] chatRoomArray) {
    }

    public void setRoomInfo() {
    }

    public void setMoreRoomInfo() {
    }

    public void setOccupantList() {
    }

    public void setRoomSearchResults() {
    }

    public void roomCreated(Object object, ChatRoom chatRoom) {
        this.requests.removeElement(object);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.chatNavTool.clearRequests(this.requests);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private Integer getChatExchange() throws NumberFormatException {
        String string = this.exchangeField.getText();
        Integer n = new Integer(string);
        return n;
    }

    private byte[] getChatCookie() {
        byte[] byArray = null;
        String string = this.cookieField.getText();
        if (string != null && string.length() > 0) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    private Integer getChatInstance() throws NumberFormatException {
        String string = this.instanceField.getText();
        Integer n = new Integer(string);
        return n;
    }

    private ChatRoom getChatRoom() {
        Integer n;
        ChatRoom chatRoom = new ChatRoom();
        try {
            n = this.getChatExchange();
            chatRoom.setExchange(n);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn(MODULE, "Please enter a valid exchange number.");
            return null;
        }
        try {
            n = this.getChatInstance();
            chatRoom.setInstance(n);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn(MODULE, "Please enter a valid instance number.");
            return null;
        }
        chatRoom.setCookie(this.getChatCookie());
        chatRoom.setDetailLevel(1);
        chatRoom.setName(this.nameField.getText());
        if (chatRoom.getName() == null || chatRoom.getName().length() == 0) {
            ErrorMgr.warn(MODULE, "Please enter a name for the chat room.");
            return null;
        }
        return chatRoom;
    }
}

