/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyAttribute;
import component.BuddyCore;
import component.BuddyDisplay;
import component.BuddyList;
import component.Tools;
import component.User;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Image;
import java.util.Vector;
import main.Oscar;
import uiutil.IUtil;

public class BuddyUI
extends Container {
    private static String MODULE = "BuddyUI";
    private BuddyCore core;
    private Tools tools;
    private BuddyDisplay buddyDisplay;
    private boolean showClass;
    private boolean showEvil;
    private boolean showIdleTime;
    private boolean showSignonTime;
    private Image[] classIcons;
    private Image[] logIcons;

    public BuddyUI(BuddyCore buddyCore, Tools tools) {
        this.core = buddyCore;
        this.tools = tools;
        this.classIcons = Oscar.images.getImages(buddyCore, Oscar.images.CLASS_ICON_FILES, this, true);
        this.logIcons = Oscar.images.getImages(buddyCore, Oscar.images.LOG_ICON_FILES, this, false);
        this.setLayout(new BorderLayout());
        this.buddyDisplay = new BuddyDisplay(buddyCore, 12, this.classIcons, this.logIcons);
        this.add("Center", this.buddyDisplay);
    }

    public String getSelectedNickname() {
        return this.buddyDisplay.getSelectedNickname();
    }

    public synchronized void update() {
        BuddyList[] buddyListArray = this.core.getBuddyLists();
        int n = 0;
        while (n < buddyListArray.length) {
            BuddyList buddyList = buddyListArray[n];
            User[] userArray = buddyList.getBuddies();
            if (buddyList.renamed()) {
                this.buddyDisplay.renameBuddyList(buddyList.oldName(), buddyList.name(), buddyList.getBuddiesOnline(), buddyList.getBuddiesTotal());
            }
            if (buddyList.change == BuddyList.CREATED) {
                this.buddyDisplay.addBuddyList(buddyList.name(), buddyList.getBuddiesOnline(), buddyList.getBuddiesTotal());
            } else if (buddyList.change == BuddyList.UPDATED) {
                this.buddyDisplay.updateBuddyListCount(buddyList.name(), buddyList.getBuddiesOnline(), buddyList.getBuddiesTotal());
            } else if (buddyList.change == BuddyList.DELETED) {
                this.buddyDisplay.deleteBuddyList(buddyList.oldName());
            }
            long l = System.currentTimeMillis();
            if (userArray != null) {
                int n2 = 0;
                while (n2 < userArray.length) {
                    if (userArray[n2].changed) {
                        this.updateBuddy(buddyList.name(), userArray[n2], l, this.core.Timeout);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void updateBuddy(String string, User user, long l, long l2) {
        boolean bl = false;
        Vector vector = null;
        int n = 0;
        if (user.status == 3) {
            bl = this.buddyDisplay.deleteBuddy(string, user.name);
        } else if (user.status == 1) {
            if (l - user.logTime < l2) {
                n = 1;
            }
            if ((bl = this.buddyDisplay.addBuddy(string, user, n)) && n == 1 && this.core.getValue(BuddyCore.SOUND_LOGON, true)) {
                IUtil.playSound(this.core, "BuddyArrive");
            }
        } else if (user.status == 0) {
            if (l - user.logTime < l2) {
                vector = this.buddyDisplay.updateBuddy(string, user, -1);
                boolean bl2 = bl = vector != null;
                if (bl && this.core.getValue(BuddyCore.SOUND_LOGOFF, true)) {
                    IUtil.playSound(this.core, "BuddyLeave");
                }
            } else {
                bl = this.buddyDisplay.deleteBuddy(string, user.name);
            }
        }
        if (!bl && user.changed) {
            boolean bl3;
            if (l - user.logTime < l2) {
                n = 1;
            }
            boolean bl4 = this.buddyDisplay.isDim(string, user.name);
            vector = this.buddyDisplay.updateBuddy(string, user, n);
            boolean bl5 = bl3 = !this.buddyDisplay.isDim(string, user.name);
            if (bl4 && bl3 && vector != null && this.core.getValue(BuddyCore.SOUND_LOGON, true)) {
                IUtil.playSound(this.core, "BuddyArrive");
            }
        }
    }

    public void setBuddyAttribute(BuddyAttribute buddyAttribute) {
        this.buddyDisplay.changeAttribute(buddyAttribute.getFont(), buddyAttribute.textFgColor, buddyAttribute.textBgColor, buddyAttribute.textDimColor);
    }

    public boolean addBuddy(String string, User user, int n) {
        return this.buddyDisplay.addBuddy(string, user, n);
    }

    public boolean deleteBuddy(String string, String string2) {
        return this.buddyDisplay.deleteBuddy(string, string2);
    }
}

