/*
 * Decompiled with CFR 0.152.
 */
package module.aolim;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import tool.icbm.AolImEvent;
import tool.icbm.IcbmChannelEvent;
import uiutil.ErrorMgr;
import util.InputBuffer;
import util.OutputBuffer;

public class AolImConverter
implements WhiscerConstants {
    private static final int CHANNEL = 1;
    private static String NAME = "AolImConverter";

    public static IcbmChannelEvent encodeOutgoingEvent(AolImEvent aolImEvent) {
        OutputBuffer outputBuffer;
        String string = aolImEvent.getMessage();
        byte[] byArray = null;
        if (string != null) {
            byArray = string.getBytes();
            try {
                outputBuffer = new OutputBuffer(13 + byArray.length);
                AolImConverter.writeAOLChannelHeader((DataOutputStream)outputBuffer, byArray);
                byArray = outputBuffer.bytes();
            }
            catch (IOException iOException) {
                ErrorMgr.warn((String)NAME, (String)"io exception writing AOL channel header.", (Exception)iOException);
                byArray = null;
            }
        }
        outputBuffer = new IcbmChannelEvent(aolImEvent.getSource(), aolImEvent.getId(), 1, aolImEvent.getNickname(), byArray, aolImEvent.getCookie(), aolImEvent.isAutoResponse());
        return outputBuffer;
    }

    public static AolImEvent decodeIncommingEvent(IcbmChannelEvent icbmChannelEvent) {
        InputBuffer inputBuffer;
        byte[] byArray = icbmChannelEvent.getData();
        String string = null;
        if (byArray != null) {
            try {
                inputBuffer = new InputBuffer(icbmChannelEvent.getData());
                byArray = AolImConverter.readAOLChannelHeader(inputBuffer.d);
                if (byArray == null) {
                    ErrorMgr.warn((String)NAME, (String)("error reading ICBM from " + icbmChannelEvent.getNickname().nickname + " please send log to bug mailing list."));
                    return null;
                }
                string = new String(byArray);
            }
            catch (IOException iOException) {
                ErrorMgr.warn((String)NAME, (String)"io exception reading AOL channel header.", (Exception)iOException);
                string = null;
            }
        }
        inputBuffer = new AolImEvent(icbmChannelEvent.getSource(), icbmChannelEvent.getId(), 1, icbmChannelEvent.getNickname(), string, icbmChannelEvent.getCookie(), icbmChannelEvent.isAutoResponse());
        return inputBuffer;
    }

    private static byte[] readAOLChannelHeader(DataInputStream dataInputStream) throws IOException {
        short s;
        dataInputStream.readByte();
        dataInputStream.readByte();
        int n = dataInputStream.readShort();
        if (n < 1 || n > dataInputStream.available()) {
            return null;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            s = dataInputStream.readByte();
            if (s == 1) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        dataInputStream.readByte();
        dataInputStream.readByte();
        s = dataInputStream.readShort();
        if (s != dataInputStream.available()) {
            return null;
        }
        dataInputStream.readShort();
        dataInputStream.readShort();
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.read(byArray);
        return byArray;
    }

    private static void writeAOLChannelHeader(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        dataOutputStream.writeByte(5);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeShort(4 + byArray.length);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.write(byArray, 0, byArray.length);
    }

    public interface WhiscerConstants {
        public static final int whisc_item_capabilities = 5;
        public static final int capability_version = 1;
        public static final int whisc_capability_text = 1;
        public static final int whisc_item_im_text = 1;
        public static final int im_text_version = 1;
        public static final int intl_encode_ascii = 0;
        public static final int intl_language_english = 0;
    }
}

