/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import main.Oscar;
import module.rendezvous.fileTransfer.FileTransfer;
import module.rendezvous.fileTransfer.FtTLV;
import module.rendezvous.fileTransfer.FxferUI;
import tool.icbm.RendezvousEvent;
import uiutil.ACheckbox;
import uiutil.ACheckboxGroup;
import uiutil.AolRtfArea;
import uiutil.ChoiceUI;
import uiutil.HorizontalRule;
import uiutil.SuperLayout;

class SendPanel
extends Panel
implements ActionListener,
ItemListener {
    private FileTransfer fileTransfer;
    private FxferUI fxferUI;
    private TextField nameField;
    private TextField fileField;
    private AolRtfArea messageArea;
    private String fileName;
    private Button goButton;
    private ACheckboxGroup choiceGroup;
    private ACheckbox sendCheck;
    private ACheckbox getCheck;
    private ACheckbox listCheck;
    private Button browseButton;
    private Button cancelButton;
    private Button helpButton;

    public SendPanel(FileTransfer fileTransfer, FxferUI fxferUI, RendezvousEvent rendezvousEvent) {
        this.fileTransfer = fileTransfer;
        this.fxferUI = fxferUI;
        String string = "choiceL north=SIDE west=SIDE\nsendC north=choiceL west=SIDE\ngetC north=sendC west=SIDE\nlistC north=getC west=SIDE\nhlineH north=listC west=SIDE east=SIDE\nnameL north=hlineH east=20% west=SIDE\nnameTF north=hlineH west=nameL\nfileL north=nameTF east=20% west=SIDE\nfileTF north=nameTF west=fileL\nbrowserB north=nameTF west=fileTF\nmessageL north=fileTF west=SIDE\nmessageTA north=messageL west=SIDE east=SIDE\ngoB north=messageTA west=SIDE\ncancelB north=messageTA west=goB\nhelpB north=messageTA east=SIDE\n";
        SuperLayout superLayout = new SuperLayout();
        this.setLayout((LayoutManager)superLayout);
        this.choiceGroup = new ACheckboxGroup();
        this.add("choiceL", new Label("Select a File Transfer Option: "));
        this.sendCheck = new ACheckbox("Send a file/directory.", this.choiceGroup);
        this.add("sendC", (Component)this.sendCheck);
        this.sendCheck.setState(true);
        this.getCheck = new ACheckbox("Get a file/directory.", this.choiceGroup);
        this.add("getC", (Component)this.getCheck);
        this.listCheck = new ACheckbox("List a buddy's directory.", this.choiceGroup);
        this.add("listC", (Component)this.listCheck);
        this.sendCheck.addItemListener((ItemListener)this);
        this.getCheck.addItemListener((ItemListener)this);
        this.listCheck.addItemListener((ItemListener)this);
        this.add("hlineH", (Component)new HorizontalRule());
        this.add("nameL", new Label("Buddy Name:"));
        this.nameField = new TextField(40);
        this.add("nameTF", this.nameField);
        this.add("fileL", new Label("File/Directory:"));
        this.fileField = new TextField(40);
        this.add("fileTF", this.fileField);
        this.browseButton = new Button("Browse");
        this.add("browserB", this.browseButton);
        String string2 = Oscar.mainTool.getSelectedNickname();
        if (string2 != null) {
            ((TextComponent)this.nameField).setText(string2);
        }
        this.add("messageL", new Label("Message"));
        this.messageArea = new AolRtfArea("messageArea", null, true, true, -1, -1);
        this.add("messageTA", (Component)this.messageArea);
        this.goButton = new Button("Go");
        this.add("goB", this.goButton);
        this.cancelButton = new Button("Cancel");
        this.add("cancelB", this.cancelButton);
        this.helpButton = new Button("Help");
        this.add("helpB", this.helpButton);
        superLayout.setInput(new BufferedReader(new StringReader(string)));
        this.goButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.browseButton.addActionListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object == this.sendCheck) {
            this.fileField.setEditable(true);
            this.browseButton.setEnabled(true);
            this.messageArea.setEditable(true);
            return;
        }
        if (object == this.getCheck) {
            this.fileField.setEditable(true);
            this.browseButton.setEnabled(false);
            this.messageArea.setEnabled(false);
            return;
        }
        if (object == this.listCheck) {
            this.fileField.setEditable(false);
            this.browseButton.setEnabled(false);
            this.messageArea.setEnabled(false);
        }
    }

    private final long getDirSize(String string) {
        return 0L;
    }

    private final int getFileCount(String string) {
        return 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        if (object == this.goButton) {
            String string = this.nameField.getText();
            if (string == null || string.length() < 4) {
                ChoiceUI.newChoiceUI((String)"Error", (String)"You must enter a valid nickname.");
                return;
            }
            String string2 = this.fileField.getText();
            if (this.sendCheck.getState()) {
                if (string2 == null) {
                    ChoiceUI.newChoiceUI((String)"Error", (String)"You must enter a file path.");
                    return;
                }
                File file = new File(string2);
                if (!file.canRead()) {
                    ChoiceUI.newChoiceUI((String)"Error", (String)"Cannot read the given file path.");
                    return;
                }
                if (file.isDirectory()) {
                    n2 = this.getFileCount(string2);
                    l = this.getDirSize(string2);
                    n = FtTLV.SUBTYPE_SEND_DIR;
                } else {
                    n2 = 1;
                    l = file.length();
                    n = FtTLV.SUBTYPE_SEND_FILE;
                }
            } else if (this.getCheck.getState()) {
                if (string2 == null) {
                    ChoiceUI.newChoiceUI((String)"Error", (String)"You must enter a file path.");
                    return;
                }
                n2 = 0;
                l = 0L;
                n = FtTLV.SUBTYPE_GET_FILE;
            } else if (this.listCheck.getState()) {
                n2 = 0;
                l = 0L;
                n = FtTLV.SUBTYPE_GET_LIST;
            }
            this.fileTransfer.sendXferRequest(this.fxferUI.getCookie(), string, n, n2, l, string2, this.messageArea.getTextAsHTML());
            this.fxferUI.dispose();
            return;
        }
        if (object == this.browseButton) {
            FileDialog fileDialog = new FileDialog((Frame)((Object)this.fxferUI), "File", 0);
            ((Component)fileDialog).setVisible(true);
            this.fileName = fileDialog.getFile();
            if (this.fileName != null) {
                ((TextComponent)this.fileField).setText(String.valueOf(fileDialog.getDirectory()) + this.fileName);
            }
            fileDialog.dispose();
            return;
        }
        if (object == this.cancelButton) {
            this.fileTransfer.sendCancel(this.fxferUI.getCookie(), this.nameField.getText());
            this.fxferUI.dispose();
            return;
        }
        if (object == this.helpButton) {
            ChoiceUI.newChoiceUI((String)"Help", (String)"Enter the name of the buddy with whom you want to initiate a file transfer action in the `To:' field. In the `File:' field, enter the full path to the file or directory you want to send. If retrieving a file, simply enter just the file name or if you want to retrieve all files in a buddy's designated upload directory, enter a `*'. If sending a file or directory you can use the browse button to get the path to the file or directory. Finally, press the appropriate buttons to send, get, or list files. \n");
        }
    }
}

