/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.FolderInfo;
import component.SetupUI;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import main.Nickname;
import main.Oscar;
import module.Module;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.ImProps;
import module.aolim.ui.ImUI;
import module.aolim.ui.ImWindowProps;
import tool.BlockEvent;
import tool.EvilEvent;
import tool.ToolStatusEvent;
import tool.ToolStatusListener;
import tool.icbm.AolImEvent;
import tool.icbm.AolImListener;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmSubModule;
import tool.icbm.IcbmTool;
import uiutil.ChangeListener;
import uiutil.ColorSelector;
import uiutil.PropertySheet;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.JUtil;
import util.KeyBindings;

public class UiBean
implements IcbmSubModule,
AolImListener,
UIPack,
ToolStatusListener {
    private static final String MODULE = "ImUiBean";
    private static final String MODULE_NAME = "aolim.ui";
    private static final String[] UIPACK_NAMES = new String[]{"aolim.ui", "icbm.aolim", "tool.icbm"};
    private static final String DISPLAY_NAME = "AOL IM UI";
    public static String INITIATE = "INITATE";
    public static String INTERACTIVE = "INTERACTIVE";
    private Hashtable uis = new Hashtable();
    private ImAttribute icbmAttribute;
    EventBus eventBus;
    EventBus systemBus;
    static /* synthetic */ Class class$tool$ToolStatusEvent;
    static /* synthetic */ Class class$tool$icbm$AolImEvent;
    static /* synthetic */ Class class$tool$icbm$IcbmRateEvent;

    public UiBean() {
        this.loadImAttribute();
        this.systemBus = EventBus.joinBus((String)EventBus.SYSTEM_BUS);
        this.systemBus.addListenerFor((EventListener)((Object)this), class$tool$ToolStatusEvent != null ? class$tool$ToolStatusEvent : (class$tool$ToolStatusEvent = UiBean.class$("tool.ToolStatusEvent")));
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)((Object)this), class$tool$icbm$AolImEvent != null ? class$tool$icbm$AolImEvent : (class$tool$icbm$AolImEvent = UiBean.class$("tool.icbm.AolImEvent")));
    }

    void removeUI(ImUI imUI, String string) {
        this.uis.remove(String.valueOf(Nickname.normalize((String)imUI.getNickname())) + string);
        this.systemBus.removeListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
        this.eventBus.removeListenerFor((EventListener)imUI, class$tool$icbm$AolImEvent != null ? class$tool$icbm$AolImEvent : (class$tool$icbm$AolImEvent = UiBean.class$("tool.icbm.AolImEvent")));
    }

    ImAttribute getImAttribute() {
        return this.icbmAttribute;
    }

    private final void loadImAttribute() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(IcbmTool.IM_KEY);
        int n = 0;
        this.icbmAttribute = new ImAttribute();
        String string = keyBindings.getValue(IcbmTool.FONT_NAME_KEY);
        if (string != null) {
            this.icbmAttribute.fontName = string;
        }
        if ((string = keyBindings.getValue(IcbmTool.FONT_STYLE_KEY)) != null) {
            this.icbmAttribute.fontStyle = string.equalsIgnoreCase("bold") ? 1 : (string.equalsIgnoreCase("italic") ? 2 : (string.equalsIgnoreCase("bold italic") ? 3 : 0));
        }
        if ((string = keyBindings.getValue(IcbmTool.FONT_SIZE_KEY)) != null) {
            n = Integer.parseInt(string);
        }
        if (n < 8 || n > 24) {
            n = 12;
        }
        this.icbmAttribute.fontSize = n / 2 * 2;
        string = keyBindings.getValue(IcbmTool.FONT_FG_COLOR_KEY);
        if (string != null) {
            this.icbmAttribute.textFgColor = ColorSelector.getColor((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.FONT_BG_COLOR_KEY)) != null) {
            this.icbmAttribute.textBgColor = ColorSelector.getColor((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.LOCAL_NAME_COLOR_KEY)) != null) {
            this.icbmAttribute.myNameColor = ColorSelector.getColor((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.REMOTE_NAME_COLOR_KEY)) != null) {
            this.icbmAttribute.otherNameColor = ColorSelector.getColor((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.WINDOW_COLOR_KEY)) != null) {
            this.icbmAttribute.windowColor = ColorSelector.getColor((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.SEND_SOUND_KEY)) != null) {
            this.icbmAttribute.playSendSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.RECEIVE_SOUND_KEY)) != null) {
            this.icbmAttribute.playReceiveSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.RING_SOUND_KEY)) != null) {
            this.icbmAttribute.playRingSound = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.TIMESTAMP_KEY)) != null) {
            this.icbmAttribute.viewTimeStamps = JUtil.isTrue((String)string);
        }
        if ((string = keyBindings.getValue(IcbmTool.ENTER_KEY)) != null) {
            this.icbmAttribute.enterKeyInserts = JUtil.isTrue((String)string);
        }
    }

    void attributeChanged() {
        Enumeration enumeration = this.uis.keys();
        while (enumeration.hasMoreElements()) {
            ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
            imUI.setImAttribute(this.icbmAttribute);
        }
    }

    void sendEvil(String string, boolean bl) {
        EvilEvent evilEvent = new EvilEvent((Object)this, 1110, new Nickname(string), bl);
        this.systemBus.postEvent((EventBusEvent)evilEvent);
    }

    void block(String string) {
        BlockEvent blockEvent = new BlockEvent((Object)this, 1120, new Nickname(string));
        this.systemBus.postEvent((EventBusEvent)blockEvent);
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[3];
        folderInfoArray[0] = new FolderInfo((Module)this, 0, "IM", "Visual");
        folderInfoArray[1] = new FolderInfo((Module)this, 1, "IM", "General");
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        switch (folderInfo.getFolderId()) {
            case 0: {
                return new ImWindowProps(this, (ChangeListener)setupUI);
            }
            case 1: {
                return new ImProps(this, (ChangeListener)setupUI);
            }
        }
        return null;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void receiveMessage(AolImEvent aolImEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(aolImEvent.getNickname().normalize()) + INTERACTIVE);
        if (imUI == null) {
            imUI = new ImUI(this);
            this.systemBus.addListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
            this.uis.put(String.valueOf(aolImEvent.getNickname().normalize()) + INTERACTIVE, imUI);
        }
        imUI.receive(aolImEvent.getNickname().nickname, aolImEvent.getMessage(), 1);
    }

    public void sendMessage(AolImEvent aolImEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(aolImEvent.getNickname().normalize()) + "INTERACTIVE");
        if (imUI != null) {
            imUI.receive(Oscar.nickname, aolImEvent.getMessage(), -1);
        }
    }

    public void sendMessage(String string, String string2) {
        AolImEvent aolImEvent = new AolImEvent((Object)this, 1101, 1, new Nickname(string), string2);
        this.eventBus.postEvent((EventBusEvent)aolImEvent);
    }

    public void initiateMessage(AolImEvent aolImEvent) {
        ImUI imUI = (ImUI)this.uis.get(String.valueOf(aolImEvent.getNickname().normalize()) + INITIATE);
        if (imUI == null) {
            imUI = (ImUI)this.uis.get(String.valueOf(aolImEvent.getNickname().normalize()) + INTERACTIVE);
        }
        if (imUI == null) {
            imUI = new ImUI(this);
            this.systemBus.addListenerFor((EventListener)imUI, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = UiBean.class$("tool.icbm.IcbmRateEvent")));
            this.uis.put(String.valueOf(aolImEvent.getNickname().normalize()) + INITIATE, imUI);
        }
        imUI.initiate(aolImEvent.getNickname().nickname);
    }

    public void payloadError(AolImEvent aolImEvent) {
    }

    public void channelError(AolImEvent aolImEvent) {
    }

    public void connect(ToolStatusEvent toolStatusEvent) {
    }

    public void disconnect(ToolStatusEvent toolStatusEvent) {
    }

    public void enableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
                imUI.setEnabled(true);
            }
        }
    }

    public void disableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            Enumeration enumeration = this.uis.keys();
            while (enumeration.hasMoreElements()) {
                ImUI imUI = (ImUI)this.uis.get(enumeration.nextElement());
                imUI.setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

