/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.SLCommandHandler;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import main.Oscar;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.UiBean;
import module.aolim.ui.ZapUI;
import tool.RateEvent;
import tool.RateListener;
import uiutil.AolRtfArea;
import uiutil.AolRtfListener;
import uiutil.ColorSelector;
import uiutil.ColorSelectorListener;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.ImageButton;
import uiutil.ImagePanel;
import uiutil.LedBar;
import uiutil.OFrame;
import uiutil.SuperLayout;
import uiutil.TransparentPanel;
import uiutil.UIPack;

public class ImUI
extends OFrame
implements AolRtfListener,
ColorSelectorListener,
RateListener,
ActionListener {
    private static String MODULE = "ImUI";
    protected static final int START = 0;
    protected static final int INITIATE = 1;
    protected static final int RECEIVE = 2;
    protected static final int INTERACTIVE = 3;
    public static final int OUTGOING = -1;
    public static final int SYSTEM = 0;
    public static final int INCOMMING = 1;
    private UiBean uibean;
    private TextField nicknameField;
    private String nickname;
    private AolRtfArea inputArea;
    private AolRtfArea dialogArea;
    private ImagePanel main;
    private TransparentPanel center;
    private TransparentPanel upper;
    private ImagePanel lower;
    private Component sendButton;
    private Component cancelButton;
    private Component locateButton;
    private Component foregroundButton;
    private Component backgroundButton;
    private Component smallerButton;
    private Component normalButton;
    private Component largerButton;
    private ImageButton boldButton;
    private ImageButton italicsButton;
    private ImageButton underlineButton;
    private SuperLayout sl;
    private Component zapButton;
    private ZapUI zapUI;
    private LedBar rateIndicator = new LedBar();
    private Image tile;
    private int mode;
    private boolean disabled = false;
    private int height;
    private ImAttribute attribute;
    private String localNameColor;
    private String remoteNameColor;
    private int htmlSize = 1;
    DateFormat timeFormat = DateFormat.getTimeInstance(3);

    public ImUI(UiBean uiBean) {
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        this.uibean = uiBean;
        this.mode = 0;
        ((Frame)((Object)this)).setTitle("IM");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.main = new ImagePanel();
        ((Container)((Object)this)).add("Center", (Component)this.main);
        this.main.setLayout(new BorderLayout());
        this.attribute = uiBean.getImAttribute();
        this.effectAttributeChange();
        this.timeFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.disabled = !bl;
        if (this.sendButton != null) {
            this.sendButton.setEnabled(bl);
        }
        if (this.zapButton != null) {
            this.zapButton.setEnabled(bl);
        }
        if (this.zapUI != null) {
            this.zapUI.setEnabled(bl);
        }
        if (this.locateButton != null) {
            this.locateButton.setEnabled(bl);
        }
        if (this.disabled) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            return;
        }
        ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
    }

    public void setImAttribute(ImAttribute imAttribute) {
        this.attribute = imAttribute;
        this.effectAttributeChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.zapButton) {
            this.zapButtonAction();
            return;
        }
        if (object == this.sendButton) {
            this.sendButtonAction();
            return;
        }
        if (object == this.cancelButton) {
            this.dispose();
            return;
        }
        if (object == this.locateButton) {
            this.locateButtonAction();
            return;
        }
        if (object == this.nicknameField) {
            this.nicknameField.transferFocus();
            return;
        }
        if (object == this.foregroundButton) {
            new ColorSelector((ColorSelectorListener)this, "Set the forground color", Color.black, Color.white, true);
            return;
        }
        if (object == this.backgroundButton) {
            new ColorSelector((ColorSelectorListener)this, "Set the background color", Color.black, Color.white, false);
            return;
        }
        if (object == this.smallerButton) {
            this.inputArea.shrinkFont();
            return;
        }
        if (object == this.normalButton) {
            this.inputArea.resetFontSize();
            return;
        }
        if (object == this.largerButton) {
            this.inputArea.enlargeFont();
            return;
        }
        if (object == this.boldButton) {
            if (this.boldButton.isDown()) {
                this.inputArea.setStyle('b', true);
                return;
            }
            this.inputArea.setStyle('b', false);
            return;
        }
        if (object == this.italicsButton) {
            if (this.italicsButton.isDown()) {
                this.inputArea.setStyle('i', true);
                return;
            }
            this.inputArea.setStyle('i', false);
            return;
        }
        if (object == this.underlineButton) {
            if (this.underlineButton.isDown()) {
                this.inputArea.setStyle('u', true);
                return;
            }
            this.inputArea.setStyle('u', false);
        }
    }

    private final void effectAttributeChange() {
        this.localNameColor = IUtil.getStringFromColor((Color)this.attribute.myNameColor);
        this.remoteNameColor = IUtil.getStringFromColor((Color)this.attribute.otherNameColor);
        this.htmlSize = this.attribute.fontSize < 14 ? this.attribute.fontSize / 8 + this.attribute.fontSize % 8 / 2 : (this.attribute.fontSize >= 14 && this.attribute.fontSize < 20 ? 4 : 5);
        this.alterAolRtfAreas();
    }

    private final void alterAolRtfAreas() {
        if (this.dialogArea != null) {
            this.dialogArea.setWindowColor(this.attribute.windowColor);
        }
        AolRtfArea.setDefaultFont((String)this.attribute.fontName, (int)this.attribute.fontSize);
        AolRtfArea.setDefaultColor((Color)this.attribute.textFgColor, (Color)this.attribute.textBgColor);
        if (this.inputArea != null) {
            this.inputArea.setWindowColor(this.attribute.windowColor);
            if (this.attribute.fontStyle == 1) {
                this.inputArea.setStyle('b', true);
                return;
            }
            if (this.attribute.fontStyle == 2) {
                this.inputArea.setStyle('i', true);
                return;
            }
            if (this.attribute.fontStyle == 3) {
                this.inputArea.setStyle('b', true);
                this.inputArea.setStyle('i', true);
                return;
            }
            this.inputArea.setStyle('b', false);
            this.inputArea.setStyle('i', false);
        }
    }

    public void addMessage(String string, String string2, int n) {
        String string3 = "#0000FF";
        if (n == 1) {
            if (this.attribute.playReceiveSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Receive");
            }
            string3 = this.remoteNameColor;
        } else if (n == -1) {
            if (this.attribute.playSendSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Send");
            }
            string3 = this.localNameColor;
        } else if (n == 0) {
            if (this.attribute.playReceiveSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Receive");
            }
            string3 = "#00FF00";
        }
        String string4 = "";
        if (this.attribute.viewTimeStamps) {
            string4 = " (" + this.timeFormat.format(new Date()) + ")";
        }
        String string5 = "";
        String string6 = "";
        if (this.attribute.fontStyle == 1) {
            string5 = "<B>";
            string6 = "</B>";
        } else if (this.attribute.fontStyle == 2) {
            string5 = "<I>";
            string6 = "</I>";
        } else if (this.attribute.fontStyle == 3) {
            string5 = "<B><I>";
            string6 = "</B></I>";
        }
        this.dialogArea.appendHTML("<FONT COLOR=\"" + string3 + "\" SIZE=" + this.htmlSize + ">" + string5 + string + string4 + string6 + ":   </FONT>" + string2 + "<BR>");
    }

    private String bedeck(String string, String string2, String string3, String string4) {
        if (string2 == null) {
            return string;
        }
        if (string.indexOf("<B>") >= 0 || string.indexOf("<I>") >= 0 || string.indexOf("<U>") >= 0) {
            return string;
        }
        String string5 = "";
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        int n2 = n + string2.length();
        string5 = String.valueOf(string.substring(0, n)) + string3 + string2 + string4 + string.substring(n2, string.length());
        return string5;
    }

    public void getControlButtons() {
        this.foregroundButton = this.sl.getLayoutComponent("Fg");
        SLCommandHandler.addActionListener((Component)this.foregroundButton, (ActionListener)this);
        this.backgroundButton = this.sl.getLayoutComponent("Bg");
        SLCommandHandler.addActionListener((Component)this.backgroundButton, (ActionListener)this);
        this.smallerButton = this.sl.getLayoutComponent("Small");
        SLCommandHandler.addActionListener((Component)this.smallerButton, (ActionListener)this);
        this.normalButton = this.sl.getLayoutComponent("Normal");
        SLCommandHandler.addActionListener((Component)this.normalButton, (ActionListener)this);
        this.largerButton = this.sl.getLayoutComponent("Big");
        SLCommandHandler.addActionListener((Component)this.largerButton, (ActionListener)this);
        this.boldButton = (ImageButton)this.sl.getLayoutComponent("Bold");
        this.boldButton.setFocusTraversable(false);
        this.boldButton.addActionListener((ActionListener)this);
        this.boldButton.setSticky(true);
        this.italicsButton = (ImageButton)this.sl.getLayoutComponent("Italic");
        this.italicsButton.setFocusTraversable(false);
        this.italicsButton.addActionListener((ActionListener)this);
        this.italicsButton.setSticky(true);
        this.underlineButton = (ImageButton)this.sl.getLayoutComponent("Under");
        this.underlineButton.setFocusTraversable(false);
        this.underlineButton.addActionListener((ActionListener)this);
        this.underlineButton.setSticky(true);
    }

    public void dispose() {
        ((Component)((Object)this)).setVisible(false);
        if (this.mode == 1) {
            this.uibean.removeUI(this, UiBean.INITIATE);
        } else {
            this.uibean.removeUI(this, UiBean.INTERACTIVE);
        }
        super.dispose();
    }

    public String getNickname() {
        return this.nickname;
    }

    public void initiate(String string) {
        if (this.mode == 0) {
            this.sl = new SuperLayout((Container)this.main, (UIPack)this.uibean);
            this.main.setLayout((LayoutManager)this.sl);
            this.nickname = string;
            if (string == null) {
                string = "";
            }
            this.nicknameField = new TextField(string, 16);
            this.main.add("Nickname", this.nicknameField);
            this.nicknameField.addActionListener(this);
            this.inputArea = new AolRtfArea("InputArea", (AolRtfListener)this, true, true, 10, this.attribute.enterKeyInserts ? 2 : 0);
            this.main.add("InputArea", (Component)this.inputArea);
            this.inputArea.setWindowColor(this.attribute.windowColor);
            this.main.add("RateBar", (Component)this.rateIndicator);
            this.rateIndicator.setSize(170, 22);
            this.sl.loadLayout("initiate.lay");
            this.locateButton = this.sl.getLayoutComponent("Info");
            SLCommandHandler.addActionListener((Component)this.locateButton, (ActionListener)this);
            this.sendButton = this.sl.getLayoutComponent("Send");
            SLCommandHandler.addActionListener((Component)this.sendButton, (ActionListener)this);
            this.cancelButton = this.sl.getLayoutComponent("Cancel");
            SLCommandHandler.addActionListener((Component)this.cancelButton, (ActionListener)this);
            this.getControlButtons();
            this.mode = 1;
            ((Window)((Object)this)).pack();
        }
        ((Component)((Object)this)).setVisible(true);
        if (this.nicknameField != null && string != null && string.length() > 0) {
            this.nicknameField.transferFocus();
        }
    }

    private void locateButtonAction() {
        Tool tool = Tools.getTool((String)"tool.locate");
        if (tool == null) {
            ErrorMgr.warn((String)MODULE, (String)"The Info service is currently unavailable.");
            return;
        }
        Vector<String> vector = new Vector<String>();
        String string = this.nicknameField == null ? "" : this.nicknameField.getText();
        if ((string = Oscar.makeValidNickname((String)string)) == null || string.length() < 1) {
            string = this.nickname;
        }
        if (string == null || string.equals("")) {
            ErrorMgr.warn((String)"icbm", (String)"Please enter a valid nickname.");
            return;
        }
        vector.addElement(string);
        tool.initiate(vector, null);
    }

    public Dimension getPreferredSize() {
        if (this.mode == 1) {
            return new Dimension(300, 200);
        }
        if (this.mode == 2) {
            return new Dimension(300, 200);
        }
        return new Dimension(300, 300);
    }

    private void makeReceiveWindow(String string, String string2) {
        ((Frame)((Object)this)).setTitle("IM From: " + string);
        this.sl = new SuperLayout((Container)this.main, (UIPack)this.uibean);
        this.main.setLayout((LayoutManager)this.sl);
        this.nickname = string;
        this.dialogArea = new AolRtfArea("DialogArea", null, true, false, -1, 0);
        this.dialogArea.setWindowColor(this.attribute.windowColor);
        this.main.add("DisplayArea", (Component)this.dialogArea);
        this.addMessage(string, string2, 1);
        this.main.add("RateBar", (Component)this.rateIndicator);
        this.rateIndicator.setSize(170, 22);
        this.sl.loadLayout("receive.lay");
        this.sendButton = this.sl.getLayoutComponent("Respond");
        SLCommandHandler.addActionListener((Component)this.sendButton, (ActionListener)this);
        this.cancelButton = this.sl.getLayoutComponent("Cancel");
        SLCommandHandler.addActionListener((Component)this.cancelButton, (ActionListener)this);
        this.locateButton = this.sl.getLayoutComponent("Info");
        SLCommandHandler.addActionListener((Component)this.locateButton, (ActionListener)this);
        this.zapButton = this.sl.getLayoutComponent("Zap");
        SLCommandHandler.addActionListener((Component)this.zapButton, (ActionListener)this);
        this.mode = 2;
        ((Window)((Object)this)).pack();
        this.height = ((Component)((Object)this)).getSize().height;
    }

    private void makeInteractiveWindow() {
        int n = ((Component)((Object)this)).getSize().height;
        if (this.sendButton != null) {
            this.sendButton.setVisible(false);
        }
        this.inputArea = new AolRtfArea("InputArea", (AolRtfListener)this, true, true, 10, this.attribute.enterKeyInserts ? 2 : 0);
        this.inputArea.setWindowColor(this.attribute.windowColor);
        this.main.add("InputArea", (Component)this.inputArea);
        this.sl.loadLayout("interactive.lay");
        this.sendButton = this.sl.getLayoutComponent("Send");
        SLCommandHandler.addActionListener((Component)this.sendButton, (ActionListener)this);
        this.getControlButtons();
        this.mode = 3;
        if (n <= this.height) {
            ((Window)((Object)this)).pack();
            return;
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void receive(String string, String string2, int n) {
        if (this.mode == 0) {
            this.makeReceiveWindow(string, string2);
            ((Component)((Object)this)).setVisible(true);
            return;
        }
        if (this.mode != 2 && this.mode != 3) {
            ErrorMgr.diag((String)MODULE, (int)3, (String)("Invalid mode " + this.mode + " during receive."));
            return;
        }
        this.addMessage(string, string2, n);
    }

    private void sendButtonAction() {
        String string = "";
        String string2 = "";
        if (this.attribute.fontStyle == 1) {
            string = "<B>";
            string2 = "</B>";
        } else if (this.attribute.fontStyle == 2) {
            string = "<I>";
            string2 = "</I>";
        } else if (this.attribute.fontStyle == 3) {
            string = "<B><I>";
            string2 = "</B></I>";
        }
        switch (this.mode) {
            case 1: {
                if (this.inputArea.isEmpty()) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a message to send.");
                    return;
                }
                String string3 = this.inputArea.getTextAsHTML();
                String string4 = this.inputArea.getText();
                String string5 = this.nicknameField.getText();
                if ((string5 = Oscar.makeValidNickname((String)string5)) == null || string5.equals("")) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a valid nickname.");
                    return;
                }
                if (this.attribute.playSendSound) {
                    IUtil.playSound((UIPack)this.uibean, (String)"Send");
                }
                String string6 = this.bedeck(string3, string4, string, string2);
                this.uibean.sendMessage(string5, string6);
                this.dispose();
                return;
            }
            case 2: {
                this.makeInteractiveWindow();
                return;
            }
            case 3: {
                if (this.inputArea.isEmpty()) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a message to send.");
                    return;
                }
                String string7 = this.inputArea.getTextAsHTML();
                String string8 = this.inputArea.getText();
                this.inputArea.setHTML("");
                String string9 = this.bedeck(string7, string8, string, string2);
                this.uibean.sendMessage(this.nickname, string9);
                return;
            }
        }
        ErrorMgr.diag((String)MODULE, (int)3, (String)("Unknown mode " + this.mode));
    }

    public void sendKeyPressed() {
        if (this.discardingKeyEvents) {
            return;
        }
        this.sendButtonAction();
    }

    public void setColor(Object object, boolean bl, Color color) {
        if (this.inputArea != null) {
            if (bl) {
                this.inputArea.setFG(color);
                return;
            }
            this.inputArea.setBG(color);
        }
    }

    public void styleUpdate() {
        if (this.inputArea.selectionIsInStyle('u')) {
            this.underlineButton.setPushed();
        } else {
            this.underlineButton.setNormal();
        }
        if (this.inputArea.selectionIsInStyle('i')) {
            this.italicsButton.setPushed();
        } else {
            this.italicsButton.setNormal();
        }
        if (this.inputArea.selectionIsInStyle('b')) {
            this.boldButton.setPushed();
            return;
        }
        this.boldButton.setNormal();
    }

    public void setRate(RateEvent rateEvent) {
        if (this.rateIndicator != null) {
            if (rateEvent.isLimited()) {
                this.rateIndicator.setLimits(rateEvent.getDisconnect(), rateEvent.getClear(), rateEvent.getClear(), rateEvent.getMaxAve());
            } else {
                this.rateIndicator.setLimits(rateEvent.getDisconnect(), rateEvent.getLimit(), rateEvent.getAlert(), rateEvent.getMaxAve());
            }
            this.rateIndicator.setValue(rateEvent.getRate());
        }
    }

    public void zapRemove() {
        this.zapUI = null;
    }

    public void zapButtonAction() {
        if (this.zapUI == null) {
            this.zapUI = new ZapUI(this.uibean, this, this.nickname);
            return;
        }
        this.zapUI.toFront();
    }
}

