/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import main.Oscar;
import module.rendezvous.tester.ReceivePanel;
import module.rendezvous.tester.SendPanel;
import module.rendezvous.tester.Tester;
import snac.TLV;
import tool.icbm.RendezvousEvent;
import uiutil.ChoiceUI;
import uiutil.OFrame;
import uiutil.Spacer;
import util.JUtil;

public class TestUI
extends OFrame {
    public static String MODULE = "RendezvousTestUI";
    private Tester tester;
    private byte[] cookie;
    private Label cookieLabel;
    private SendPanel sendPanel;
    private ReceivePanel receivePanel;
    private Label statusLabel;
    private static final String[] errorMsg = new String[]{"REQUEST_UNSUPPORTED", "REQUEST_DENIED", "REQUEST_IGNORED", "BUSTED_PARAMETERS", "REQUEST_TIMED_OUT", "ONLINE_BUT_NOT_AVAILABLE"};

    public TestUI(Tester tester, RendezvousEvent rendezvousEvent) {
        this.tester = tester;
        this.cookie = rendezvousEvent.getRendezvousCookie();
        ((Frame)((Object)this)).setTitle("Rendezvous Tester");
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        Panel panel = new Panel();
        ((Container)((Object)this)).add("North", panel);
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("Cookie:"));
        this.cookieLabel = new Label(JUtil.bytesToHexString((byte[])this.cookie));
        panel.add(this.cookieLabel);
        panel = new Panel();
        ((Container)((Object)this)).add("Center", panel);
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel.add("North", panel2);
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label("SEND"));
        panel2.add("West", (Component)new Spacer());
        this.sendPanel = new SendPanel(tester, this, rendezvousEvent);
        panel2.add("Center", this.sendPanel);
        panel2 = new Panel();
        panel.add("Center", panel2);
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label("RECEIVE"));
        panel2.add("West", (Component)new Spacer());
        this.receivePanel = new ReceivePanel(tester, this, rendezvousEvent);
        panel2.add("Center", this.receivePanel);
        this.statusLabel = new Label("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
        ((Container)((Object)this)).add("South", this.statusLabel);
        ((Window)((Object)this)).pack();
        this.statusLabel.setText("");
        ((Component)((Object)this)).setVisible(true);
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    private final boolean bytesMatch(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void update(RendezvousEvent rendezvousEvent) {
        if (this.bytesMatch(this.cookie, rendezvousEvent.getRendezvousCookie())) {
            this.receivePanel.update(rendezvousEvent);
        }
    }

    public static void displayChannelError(RendezvousEvent rendezvousEvent) {
        rendezvousEvent.getCookie();
        TLV tLV = rendezvousEvent.getRendezvousParams();
        int n = 0;
        String string = null;
        int n2 = 0;
        while (n2 < 6) {
            if (tLV.tlvTypePresent(n2)) {
                n = n2;
                string = JUtil.bytesToHexString((byte[])tLV.getTlvData(n));
                break;
            }
            ++n2;
        }
        String string2 = "\n";
        ChoiceUI.newChoiceUI((String)"Channel Error", (String)("Channel: " + rendezvousEvent.getChannel() + string2 + "Cookie : " + JUtil.bytesToHexString((byte[])rendezvousEvent.getCookie()) + string2 + "RCookie: " + string + string2 + "Type   : " + errorMsg[n] + string2));
    }
}

