#import "NTMBController.h"
#import "NTMBWindow.h"

@implementation NTMBController

- (void)positionNTMBWindow {
	NSScreen *theScreen = [[NSScreen screens] objectAtIndex: 0];
	NSRect theFrame = [theScreen frame];
	NSRect theVisibleFrame = [theScreen visibleFrame];
	float theMenuBarHeight = theFrame.origin.y + theFrame.size.height - theVisibleFrame.origin.y - theVisibleFrame.size.height;
	theFrame.origin.y += theFrame.size.height - theMenuBarHeight;
	theFrame.size.height = theMenuBarHeight;
	static NTMBWindow *singletonNTMBWindow = nil;
	if (!singletonNTMBWindow) {
		singletonNTMBWindow = [[NTMBWindow alloc] initWithContentRect: theFrame styleMask: NSBorderlessWindowMask backing: NSBackingStoreBuffered defer: NO];
		[singletonNTMBWindow setBackgroundColor: [NSColor colorWithPatternImage: [NSImage imageNamed: @"menubar"]]];
		[singletonNTMBWindow setHasShadow: NO];
		[singletonNTMBWindow orderFront: self];
		[singletonNTMBWindow setSticky: YES];
		[singletonNTMBWindow setAlphaValue:.55];
	}
	[singletonNTMBWindow setLevel: NSMainMenuWindowLevel-1];
	[singletonNTMBWindow setFrame: theFrame display: YES animate: NO];
}

- (BOOL)applicationShouldHandleReopen: (NSApplication*)theApplication 
					hasVisibleWindows: (BOOL)flag {
	[self positionNTMBWindow];
	return NO;
}

- (void)applicationDidFinishLaunching: (NSNotification*)theNotification {
	[self positionNTMBWindow];
}

- (void)applicationDidChangeScreenParameters: (NSNotification*)theNotification {
	[self positionNTMBWindow];
}

@end
