/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*** =================== SAVED SIGNONS CODE =================== ***/

const STRINGS = {};
STRINGS["ach"] = {};
STRINGS["ach"]["hidePasswords"] = "Kan mung me donyo";
STRINGS["ach"]["hidePasswordsAccessKey"] = "P";
STRINGS["ach"]["noMasterPasswordPrompt"] = "Ada imito nyutu mungi me donyo?";
STRINGS["ach"]["showPasswords"] = "Nyut mung me donyo";
STRINGS["ach"]["showPasswordsAccessKey"] = "P";
STRINGS["af"] = {};
STRINGS["af"]["hidePasswords"] = "Verskuil wagwoorde";
STRINGS["af"]["hidePasswordsAccessKey"] = "w";
STRINGS["af"]["noMasterPasswordPrompt"] = "Is u seker dat u die wagwoorde wil wys?";
STRINGS["af"]["showPasswords"] = "Wys wagwoorde";
STRINGS["af"]["showPasswordsAccessKey"] = "w";
STRINGS["an"] = {};
STRINGS["an"]["hidePasswords"] = "Amagar as claus";
STRINGS["an"]["hidePasswordsAccessKey"] = "c";
STRINGS["an"]["noMasterPasswordPrompt"] = "Ye seguro que quiere amostrar as suyas claus?";
STRINGS["an"]["showPasswords"] = "Amostrar as claus";
STRINGS["an"]["showPasswordsAccessKey"] = "A";
STRINGS["ar"] = {};
STRINGS["ar"]["hidePasswords"] = "أخفِ كلمات السر";
STRINGS["ar"]["hidePasswordsAccessKey"] = "خ";
STRINGS["ar"]["noMasterPasswordPrompt"] = "أمتأكّد أنّك تريد عرض كلمات سرّك؟";
STRINGS["ar"]["showPasswords"] = "أظهر كلمات السر";
STRINGS["ar"]["showPasswordsAccessKey"] = "س";
STRINGS["as"] = {};
STRINGS["as"]["hidePasswords"] = "পাছৱাৰ্ডসমূহ লুকাওক";
STRINGS["as"]["hidePasswordsAccessKey"] = "P";
STRINGS["as"]["noMasterPasswordPrompt"] = "আপুনি আপোনাৰ পাছৱাৰ্ড দেখুৱাবলে নিশ্চিত নে?";
STRINGS["as"]["showPasswords"] = "পাছৱাৰ্ডসমূহ দেখুৱাওক";
STRINGS["as"]["showPasswordsAccessKey"] = "P";
STRINGS["ast"] = {};
STRINGS["ast"]["hidePasswords"] = "Anubrir contraseñes";
STRINGS["ast"]["hidePasswordsAccessKey"] = "o";
STRINGS["ast"]["noMasterPasswordPrompt"] = "¿Daveres que quies amosar les tos contraseñes?";
STRINGS["ast"]["showPasswords"] = "Amosar contraseñes";
STRINGS["ast"]["showPasswordsAccessKey"] = "m";
STRINGS["az"] = {};
STRINGS["az"]["hidePasswords"] = "Şifrələri Gizlə";
STRINGS["az"]["hidePasswordsAccessKey"] = "P";
STRINGS["az"]["noMasterPasswordPrompt"] = "Şifrələrinizi göstərmək istədiyinizə əminsinizmi?";
STRINGS["az"]["showPasswords"] = "Şifrələri Göstər";
STRINGS["az"]["showPasswordsAccessKey"] = "P";
STRINGS["be"] = {};
STRINGS["be"]["hidePasswords"] = "Схаваць паролі";
STRINGS["be"]["hidePasswordsAccessKey"] = "п";
STRINGS["be"]["noMasterPasswordPrompt"] = "Вы сапраўды хочаце паказаць вашы паролі?";
STRINGS["be"]["showPasswords"] = "Паказаць паролі";
STRINGS["be"]["showPasswordsAccessKey"] = "п";
STRINGS["bg"] = {};
STRINGS["bg"]["hidePasswords"] = "Скриване на паролите";
STRINGS["bg"]["hidePasswordsAccessKey"] = "С";
STRINGS["bg"]["noMasterPasswordPrompt"] = "Сигурни ли сте, че желаете паролите ви да бъдат показани?";
STRINGS["bg"]["showPasswords"] = "Показване на пароли";
STRINGS["bg"]["showPasswordsAccessKey"] = "П";
STRINGS["bn-BD"] = {};
STRINGS["bn-BD"]["hidePasswords"] = "পাসওয়ার্ড আড়াল";
STRINGS["bn-BD"]["hidePasswordsAccessKey"] = "P";
STRINGS["bn-BD"]["noMasterPasswordPrompt"] = "আপনি কি নিশ্চিত আপনি পাসওয়ার্ড প্রদর্শন করতে চান?";
STRINGS["bn-BD"]["showPasswords"] = "পাসওয়ার্ড প্রদর্শন";
STRINGS["bn-BD"]["showPasswordsAccessKey"] = "P";
STRINGS["bn-IN"] = {};
STRINGS["bn-IN"]["hidePasswords"] = "পাসওয়ার্ড প্রদর্শন করা হবে না";
STRINGS["bn-IN"]["hidePasswordsAccessKey"] = "P";
STRINGS["bn-IN"]["noMasterPasswordPrompt"] = "আপনি কি নিশ্চিতরূপে পাসওয়ার্ড প্রদর্শন করতে ইচ্ছুক?";
STRINGS["bn-IN"]["showPasswords"] = "পাসওয়ার্ড প্রদর্শন করা হবে";
STRINGS["bn-IN"]["showPasswordsAccessKey"] = "P";
STRINGS["br"] = {};
STRINGS["br"]["hidePasswords"] = "Kuzhat ar gerioù-tremen";
STRINGS["br"]["hidePasswordsAccessKey"] = "K";
STRINGS["br"]["noMasterPasswordPrompt"] = "Ha sur oc'h ho peus c'hoant da ziskouez ho kerioù-tremen ?";
STRINGS["br"]["showPasswords"] = "Diskouez ar gerioù-tremen";
STRINGS["br"]["showPasswordsAccessKey"] = "D";
STRINGS["bs"] = {};
STRINGS["bs"]["hidePasswords"] = "Sakrij lozinke";
STRINGS["bs"]["hidePasswordsAccessKey"] = "P";
STRINGS["bs"]["noMasterPasswordPrompt"] = "Da li ste sigurni da želite prikazati vaše lozinke?";
STRINGS["bs"]["showPasswords"] = "Prikaži lozinke";
STRINGS["bs"]["showPasswordsAccessKey"] = "P";
STRINGS["ca"] = {};
STRINGS["ca"]["hidePasswords"] = "Amaga les contrasenyes";
STRINGS["ca"]["hidePasswordsAccessKey"] = "g";
STRINGS["ca"]["noMasterPasswordPrompt"] = "Esteu segur que voleu mostrar les vostres contrasenyes?";
STRINGS["ca"]["showPasswords"] = "Mostra les contrasenyes";
STRINGS["ca"]["showPasswordsAccessKey"] = "s";
STRINGS["cs"] = {};
STRINGS["cs"]["hidePasswords"] = "Skrýt hesla";
STRINGS["cs"]["hidePasswordsAccessKey"] = "h";
STRINGS["cs"]["noMasterPasswordPrompt"] = "Opravdu chcete zobrazit vaše hesla?";
STRINGS["cs"]["showPasswords"] = "Zobrazit hesla";
STRINGS["cs"]["showPasswordsAccessKey"] = "h";
STRINGS["cy"] = {};
STRINGS["cy"]["hidePasswords"] = "Cuddio Cyfrineiriau";
STRINGS["cy"]["hidePasswordsAccessKey"] = "C";
STRINGS["cy"]["noMasterPasswordPrompt"] = "Ydych chi'n siŵr eich bod am ddangos eich cyfrinair?";
STRINGS["cy"]["showPasswords"] = "Dangos Cyfrineiriau";
STRINGS["cy"]["showPasswordsAccessKey"] = "D";
STRINGS["da"] = {};
STRINGS["da"]["hidePasswords"] = "Skjul adgangskoder";
STRINGS["da"]["hidePasswordsAccessKey"] = "d";
STRINGS["da"]["noMasterPasswordPrompt"] = "Er du sikker på, at du vil vise dine adgangskoder?";
STRINGS["da"]["showPasswords"] = "Vis adgangskoder";
STRINGS["da"]["showPasswordsAccessKey"] = "d";
STRINGS["de"] = {};
STRINGS["de"]["hidePasswords"] = "Passwörter ausblenden";
STRINGS["de"]["hidePasswordsAccessKey"] = "w";
STRINGS["de"]["noMasterPasswordPrompt"] = "Sind Sie sicher, dass Sie Ihre Passwörter anzeigen möchten?";
STRINGS["de"]["showPasswords"] = "Passwörter anzeigen";
STRINGS["de"]["showPasswordsAccessKey"] = "P";
STRINGS["dsb"] = {};
STRINGS["dsb"]["hidePasswords"] = "Gronidła schowaś";
STRINGS["dsb"]["hidePasswordsAccessKey"] = "r";
STRINGS["dsb"]["noMasterPasswordPrompt"] = "Cośo napšawdu swóje gronidła pokazaś?";
STRINGS["dsb"]["showPasswords"] = "Gronidła pokazaś";
STRINGS["dsb"]["showPasswordsAccessKey"] = "o";
STRINGS["el"] = {};
STRINGS["el"]["hidePasswords"] = "Απόκρυψη κωδικών";
STRINGS["el"]["hidePasswordsAccessKey"] = "ψ";
STRINGS["el"]["noMasterPasswordPrompt"] = "Είστε σίγουροι ότι θέλετε να εμφανιστούν οι κωδικοί;";
STRINGS["el"]["showPasswords"] = "Εμφάνιση κωδικών";
STRINGS["el"]["showPasswordsAccessKey"] = "φ";
STRINGS["en-GB"] = {};
STRINGS["en-GB"]["hidePasswords"] = "Hide Passwords";
STRINGS["en-GB"]["hidePasswordsAccessKey"] = "P";
STRINGS["en-GB"]["noMasterPasswordPrompt"] = "Are you sure you wish to show your passwords?";
STRINGS["en-GB"]["showPasswords"] = "Show Passwords";
STRINGS["en-GB"]["showPasswordsAccessKey"] = "P";
STRINGS["en-US"] = {};
STRINGS["en-US"]["hidePasswords"] = "Hide Passwords";
STRINGS["en-US"]["hidePasswordsAccessKey"] = "P";
STRINGS["en-US"]["noMasterPasswordPrompt"] = "Are you sure you wish to show your passwords?";
STRINGS["en-US"]["showPasswords"] = "Show Passwords";
STRINGS["en-US"]["showPasswordsAccessKey"] = "P";
STRINGS["en-ZA"] = {};
STRINGS["en-ZA"]["hidePasswords"] = "Hide Passwords";
STRINGS["en-ZA"]["hidePasswordsAccessKey"] = "P";
STRINGS["en-ZA"]["noMasterPasswordPrompt"] = "Are you sure you wish to show your passwords?";
STRINGS["en-ZA"]["showPasswords"] = "Show Passwords";
STRINGS["en-ZA"]["showPasswordsAccessKey"] = "P";
STRINGS["eo"] = {};
STRINGS["eo"]["hidePasswords"] = "Kaŝi pasvortojn";
STRINGS["eo"]["hidePasswordsAccessKey"] = "v";
STRINGS["eo"]["noMasterPasswordPrompt"] = "Ĉu vi certas ke vi volas montri viajn pasvortojn?";
STRINGS["eo"]["showPasswords"] = "Montri pasvortojn";
STRINGS["eo"]["showPasswordsAccessKey"] = "v";
STRINGS["es-AR"] = {};
STRINGS["es-AR"]["hidePasswords"] = "Ocultar contraseñas";
STRINGS["es-AR"]["hidePasswordsAccessKey"] = "O";
STRINGS["es-AR"]["noMasterPasswordPrompt"] = "¿Seguro desea mostrar sus contraseñas?";
STRINGS["es-AR"]["showPasswords"] = "Mostrar contraseñas";
STRINGS["es-AR"]["showPasswordsAccessKey"] = "M";
STRINGS["es-CL"] = {};
STRINGS["es-CL"]["hidePasswords"] = "Ocultar contraseñas";
STRINGS["es-CL"]["hidePasswordsAccessKey"] = "C";
STRINGS["es-CL"]["noMasterPasswordPrompt"] = "¿Está seguro de que desea mostrar sus contraseñas?";
STRINGS["es-CL"]["showPasswords"] = "Mostrar contraseñas";
STRINGS["es-CL"]["showPasswordsAccessKey"] = "C";
STRINGS["es-ES"] = {};
STRINGS["es-ES"]["hidePasswords"] = "Ocultar contraseñas";
STRINGS["es-ES"]["hidePasswordsAccessKey"] = "O";
STRINGS["es-ES"]["noMasterPasswordPrompt"] = "¿Seguro que quiere mostrar sus contraseñas?";
STRINGS["es-ES"]["showPasswords"] = "Mostrar contraseñas";
STRINGS["es-ES"]["showPasswordsAccessKey"] = "M";
STRINGS["es-MX"] = {};
STRINGS["es-MX"]["hidePasswords"] = "Ocultar contraseñas";
STRINGS["es-MX"]["hidePasswordsAccessKey"] = "O";
STRINGS["es-MX"]["noMasterPasswordPrompt"] = "¿Seguro que quieres mostrar tus contraseñas?";
STRINGS["es-MX"]["showPasswords"] = "Mostrar contraseñas";
STRINGS["es-MX"]["showPasswordsAccessKey"] = "M";
STRINGS["et"] = {};
STRINGS["et"]["hidePasswords"] = "Varja paroolid";
STRINGS["et"]["hidePasswordsAccessKey"] = "V";
STRINGS["et"]["noMasterPasswordPrompt"] = "Kas oled kindel, et soovid oma paroole kuvada?";
STRINGS["et"]["showPasswords"] = "Kuva paroole";
STRINGS["et"]["showPasswordsAccessKey"] = "K";
STRINGS["eu"] = {};
STRINGS["eu"]["hidePasswords"] = "Ezkutatu pasahitzak";
STRINGS["eu"]["hidePasswordsAccessKey"] = "z";
STRINGS["eu"]["noMasterPasswordPrompt"] = "Ziur zaude pasahitzak erakutsi nahi dituzula?";
STRINGS["eu"]["showPasswords"] = "Erakutsi pasahitzak";
STRINGS["eu"]["showPasswordsAccessKey"] = "E";
STRINGS["fa"] = {};
STRINGS["fa"]["hidePasswords"] = "مخفی کردن گذرواژه‌ها";
STRINGS["fa"]["hidePasswordsAccessKey"] = "گ";
STRINGS["fa"]["noMasterPasswordPrompt"] = "آیا مطمئنید که می‌خواهید گذرواژه‌هایتان نشان داده شوند؟";
STRINGS["fa"]["showPasswords"] = "نشان دادن گذرواژه‌ها";
STRINGS["fa"]["showPasswordsAccessKey"] = "گ";
STRINGS["ff"] = {};
STRINGS["ff"]["hidePasswords"] = "Suuz Finndeeji";
STRINGS["ff"]["hidePasswordsAccessKey"] = "P";
STRINGS["ff"]["noMasterPasswordPrompt"] = "Aɗa yenanaa yiɗde hollirde finndeeji maa?";
STRINGS["ff"]["showPasswords"] = "Hollu Finndeeji";
STRINGS["ff"]["showPasswordsAccessKey"] = "P";
STRINGS["fi"] = {};
STRINGS["fi"]["hidePasswords"] = "Piilota salasanat";
STRINGS["fi"]["hidePasswordsAccessKey"] = "t";
STRINGS["fi"]["noMasterPasswordPrompt"] = "Näytetäänkö salasanat?";
STRINGS["fi"]["showPasswords"] = "Näytä salasanat";
STRINGS["fi"]["showPasswordsAccessKey"] = "t";
STRINGS["fr"] = {};
STRINGS["fr"]["hidePasswords"] = "Masquer les mots de passe";
STRINGS["fr"]["hidePasswordsAccessKey"] = "M";
STRINGS["fr"]["noMasterPasswordPrompt"] = "Voulez-vous vraiment afficher vos mots de passe ?";
STRINGS["fr"]["showPasswords"] = "Afficher les mots de passe";
STRINGS["fr"]["showPasswordsAccessKey"] = "A";
STRINGS["fy-NL"] = {};
STRINGS["fy-NL"]["hidePasswords"] = "Wachtwurden ferstopje";
STRINGS["fy-NL"]["hidePasswordsAccessKey"] = "W";
STRINGS["fy-NL"]["noMasterPasswordPrompt"] = "Binne jo wis dat jo jo wachtwurden toane wolle?";
STRINGS["fy-NL"]["showPasswords"] = "Wachtwurden toane";
STRINGS["fy-NL"]["showPasswordsAccessKey"] = "W";
STRINGS["ga-IE"] = {};
STRINGS["ga-IE"]["hidePasswords"] = "Folaigh Focail Fhaire";
STRINGS["ga-IE"]["hidePasswordsAccessKey"] = "R";
STRINGS["ga-IE"]["noMasterPasswordPrompt"] = "An bhfuil tú cinnte gur mian leat d'fhocail fhaire a thaispeáint?";
STRINGS["ga-IE"]["showPasswords"] = "Taispeáin Focail Fhaire";
STRINGS["ga-IE"]["showPasswordsAccessKey"] = "R";
STRINGS["gd"] = {};
STRINGS["gd"]["hidePasswords"] = "Falaich na faclan-faire";
STRINGS["gd"]["hidePasswordsAccessKey"] = "P";
STRINGS["gd"]["noMasterPasswordPrompt"] = "A bheil thu cinnteach gu bheil thu airson na faclan-faire agad a shealltainn?";
STRINGS["gd"]["showPasswords"] = "Seall na faclan-faire";
STRINGS["gd"]["showPasswordsAccessKey"] = "P";
STRINGS["gl"] = {};
STRINGS["gl"]["hidePasswords"] = "Agochar os contrasinais";
STRINGS["gl"]["hidePasswordsAccessKey"] = "O";
STRINGS["gl"]["noMasterPasswordPrompt"] = "Confirma que quere amosar os seus contrasinais?";
STRINGS["gl"]["showPasswords"] = "Amosar os contrasinais";
STRINGS["gl"]["showPasswordsAccessKey"] = "M";
STRINGS["gu-IN"] = {};
STRINGS["gu-IN"]["hidePasswords"] = "પાસવર્ડો છુપાવો";
STRINGS["gu-IN"]["hidePasswordsAccessKey"] = "P";
STRINGS["gu-IN"]["noMasterPasswordPrompt"] = "શું તમે ખરેખર તમારા પાસવર્ડો બતાવવા માંગો છો?";
STRINGS["gu-IN"]["showPasswords"] = "પાસવર્ડો બતાવો";
STRINGS["gu-IN"]["showPasswordsAccessKey"] = "P";
STRINGS["he"] = {};
STRINGS["he"]["hidePasswords"] = "הסתר ססמאות";
STRINGS["he"]["hidePasswordsAccessKey"] = "ה";
STRINGS["he"]["noMasterPasswordPrompt"] = "האם אתה בטוח שברצונך להראות את ססמאותיך?";
STRINGS["he"]["showPasswords"] = "הראה ססמאות";
STRINGS["he"]["showPasswordsAccessKey"] = "ה";
STRINGS["hi-IN"] = {};
STRINGS["hi-IN"]["hidePasswords"] = "कूटशब्द छिपाएँ";
STRINGS["hi-IN"]["hidePasswordsAccessKey"] = "P";
STRINGS["hi-IN"]["noMasterPasswordPrompt"] = "क्या आप अपने कूटशब्दों को दिखाना चाहते हैं?";
STRINGS["hi-IN"]["showPasswords"] = "कूटशब्द दिखाएँ";
STRINGS["hi-IN"]["showPasswordsAccessKey"] = "P";
STRINGS["hr"] = {};
STRINGS["hr"]["hidePasswords"] = "Sakrij lozinke";
STRINGS["hr"]["hidePasswordsAccessKey"] = "S";
STRINGS["hr"]["noMasterPasswordPrompt"] = "Jeste li sigurni da želite prikazati svoje lozinke?";
STRINGS["hr"]["showPasswords"] = "Prikaži lozinke";
STRINGS["hr"]["showPasswordsAccessKey"] = "P";
STRINGS["hsb"] = {};
STRINGS["hsb"]["hidePasswords"] = "Hesła schować";
STRINGS["hsb"]["hidePasswordsAccessKey"] = "H";
STRINGS["hsb"]["noMasterPasswordPrompt"] = "Chceće woprawdźe swoje hesła pokazać?";
STRINGS["hsb"]["showPasswords"] = "Hesła pokazać";
STRINGS["hsb"]["showPasswordsAccessKey"] = "H";
STRINGS["hu"] = {};
STRINGS["hu"]["hidePasswords"] = "Jelszavak elrejtése";
STRINGS["hu"]["hidePasswordsAccessKey"] = "J";
STRINGS["hu"]["noMasterPasswordPrompt"] = "Biztosan meg szeretné jeleníteni a jelszavait?";
STRINGS["hu"]["showPasswords"] = "Jelszavak megjelenítése";
STRINGS["hu"]["showPasswordsAccessKey"] = "J";
STRINGS["hy-AM"] = {};
STRINGS["hy-AM"]["hidePasswords"] = "Թաքցնել Գաղտնաբառերը";
STRINGS["hy-AM"]["hidePasswordsAccessKey"] = "P";
STRINGS["hy-AM"]["noMasterPasswordPrompt"] = "Իրո՞ք ցանկանում եք Ձեր գաղտնաբառերը ցուցադրել:";
STRINGS["hy-AM"]["showPasswords"] = "Ցուցադրել Գաղտնաբառերը";
STRINGS["hy-AM"]["showPasswordsAccessKey"] = "P";
STRINGS["id"] = {};
STRINGS["id"]["hidePasswords"] = "Sembunyikan Sandi";
STRINGS["id"]["hidePasswordsAccessKey"] = "S";
STRINGS["id"]["noMasterPasswordPrompt"] = "Yakin ingin menampilkan sandi Anda?";
STRINGS["id"]["showPasswords"] = "Tampilkan Sandi";
STRINGS["id"]["showPasswordsAccessKey"] = "d";
STRINGS["is"] = {};
STRINGS["is"]["hidePasswords"] = "Fela lykilorð";
STRINGS["is"]["hidePasswordsAccessKey"] = "ð";
STRINGS["is"]["noMasterPasswordPrompt"] = "Ertu viss um að viljir sýna þín lykilorð?";
STRINGS["is"]["showPasswords"] = "Sýna lykilorð";
STRINGS["is"]["showPasswordsAccessKey"] = "ð";
STRINGS["it"] = {};
STRINGS["it"]["hidePasswords"] = "Nascondi password";
STRINGS["it"]["hidePasswordsAccessKey"] = "N";
STRINGS["it"]["noMasterPasswordPrompt"] = "Visualizzare le password memorizzate?";
STRINGS["it"]["showPasswords"] = "Mostra password";
STRINGS["it"]["showPasswordsAccessKey"] = "M";
STRINGS["ja"] = {};
STRINGS["ja"]["hidePasswords"] = "パスワードを隠す";
STRINGS["ja"]["hidePasswordsAccessKey"] = "P";
STRINGS["ja"]["noMasterPasswordPrompt"] = "パスワードを表示しますか？";
STRINGS["ja"]["showPasswords"] = "パスワードを表示する";
STRINGS["ja"]["showPasswordsAccessKey"] = "P";
STRINGS["ja-JP-mac"] = {};
STRINGS["ja-JP-mac"]["hidePasswords"] = "パスワードを隠す";
STRINGS["ja-JP-mac"]["hidePasswordsAccessKey"] = "P";
STRINGS["ja-JP-mac"]["noMasterPasswordPrompt"] = "パスワードを表示しますか？";
STRINGS["ja-JP-mac"]["showPasswords"] = "パスワードを表示する";
STRINGS["ja-JP-mac"]["showPasswordsAccessKey"] = "P";
STRINGS["kk"] = {};
STRINGS["kk"]["hidePasswords"] = "Парольдерді жасыру";
STRINGS["kk"]["hidePasswordsAccessKey"] = "ж";
STRINGS["kk"]["noMasterPasswordPrompt"] = "Барлық парольдеріңізді көрсетуді қалайсыз ба?";
STRINGS["kk"]["showPasswords"] = "Парольдерді көрсету";
STRINGS["kk"]["showPasswordsAccessKey"] = "р";
STRINGS["km"] = {};
STRINGS["km"]["hidePasswords"] = "លាក់​ពាក្យសម្ងាត់";
STRINGS["km"]["hidePasswordsAccessKey"] = "ព";
STRINGS["km"]["noMasterPasswordPrompt"] = "តើ​អ្នក​ពិតជា​ចង់​បង្ហាញ​ពាក្យសម្ងាត់​របស់​អ្នក​ឬ ?";
STRINGS["km"]["showPasswords"] = "បង្ហាញ​ពាក្យសម្ងាត់";
STRINGS["km"]["showPasswordsAccessKey"] = "ព";
STRINGS["kn"] = {};
STRINGS["kn"]["hidePasswords"] = "ಗುಪ್ತಪದಗಳನ್ನು ಅಡಗಿಸು";
STRINGS["kn"]["hidePasswordsAccessKey"] = "P";
STRINGS["kn"]["noMasterPasswordPrompt"] = "ನಿಮ್ಮ ಗುಪ್ತಪದಗಳನ್ನು ತೋರಿಸಲು ನೀವು ಖಚಿತವಾಗಿಯೂ ಬಯಸುತ್ತೀರ?";
STRINGS["kn"]["showPasswords"] = "ಗುಪ್ತಪದಗಳನ್ನು ತೋರಿಸು";
STRINGS["kn"]["showPasswordsAccessKey"] = "P";
STRINGS["ko"] = {};
STRINGS["ko"]["hidePasswords"] = "암호 숨기기";
STRINGS["ko"]["hidePasswordsAccessKey"] = "P";
STRINGS["ko"]["noMasterPasswordPrompt"] = "정말 암호를 보이게 하시겠습니까?";
STRINGS["ko"]["showPasswords"] = "암호 보이기";
STRINGS["ko"]["showPasswordsAccessKey"] = "P";
STRINGS["lij"] = {};
STRINGS["lij"]["hidePasswords"] = "Ascondi e paròlle segrete";
STRINGS["lij"]["hidePasswordsAccessKey"] = "A";
STRINGS["lij"]["noMasterPasswordPrompt"] = "T'ê seguo che ti veu fâ vedde e teu paròlle segrete?";
STRINGS["lij"]["showPasswords"] = "Fanni vedde e paròlle segrete";
STRINGS["lij"]["showPasswordsAccessKey"] = "F";
STRINGS["lt"] = {};
STRINGS["lt"]["hidePasswords"] = "Nerodyti slaptažodžių";
STRINGS["lt"]["hidePasswordsAccessKey"] = "N";
STRINGS["lt"]["noMasterPasswordPrompt"] = "Ar tikrai parodyti slaptažodžius?";
STRINGS["lt"]["showPasswords"] = "Rodyti slaptažodžius";
STRINGS["lt"]["showPasswordsAccessKey"] = "R";
STRINGS["lv"] = {};
STRINGS["lv"]["hidePasswords"] = "Slēpt paroles";
STRINGS["lv"]["hidePasswordsAccessKey"] = "P";
STRINGS["lv"]["noMasterPasswordPrompt"] = "Vai tiešām vēlaties rādīt savas paroles?";
STRINGS["lv"]["showPasswords"] = "Rādīt paroles";
STRINGS["lv"]["showPasswordsAccessKey"] = "P";
STRINGS["mai"] = {};
STRINGS["mai"]["hidePasswords"] = "कूटशब्द नुकाउ";
STRINGS["mai"]["hidePasswordsAccessKey"] = "P";
STRINGS["mai"]["noMasterPasswordPrompt"] = "की अहाँ अपन कूटशब्दकेँ देखाबै चाहैत छी?";
STRINGS["mai"]["showPasswords"] = "कूटशब्द देखाउ";
STRINGS["mai"]["showPasswordsAccessKey"] = "P";
STRINGS["mk"] = {};
STRINGS["mk"]["hidePasswords"] = "Скриј ги лозинките";
STRINGS["mk"]["hidePasswordsAccessKey"] = "С";
STRINGS["mk"]["noMasterPasswordPrompt"] = "Сигурно сакате да ги покажете Вашите лозинки?";
STRINGS["mk"]["showPasswords"] = "Покажи ги лозинките";
STRINGS["mk"]["showPasswordsAccessKey"] = "л";
STRINGS["ml"] = {};
STRINGS["ml"]["hidePasswords"] = "പാസ്‌വേര്‍ഡ് ഒളിപ്പിക്കുക";
STRINGS["ml"]["hidePasswordsAccessKey"] = "P";
STRINGS["ml"]["noMasterPasswordPrompt"] = "താങ്കളുടെ പാസ്‌വേര്‍ഡ് കാണിക്കണം എന്നു് ഉറപ്പാണോ?";
STRINGS["ml"]["showPasswords"] = "പാസ്‌വേര്‍ഡുകള്‍ കാണിക്കുക\u0020";
STRINGS["ml"]["showPasswordsAccessKey"] = "P";
STRINGS["mr"] = {};
STRINGS["mr"]["hidePasswords"] = "गुप्तशब्द लपवा";
STRINGS["mr"]["hidePasswordsAccessKey"] = "P";
STRINGS["mr"]["noMasterPasswordPrompt"] = "तुम्हाला नक्की गुप्तशब्द दर्शवायचे?";
STRINGS["mr"]["showPasswords"] = "गुप्तशब्द दर्शवा";
STRINGS["mr"]["showPasswordsAccessKey"] = "P";
STRINGS["ms"] = {};
STRINGS["ms"]["hidePasswords"] = "Sorok Katalaluan";
STRINGS["ms"]["hidePasswordsAccessKey"] = "P";
STRINGS["ms"]["noMasterPasswordPrompt"] = "Adakah anda pasti yang anda ingin tunjukkan katalaluan anda?";
STRINGS["ms"]["showPasswords"] = "Tunjuk Katalaluan";
STRINGS["ms"]["showPasswordsAccessKey"] = "P";
STRINGS["nb-NO"] = {};
STRINGS["nb-NO"]["hidePasswords"] = "Skjul passord";
STRINGS["nb-NO"]["hidePasswordsAccessKey"] = "k";
STRINGS["nb-NO"]["noMasterPasswordPrompt"] = "Er du sikker på at du vil vise passordene dine?";
STRINGS["nb-NO"]["showPasswords"] = "Vis passord";
STRINGS["nb-NO"]["showPasswordsAccessKey"] = "V";
STRINGS["nl"] = {};
STRINGS["nl"]["hidePasswords"] = "Wachtwoorden verbergen";
STRINGS["nl"]["hidePasswordsAccessKey"] = "W";
STRINGS["nl"]["noMasterPasswordPrompt"] = "Weet u zeker dat u uw wachtwoorden wilt tonen?";
STRINGS["nl"]["showPasswords"] = "Wachtwoorden tonen";
STRINGS["nl"]["showPasswordsAccessKey"] = "W";
STRINGS["nn-NO"] = {};
STRINGS["nn-NO"]["hidePasswords"] = "Gøym passord";
STRINGS["nn-NO"]["hidePasswordsAccessKey"] = "k";
STRINGS["nn-NO"]["noMasterPasswordPrompt"] = "Er du sikker på at du vil visa passorda dine?";
STRINGS["nn-NO"]["showPasswords"] = "Vis passord";
STRINGS["nn-NO"]["showPasswordsAccessKey"] = "V";
STRINGS["or"] = {};
STRINGS["or"]["hidePasswords"] = "ପ୍ରବେଶ ସଂକେତ ଲୁଚାନ୍ତୁ";
STRINGS["or"]["hidePasswordsAccessKey"] = "P";
STRINGS["or"]["noMasterPasswordPrompt"] = "ଆପଣ ନିଶ୍ଚିତ କି ଆପଣ ଆପଣଙ୍କର ପ୍ରବେଶ ସଂକେତ ଦର୍ଶାଇବାକୁ ଚାହୁଁଛନ୍ତି?";
STRINGS["or"]["showPasswords"] = "ପ୍ରବେଶ ସଂକେତ ଦର୍ଶାନ୍ତୁ";
STRINGS["or"]["showPasswordsAccessKey"] = "P";
STRINGS["pa-IN"] = {};
STRINGS["pa-IN"]["hidePasswords"] = "ਪਾਸਵਰਡ ਓਹਲੇ";
STRINGS["pa-IN"]["hidePasswordsAccessKey"] = "P";
STRINGS["pa-IN"]["noMasterPasswordPrompt"] = "ਕੀ ਤੁਸੀਂ ਆਪਣੇ ਪਾਸਵਰਡ ਵੇਖਣੇ ਚਾਹੁੰਦੇ ਹੋ?";
STRINGS["pa-IN"]["showPasswords"] = "ਪਾਸਵਰਡ ਵੇਖੋ";
STRINGS["pa-IN"]["showPasswordsAccessKey"] = "P";
STRINGS["pl"] = {};
STRINGS["pl"]["hidePasswords"] = "Ukryj hasła";
STRINGS["pl"]["hidePasswordsAccessKey"] = "h";
STRINGS["pl"]["noMasterPasswordPrompt"] = "Czy na pewno wyświetlić hasła?";
STRINGS["pl"]["showPasswords"] = "Wyświetl hasła";
STRINGS["pl"]["showPasswordsAccessKey"] = "h";
STRINGS["pt-BR"] = {};
STRINGS["pt-BR"]["hidePasswords"] = "Ocultar senhas";
STRINGS["pt-BR"]["hidePasswordsAccessKey"] = "O";
STRINGS["pt-BR"]["noMasterPasswordPrompt"] = "Tem certeza que deseja exibir as suas senhas?";
STRINGS["pt-BR"]["showPasswords"] = "Exibir senhas";
STRINGS["pt-BR"]["showPasswordsAccessKey"] = "E";
STRINGS["pt-PT"] = {};
STRINGS["pt-PT"]["hidePasswords"] = "Ocultar palavras-passe";
STRINGS["pt-PT"]["hidePasswordsAccessKey"] = "O";
STRINGS["pt-PT"]["noMasterPasswordPrompt"] = "Tem a certeza que deseja mostrar todas as suas palavras-passe?";
STRINGS["pt-PT"]["showPasswords"] = "Mostrar palavras-passe";
STRINGS["pt-PT"]["showPasswordsAccessKey"] = "M";
STRINGS["rm"] = {};
STRINGS["rm"]["hidePasswords"] = "Zuppentar ils pleds-clav";
STRINGS["rm"]["hidePasswordsAccessKey"] = "Z";
STRINGS["rm"]["noMasterPasswordPrompt"] = "Es ti segir che ti vuls laschar mussar tes pleds-clav?";
STRINGS["rm"]["showPasswords"] = "Mussar ils pleds-clav";
STRINGS["rm"]["showPasswordsAccessKey"] = "P";
STRINGS["ro"] = {};
STRINGS["ro"]["hidePasswords"] = "Ascunde parolele";
STRINGS["ro"]["hidePasswordsAccessKey"] = "P";
STRINGS["ro"]["noMasterPasswordPrompt"] = "Sigur doriți să afișați parolele?";
STRINGS["ro"]["showPasswords"] = "Arată parolele";
STRINGS["ro"]["showPasswordsAccessKey"] = "P";
STRINGS["ru"] = {};
STRINGS["ru"]["hidePasswords"] = "Скрыть пароли";
STRINGS["ru"]["hidePasswordsAccessKey"] = "а";
STRINGS["ru"]["noMasterPasswordPrompt"] = "Вы уверены, что хотите отобразить ваши пароли?";
STRINGS["ru"]["showPasswords"] = "Отобразить пароли";
STRINGS["ru"]["showPasswordsAccessKey"] = "а";
STRINGS["si"] = {};
STRINGS["si"]["hidePasswords"] = "රහස්පද සඟවන්න";
STRINGS["si"]["hidePasswordsAccessKey"] = "P";
STRINGS["si"]["noMasterPasswordPrompt"] = "ඔබට විශ්වාසද, ඔබගේ රහස්පද පෙන්වීම අවශ්‍යද?";
STRINGS["si"]["showPasswords"] = "රහස්පද පෙන්වන්න";
STRINGS["si"]["showPasswordsAccessKey"] = "P";
STRINGS["sk"] = {};
STRINGS["sk"]["hidePasswords"] = "Skryť heslá";
STRINGS["sk"]["hidePasswordsAccessKey"] = "S";
STRINGS["sk"]["noMasterPasswordPrompt"] = "Naozaj chcete zobraziť svoje heslá?";
STRINGS["sk"]["showPasswords"] = "Zobraziť heslá";
STRINGS["sk"]["showPasswordsAccessKey"] = "b";
STRINGS["sl"] = {};
STRINGS["sl"]["hidePasswords"] = "Skrij gesla";
STRINGS["sl"]["hidePasswordsAccessKey"] = "s";
STRINGS["sl"]["noMasterPasswordPrompt"] = "Ali ste prepričani, da želite pokazati svoja gesla?";
STRINGS["sl"]["showPasswords"] = "Pokaži gesla";
STRINGS["sl"]["showPasswordsAccessKey"] = "P";
STRINGS["son"] = {};
STRINGS["son"]["hidePasswords"] = "Šennikufaley tugu";
STRINGS["son"]["hidePasswordsAccessKey"] = "P";
STRINGS["son"]["noMasterPasswordPrompt"] = "Alhakiika war ga boona ka war šennikufaley cebe?";
STRINGS["son"]["showPasswords"] = "Šennikufaley cebe";
STRINGS["son"]["showPasswordsAccessKey"] = "P";
STRINGS["sq"] = {};
STRINGS["sq"]["hidePasswords"] = "Fshihi Fjalëkalimet";
STRINGS["sq"]["hidePasswordsAccessKey"] = "F";
STRINGS["sq"]["noMasterPasswordPrompt"] = "Jeni i sigurt se doni të shfaqen fjalëkalimet tuaj?";
STRINGS["sq"]["showPasswords"] = "Shfaqi Fjalëkalimet";
STRINGS["sq"]["showPasswordsAccessKey"] = "S";
STRINGS["sr"] = {};
STRINGS["sr"]["hidePasswords"] = "Сакриј лозинке";
STRINGS["sr"]["hidePasswordsAccessKey"] = "л";
STRINGS["sr"]["noMasterPasswordPrompt"] = "Да ли сте сигурни да желите да прикажете своје лозинке?";
STRINGS["sr"]["showPasswords"] = "Прикажи лозинке";
STRINGS["sr"]["showPasswordsAccessKey"] = "е";
STRINGS["sv-SE"] = {};
STRINGS["sv-SE"]["hidePasswords"] = "Dölj lösenord";
STRINGS["sv-SE"]["hidePasswordsAccessKey"] = "D";
STRINGS["sv-SE"]["noMasterPasswordPrompt"] = "Är du säker på att du vill visa dina lösenord?";
STRINGS["sv-SE"]["showPasswords"] = "Visa lösenord";
STRINGS["sv-SE"]["showPasswordsAccessKey"] = "V";
STRINGS["ta"] = {};
STRINGS["ta"]["hidePasswords"] = "கடவுச்சொற்களை மறை";
STRINGS["ta"]["hidePasswordsAccessKey"] = "P";
STRINGS["ta"]["noMasterPasswordPrompt"] = "உங்கள் கடவுச்சொல்லை காட்ட விருப்பமா?";
STRINGS["ta"]["showPasswords"] = "கடவுச்சொற்களை காட்டு";
STRINGS["ta"]["showPasswordsAccessKey"] = "P";
STRINGS["te"] = {};
STRINGS["te"]["hidePasswords"] = "సంకేతపదాలను మరుగుపరుచు";
STRINGS["te"]["hidePasswordsAccessKey"] = "P";
STRINGS["te"]["noMasterPasswordPrompt"] = "మీరు నిజంగానే మీ సంకేతపదాలను చూపించాలి అనుకుంటున్నారా?";
STRINGS["te"]["showPasswords"] = "సంకేతపదాలను చూపించు";
STRINGS["te"]["showPasswordsAccessKey"] = "P";
STRINGS["th"] = {};
STRINGS["th"]["hidePasswords"] = "ซ่อนรหัสผ่าน";
STRINGS["th"]["hidePasswordsAccessKey"] = "ซ";
STRINGS["th"]["noMasterPasswordPrompt"] = "คุณแน่ใจหรือว่าต้องการที่จะแสดงรหัสผ่าน";
STRINGS["th"]["showPasswords"] = "แสดงรหัสผ่าน";
STRINGS["th"]["showPasswordsAccessKey"] = "ส";
STRINGS["tr"] = {};
STRINGS["tr"]["hidePasswords"] = "Parolaları gizle";
STRINGS["tr"]["hidePasswordsAccessKey"] = "P";
STRINGS["tr"]["noMasterPasswordPrompt"] = "Parolalarınızı göstermek istediğinizden emin misiniz?";
STRINGS["tr"]["showPasswords"] = "Parolaları göster";
STRINGS["tr"]["showPasswordsAccessKey"] = "P";
STRINGS["uk"] = {};
STRINGS["uk"]["hidePasswords"] = "Сховати паролі";
STRINGS["uk"]["hidePasswordsAccessKey"] = "х";
STRINGS["uk"]["noMasterPasswordPrompt"] = "Ви впевнені, що хочете показати паролі?";
STRINGS["uk"]["showPasswords"] = "Показати паролі";
STRINGS["uk"]["showPasswordsAccessKey"] = "П";
STRINGS["uz"] = {};
STRINGS["uz"]["hidePasswords"] = "Parollarni yaxshirish";
STRINGS["uz"]["hidePasswordsAccessKey"] = "P";
STRINGS["uz"]["noMasterPasswordPrompt"] = "Parollaringizni koʻrsatilishini xohlaysizmi?";
STRINGS["uz"]["showPasswords"] = "Parollarni koʻrsatish";
STRINGS["uz"]["showPasswordsAccessKey"] = "P";
STRINGS["vi"] = {};
STRINGS["vi"]["hidePasswords"] = "Ẩn các Mật khẩu";
STRINGS["vi"]["hidePasswordsAccessKey"] = "u";
STRINGS["vi"]["noMasterPasswordPrompt"] = "Bạn có chắc bạn muốn hiện các mật khẩu của mình?";
STRINGS["vi"]["showPasswords"] = "Hiện các Mật khẩu";
STRINGS["vi"]["showPasswordsAccessKey"] = "u";
STRINGS["xh"] = {};
STRINGS["xh"]["hidePasswords"] = "Fihla Amagama Okugqithisa";
STRINGS["xh"]["hidePasswordsAccessKey"] = "I";
STRINGS["xh"]["noMasterPasswordPrompt"] = "Uqinisekile unqwenela ukubonisa amagama okugqithisa akho?";
STRINGS["xh"]["showPasswords"] = "Bonisa Amagama Okugqithisa";
STRINGS["xh"]["showPasswordsAccessKey"] = "I";
STRINGS["zh-CN"] = {};
STRINGS["zh-CN"]["hidePasswords"] = "隐藏密码";
STRINGS["zh-CN"]["hidePasswordsAccessKey"] = "P";
STRINGS["zh-CN"]["noMasterPasswordPrompt"] = "您确定要显示您的密码吗？";
STRINGS["zh-CN"]["showPasswords"] = "显示密码";
STRINGS["zh-CN"]["showPasswordsAccessKey"] = "P";
STRINGS["zh-TW"] = {};
STRINGS["zh-TW"]["hidePasswords"] = "隱藏密碼";
STRINGS["zh-TW"]["hidePasswordsAccessKey"] = "P";
STRINGS["zh-TW"]["noMasterPasswordPrompt"] = "您確定要顯示密碼嗎？";
STRINGS["zh-TW"]["showPasswords"] = "顯示密碼";
STRINGS["zh-TW"]["showPasswordsAccessKey"] = "P";

var kSignonBundle;
var showingPasswords = false;
var dateFormatter = new Intl.DateTimeFormat(undefined,
                      { day: "numeric", month: "short", year: "numeric" });
var dateAndTimeFormatter = new Intl.DateTimeFormat(undefined,
                             { day: "numeric", month: "short", year: "numeric",
                               hour: "numeric", minute: "numeric" });

function SignonsStartup() {
  kSignonBundle = document.getElementById("signonBundle");
  document.getElementById("togglePasswords").label = getLegacyString("showPasswords");
  document.getElementById("togglePasswords").accessKey = getLegacyString("showPasswordsAccessKey");
  document.getElementById("signonsIntro").textContent = kSignonBundle.getString("loginsDescriptionAll");

  let treecols = document.getElementsByTagName("treecols")[0];
  treecols.addEventListener("click", HandleTreeColumnClick.bind(null, SignonColumnSort));

  LoadSignons();

  // filter the table if requested by caller
  if (window.arguments &&
      window.arguments[0] &&
      window.arguments[0].filterString) {
    setFilter(window.arguments[0].filterString);
    Services.telemetry.getHistogramById("PWMGR_MANAGE_OPENED").add(1);
  } else {
    Services.telemetry.getHistogramById("PWMGR_MANAGE_OPENED").add(0);
  }

  FocusFilterBox();
}

function setFilter(aFilterString) {
  document.getElementById("filter").value = aFilterString;
  _filterPasswords();
}

var signonsTreeView = {
  _filterSet : [],
  _lastSelectedRanges : [],
  selection: null,

  rowCount : 0,
  setTree : function(tree) {},
  getImageSrc : function(row,column) {},
  getProgressMode : function(row,column) {},
  getCellValue : function(row,column) {},
  getCellText : function(row,column) {
    var time;
    var signon = this._filterSet.length ? this._filterSet[row] : signons[row];
    switch (column.id) {
      case "siteCol":
        return signon.httpRealm ?
               (signon.hostname + " (" + signon.httpRealm + ")"):
               signon.hostname;
      case "userCol":
        return signon.username || "";
      case "passwordCol":
        return signon.password || "";
      case "timeCreatedCol":
        time = new Date(signon.timeCreated);
        return dateFormatter.format(time);
      case "timeLastUsedCol":
        time = new Date(signon.timeLastUsed);
        return dateAndTimeFormatter.format(time);
      case "timePasswordChangedCol":
        time = new Date(signon.timePasswordChanged);
        return dateFormatter.format(time);
      case "timesUsedCol":
        return signon.timesUsed;
      default:
        return "";
    }
  },
  isEditable : function(row, col) {
    if (col.id == "userCol" || col.id == "passwordCol") {
      return true;
    }
    return false;
  },
  isSeparator : function(index) { return false; },
  isSorted : function() { return false; },
  isContainer : function(index) { return false; },
  cycleHeader : function(column) {},
  getRowProperties : function(row) { return ""; },
  getColumnProperties : function(column) { return ""; },
  getCellProperties : function(row,column) {
    if (column.element.getAttribute("id") == "siteCol")
      return "ltr";

    return "";
  },
  setCellText : function(row, col, value) {
    // If there is a filter, _filterSet needs to be used, otherwise signons is used.
    let table = signonsTreeView._filterSet.length ? signonsTreeView._filterSet : signons;
    function _editLogin(field) {
      if (value == table[row][field]) {
        return;
      }
      let existingLogin = table[row].clone();
      table[row][field] = value;
      table[row].timePasswordChanged = Date.now();
      passwordmanager.modifyLogin(existingLogin, table[row]);
      signonsTree.treeBoxObject.invalidateRow(row);
    }

    if (col.id == "userCol") {
     _editLogin("username");

    } else if (col.id == "passwordCol") {
      if (!value) {
        return;
      }
      _editLogin("password");
    }
  },
};


function LoadSignons() {
  // loads signons into table
  try {
    signons = passwordmanager.getAllLogins();
  } catch (e) {
    signons = [];
  }
  signons.forEach(login => login.QueryInterface(Components.interfaces.nsILoginMetaInfo));
  signonsTreeView.rowCount = signons.length;

  // sort and display the table
  signonsTree.view = signonsTreeView;
  // The sort column didn't change. SortTree (called by
  // SignonColumnSort) assumes we want to toggle the sort
  // direction but here we don't so we have to trick it
  lastSignonSortAscending = !lastSignonSortAscending;
  SignonColumnSort(lastSignonSortColumn);

  // disable "remove all signons" button if there are no signons
  var element = document.getElementById("removeAllSignons");
  var toggle = document.getElementById("togglePasswords");
  if (signons.length == 0) {
    element.setAttribute("disabled","true");
    toggle.setAttribute("disabled","true");
  } else {
    element.removeAttribute("disabled");
    toggle.removeAttribute("disabled");
  }

  return true;
}

function SignonSelected() {
  var selections = GetTreeSelections(signonsTree);
  if (selections.length) {
    document.getElementById("removeSignon").removeAttribute("disabled");
  } else {
    document.getElementById("removeSignon").setAttribute("disabled", true);
  }
}

function DeleteSignon() {
  var syncNeeded = (signonsTreeView._filterSet.length != 0);
  DeleteSelectedItemFromTree(signonsTree, signonsTreeView,
                             signonsTreeView._filterSet.length ? signonsTreeView._filterSet : signons,
                             deletedSignons, "removeSignon", "removeAllSignons");
  FinalizeSignonDeletions(syncNeeded);
}

function DeleteAllSignons() {
  var prompter = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                           .getService(Components.interfaces.nsIPromptService);

  // Confirm the user wants to remove all passwords
  var dummy = { value: false };
  if (prompter.confirmEx(window,
                         kSignonBundle.getString("removeAllPasswordsTitle"),
                         kSignonBundle.getString("removeAllPasswordsPrompt"),
                         prompter.STD_YES_NO_BUTTONS + prompter.BUTTON_POS_1_DEFAULT,
                         null, null, null, null, dummy) == 1) // 1 == "No" button
    return;

  var syncNeeded = (signonsTreeView._filterSet.length != 0);
  DeleteAllFromTree(signonsTree, signonsTreeView,
                        signonsTreeView._filterSet.length ? signonsTreeView._filterSet : signons,
                        deletedSignons, "removeSignon", "removeAllSignons");
  FinalizeSignonDeletions(syncNeeded);
  Services.telemetry.getHistogramById("PWMGR_MANAGE_DELETED_ALL").add(1);
}

function TogglePasswordVisible() {
  if (showingPasswords || masterPasswordLogin(AskUserShowPasswords)) {
    showingPasswords = !showingPasswords;
    document.getElementById("togglePasswords").label = getLegacyString(showingPasswords ? "hidePasswords" : "showPasswords");
    document.getElementById("togglePasswords").accessKey = getLegacyString(showingPasswords ? "hidePasswordsAccessKey" : "showPasswordsAccessKey");
    document.getElementById("passwordCol").hidden = !showingPasswords;
    _filterPasswords();
  }

  // Notify observers that the password visibility toggling is
  // completed.  (Mostly useful for tests)
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .notifyObservers(null, "passwordmgr-password-toggle-complete", null);
  Services.telemetry.getHistogramById("PWMGR_MANAGE_VISIBILITY_TOGGLED").add(showingPasswords);
}

function AskUserShowPasswords() {
  var prompter = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
  var dummy = { value: false };

  // Confirm the user wants to display passwords
  return prompter.confirmEx(window,
          null,
          getLegacyString("noMasterPasswordPrompt"), prompter.STD_YES_NO_BUTTONS,
          null, null, null, null, dummy) == 0;    // 0=="Yes" button
}

function FinalizeSignonDeletions(syncNeeded) {
  for (var s=0; s<deletedSignons.length; s++) {
    passwordmanager.removeLogin(deletedSignons[s]);
    Services.telemetry.getHistogramById("PWMGR_MANAGE_DELETED").add(1);
  }
  // If the deletion has been performed in a filtered view, reflect the deletion in the unfiltered table.
  // See bug 405389.
  if (syncNeeded) {
    try {
      signons = passwordmanager.getAllLogins();
    } catch (e) {
      signons = [];
    }
  }
  deletedSignons.length = 0;
}

function HandleSignonKeyPress(e) {
  // If editing is currently performed, don't do anything.
  if (signonsTree.getAttribute("editing")) {
    return;
  }
  if (e.keyCode == KeyEvent.DOM_VK_DELETE
//@line 790 "/Users/macuser/Development/interwebppcrr4/toolkit/components/passwordmgr/content/passwordManager.js"
      || e.keyCode == KeyEvent.DOM_VK_BACK_SPACE
//@line 792 "/Users/macuser/Development/interwebppcrr4/toolkit/components/passwordmgr/content/passwordManager.js"
   ) {
    DeleteSignon();
  }
}

function getColumnByName(column) {
  switch (column) {
    case "hostname":
      return document.getElementById("siteCol");
    case "username":
      return document.getElementById("userCol");
    case "password":
      return document.getElementById("passwordCol");
    case "timeCreated":
      return document.getElementById("timeCreatedCol");
    case "timeLastUsed":
      return document.getElementById("timeLastUsedCol");
    case "timePasswordChanged":
      return document.getElementById("timePasswordChangedCol");
    case "timesUsed":
      return document.getElementById("timesUsedCol");
  }
}

var lastSignonSortColumn = "hostname";
var lastSignonSortAscending = true;

function SignonColumnSort(column) {
  // clear out the sortDirection attribute on the old column
  var lastSortedCol = getColumnByName(lastSignonSortColumn);
  lastSortedCol.removeAttribute("sortDirection");

  // sort
  lastSignonSortAscending =
    SortTree(signonsTree, signonsTreeView,
                 signonsTreeView._filterSet.length ? signonsTreeView._filterSet : signons,
                 column, lastSignonSortColumn, lastSignonSortAscending);
  lastSignonSortColumn = column;

  // set the sortDirection attribute to get the styling going
  // first we need to get the right element
  var sortedCol = getColumnByName(column);
  sortedCol.setAttribute("sortDirection", lastSignonSortAscending ?
                                          "ascending" : "descending");
}

function SignonClearFilter() {
  var singleSelection = (signonsTreeView.selection.count == 1);

  // Clear the Tree Display
  signonsTreeView.rowCount = 0;
  signonsTree.treeBoxObject.rowCountChanged(0, -signonsTreeView._filterSet.length);
  signonsTreeView._filterSet = [];

  // Just reload the list to make sure deletions are respected
  LoadSignons();

  // Restore selection
  if (singleSelection) {
    signonsTreeView.selection.clearSelection();
    for (let i = 0; i < signonsTreeView._lastSelectedRanges.length; ++i) {
      var range = signonsTreeView._lastSelectedRanges[i];
      signonsTreeView.selection.rangedSelect(range.min, range.max, true);
    }
  } else {
    signonsTreeView.selection.select(0);
  }
  signonsTreeView._lastSelectedRanges = [];

  document.getElementById("signonsIntro").textContent = kSignonBundle.getString("loginsDescriptionAll");
}

function FocusFilterBox() {
  var filterBox = document.getElementById("filter");
  if (filterBox.getAttribute("focused") != "true")
    filterBox.focus();
}

function SignonMatchesFilter(aSignon, aFilterValue) {
  if (aSignon.hostname.toLowerCase().indexOf(aFilterValue) != -1)
    return true;
  if (aSignon.username &&
      aSignon.username.toLowerCase().indexOf(aFilterValue) != -1)
    return true;
  if (aSignon.httpRealm &&
      aSignon.httpRealm.toLowerCase().indexOf(aFilterValue) != -1)
    return true;
  if (showingPasswords && aSignon.password &&
      aSignon.password.toLowerCase().indexOf(aFilterValue) != -1)
    return true;

  return false;
}

function FilterPasswords(aFilterValue, view) {
  aFilterValue = aFilterValue.toLowerCase();
  return signons.filter(s => SignonMatchesFilter(s, aFilterValue));
}

function SignonSaveState() {
  // Save selection
  var seln = signonsTreeView.selection;
  signonsTreeView._lastSelectedRanges = [];
  var rangeCount = seln.getRangeCount();
  for (var i = 0; i < rangeCount; ++i) {
    var min = {}; var max = {};
    seln.getRangeAt(i, min, max);
    signonsTreeView._lastSelectedRanges.push({ min: min.value, max: max.value });
  }
}

function _filterPasswords()
{
  var filter = document.getElementById("filter").value;
  if (filter == "") {
    SignonClearFilter();
    return;
  }

  var newFilterSet = FilterPasswords(filter, signonsTreeView);
  if (!signonsTreeView._filterSet.length) {
    // Save Display Info for the Non-Filtered mode when we first
    // enter Filtered mode.
    SignonSaveState();
  }
  signonsTreeView._filterSet = newFilterSet;

  // Clear the display
  let oldRowCount = signonsTreeView.rowCount;
  signonsTreeView.rowCount = 0;
  signonsTree.treeBoxObject.rowCountChanged(0, -oldRowCount);
  // Set up the filtered display
  signonsTreeView.rowCount = signonsTreeView._filterSet.length;
  signonsTree.treeBoxObject.rowCountChanged(0, signonsTreeView.rowCount);

  // if the view is not empty then select the first item
  if (signonsTreeView.rowCount > 0)
    signonsTreeView.selection.select(0);

  document.getElementById("signonsIntro").textContent = kSignonBundle.getString("loginsDescriptionFiltered");
}

function CopyPassword() {
  // Don't copy passwords if we aren't already showing the passwords & a master
  // password hasn't been entered.
  if (!showingPasswords && !masterPasswordLogin())
    return;
  // Copy selected signon's password to clipboard
  var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"].
                  getService(Components.interfaces.nsIClipboardHelper);
  var row = document.getElementById("signonsTree").currentIndex;
  var password = signonsTreeView.getCellText(row, {id : "passwordCol" });
  clipboard.copyString(password);
  Services.telemetry.getHistogramById("PWMGR_MANAGE_COPIED_PASSWORD").add(1);
}

function CopyUsername() {
  // Copy selected signon's username to clipboard
  var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"].
                  getService(Components.interfaces.nsIClipboardHelper);
  var row = document.getElementById("signonsTree").currentIndex;
  var username = signonsTreeView.getCellText(row, {id : "userCol" });
  clipboard.copyString(username);
  Services.telemetry.getHistogramById("PWMGR_MANAGE_COPIED_USERNAME").add(1);
}

function EditCellInSelectedRow(columnName) {
  let row = signonsTree.currentIndex;
  let columnElement = getColumnByName(columnName);
  signonsTree.startEditing(row, signonsTree.columns.getColumnFor(columnElement));
}

function UpdateContextMenu() {
  let singleSelection = (signonsTreeView.selection.count == 1);
  let menuItems = new Map();
  let menupopup = document.getElementById("signonsTreeContextMenu");
  for (let menuItem of menupopup.querySelectorAll("menuitem")) {
    menuItems.set(menuItem.id, menuItem);
  }

  if (!singleSelection) {
    for (let menuItem of menuItems.values()) {
      menuItem.setAttribute("disabled", "true");
    }
    return;
  }

  let selectedRow = signonsTree.currentIndex;

  // Disable "Copy Username" if the username is empty.
  if (signonsTreeView.getCellText(selectedRow, { id: "userCol" }) != "") {
    menuItems.get("context-copyusername").removeAttribute("disabled");
  } else {
    menuItems.get("context-copyusername").setAttribute("disabled", "true");
  }

  menuItems.get("context-editusername").removeAttribute("disabled");
  menuItems.get("context-copypassword").removeAttribute("disabled");

  // Disable "Edit Password" if the password column isn't showing.
  if (!document.getElementById("passwordCol").hidden) {
    menuItems.get("context-editpassword").removeAttribute("disabled");
  } else {
    menuItems.get("context-editpassword").setAttribute("disabled", "true");
  }
}

function masterPasswordLogin(noPasswordCallback) {
  // This doesn't harm if passwords are not encrypted
  var tokendb = Components.classes["@mozilla.org/security/pk11tokendb;1"]
                    .createInstance(Components.interfaces.nsIPK11TokenDB);
  var token = tokendb.getInternalKeyToken();

  // If there is no master password, still give the user a chance to opt-out of displaying passwords
  if (token.checkPassword(""))
    return noPasswordCallback ? noPasswordCallback() : true;

  // So there's a master password. But since checkPassword didn't succeed, we're logged out (per nsIPK11Token.idl).
  try {
    // Relogin and ask for the master password.
    token.login(true);  // 'true' means always prompt for token password. User will be prompted until
                        // clicking 'Cancel' or entering the correct password.
  } catch (e) {
    // An exception will be thrown if the user cancels the login prompt dialog.
    // User is also logged out of Software Security Device.
  }

  return token.isLoggedIn();
}

function escapeKeyHandler() {
  // If editing is currently performed, don't do anything.
  if (signonsTree.getAttribute("editing")) {
    return;
  }
  window.close();
}

function OpenMigrator() {
  const { MigrationUtils } = Cu.import("resource:///modules/MigrationUtils.jsm", {});
  // We pass in the type of source we're using for use in telemetry:
  MigrationUtils.showMigrationWizard(window, [MigrationUtils.MIGRATION_ENTRYPOINT_PASSWORDS]);
}

function getLegacyString(aStringID) {
  let locale = Cc["@mozilla.org/chrome/chrome-registry;1"].
               getService(Ci.nsIXULChromeRegistry).
               getSelectedLocale("passwordmgr");

  let string = STRINGS["en-US"][aStringID];
  try {
    if (typeof(STRINGS[locale][aStringID]) == "string") {
      string = STRINGS[locale][aStringID];
    }
  } catch (ex) {}

  return string;
}
