/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.events;

import com.minimap.XaeroMinimap;
import com.minimap.animation.Animation;
import com.minimap.gui.GuiMisc;
import com.minimap.gui.GuiUpdate;
import com.minimap.gui.MyOptions;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.minimap.Minimap;
import com.minimap.minimap.Waypoint;
import com.minimap.settings.ModSettings;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class Events {
    public Object lastGuiOpen;
    int deathCounter = 0;
    private static boolean askedToUpdate = false;

    @SubscribeEvent
    public void drawPost(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.gui instanceof GuiOptions) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.gui = new MyOptions(null, mc.field_71474_y);
            try {
                XaeroMinimap.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = event.gui;
    }

    @SubscribeEvent
    public void drawPre(RenderGameOverlayEvent.Pre event) {
        if (Keyboard.isKeyDown((int)1)) {
            InterfaceHandler.cancel();
        }
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InterfaceHandler.drawInterfaces(event.partialTicks);
            Animation.tick();
        }
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu || event.gui instanceof GuiMultiplayer) {
            XaeroMinimap.getSettings().resetServerSettings();
        }
        if (event.gui instanceof GuiGameOver) {
            ++this.deathCounter;
            if ((this.deathCounter & 1) == 0) {
                this.createDeathpoint((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
    }

    public void createDeathpoint(EntityPlayer p) {
        boolean disabled = false;
        if (Minimap.waypoints == null) {
            return;
        }
        for (Waypoint w : Minimap.waypoints.list) {
            if (w.type != 1) continue;
            if (!XaeroMinimap.getSettings().getDeathpoints() || !XaeroMinimap.getSettings().getOldDeathpoints()) {
                Minimap.waypoints.list.remove(w);
                break;
            }
            disabled = w.disabled;
            w.type = 0;
            w.name = "gui.xaero_deathpoint_old";
            break;
        }
        if (XaeroMinimap.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(Minimap.myFloor(p.field_70165_t), Minimap.myFloor(p.field_70163_u), Minimap.myFloor(p.field_70161_v), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.disabled = disabled;
            Minimap.waypoints.list.add(deathpoint);
        }
        try {
            XaeroMinimap.settings.saveWaypoints();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chatMessage(ClientChatReceivedEvent e) {
        String text = e.message.func_150254_d();
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replaceAll("\u00a7", "").replaceAll("r", "").replaceAll(" ", "");
            XaeroMinimap.getSettings().resetServerSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            System.out.println("Code: " + code);
        }
    }

    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        if (XaeroMinimap.settings.getShowIngameWaypoints() && Minimap.waypoints != null) {
            EntityLivingBase entity = XaeroMinimap.mc.field_71451_h;
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.partialTicks;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.partialTicks;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.partialTicks;
            Tessellator tessellator = Tessellator.field_78398_a;
            for (Waypoint w : Minimap.waypoints.list) {
                if (w.disabled || w.type == 1 && !XaeroMinimap.getSettings().getDeathpoints()) continue;
                this.renderIngameWaypoint(w, 12.0, d3, d4, d5, (Entity)entity, tessellator);
            }
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
        }
    }

    protected void renderIngameWaypoint(Waypoint w, double radius, double d3, double d4, double d5, Entity entity, Tessellator tessellator) {
        try {
            double distance;
            float offX = (float)w.x - (float)d3 + 0.5f;
            float offY = (float)w.y - (float)d4 + 1.0f;
            float offZ = (float)w.z - (float)d5 + 0.5f;
            w.lastDistance = distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
            if (XaeroMinimap.getSettings().waypointsDistance != 0.0f && distance > (double)XaeroMinimap.getSettings().waypointsDistance || XaeroMinimap.getSettings().waypointsDistanceMin != 0.0f && distance < (double)XaeroMinimap.getSettings().waypointsDistanceMin) {
                return;
            }
            RenderManager renderManager = RenderManager.field_78727_a;
            FontRenderer fontrenderer = renderManager.func_78716_a();
            if (fontrenderer == null) {
                return;
            }
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GL11.glPushMatrix();
            float textSize = 1.0f;
            String name = w.getName();
            String distanceText = "";
            boolean showDistance = false;
            float zoomer2 = 1.0f;
            if (XaeroMinimap.getSettings().keepWaypointNames) {
                textSize = 1.6f;
            }
            if (distance > radius) {
                double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
                if (distance > maxDistance) {
                    zoomer2 = (float)(maxDistance / radius);
                    float zoomer = (float)(maxDistance / distance);
                    offX *= zoomer;
                    offY *= zoomer;
                    offY += entity.func_70047_e() * (1.0f - zoomer);
                    offZ *= zoomer;
                } else {
                    zoomer2 = (float)(distance / radius);
                }
                if (distance > 20.0) {
                    textSize = 1.6f;
                    if (XaeroMinimap.getSettings().distance == 1) {
                        float cameraAngle;
                        float offset;
                        float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                        float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                        if (offZ < 0.0f) {
                            angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                        }
                        showDistance = (offset = MathHelper.func_76142_g((float)(angle - (cameraAngle = MathHelper.func_76142_g((float)entity.field_70177_z))))) > -20.0f && offset < 20.0f;
                    } else if (XaeroMinimap.getSettings().distance == 2) {
                        showDistance = true;
                    }
                    if (showDistance) {
                        distanceText = GuiMisc.simpleFormat.format(distance) + "m";
                        if (!XaeroMinimap.getSettings().keepWaypointNames) {
                            name = "";
                        }
                    } else {
                        name = "";
                    }
                }
            }
            GL11.glTranslatef((float)offX, (float)offY, (float)offZ);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glScalef((float)zoomer2, (float)zoomer2, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            w.drawIconInWorld(tessellator, fontrenderer, name, distanceText, textSize, showDistance);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui instanceof GuiUpdate) {
            askedToUpdate = true;
        } else if (!askedToUpdate && XaeroMinimap.isOutdated && event.gui instanceof GuiMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdate());
            System.out.println("Minimap is outdated!");
        } else if (XaeroMinimap.isOutdated) {
            XaeroMinimap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) {
        Minimap.clearBlockColours = true;
    }
}

