/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.TreeMap;

public class ClickCounter<T> {
    public Map<Integer, ClickCount> buttons = new TreeMap<Integer, ClickCount>();

    public ClickCount getCount(int button) {
        ClickCount c = this.buttons.get(button);
        if (c == null) {
            c = new ClickCount();
            this.buttons.put(button, c);
        }
        return c;
    }

    public void mouseDown(T clicked, int button) {
        ClickCount c = this.getCount(button);
        c.update(clicked);
    }

    public int mouseUp(T clicked, int button) {
        ClickCount c = this.getCount(button);
        if (!c.update(clicked)) {
            return 0;
        }
        long time = System.currentTimeMillis();
        c.count = time - c.time < 500L ? ++c.count : 1;
        c.time = time;
        return c.count;
    }

    public class ClickCount {
        public T clicked;
        public long time;
        public int count;

        public boolean update(T clicked) {
            if (!Objects.equal(this.clicked, clicked)) {
                this.clicked = clicked;
                this.count = 0;
                this.time = Long.MIN_VALUE;
                return false;
            }
            return true;
        }
    }
}

