/*
 * Decompiled with CFR 0.152.
 */
package train.common.mtc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import train.common.Traincraft;
import train.common.api.Locomotive;
import train.common.api.WirelessTransmitter;
import train.common.mtc.PDMMessage;

public class TilePDMInstructionRadio
extends TileEntity
implements IPeripheral,
WirelessTransmitter {
    public Boolean isActivated = false;
    public ArrayList<IComputerAccess> computers = new ArrayList();
    public int system = 0;
    public String uniqueID;
    public AxisAlignedBB boundingBox = null;
    Map<String, Map<String, String>> connectedTrains = new HashMap<String, Map<String, String>>();

    public TilePDMInstructionRadio() {
        if (this.uniqueID == null) {
            this.uniqueID = UUID.randomUUID().toString();
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isActivated = nbttagcompound.func_74767_n("activated");
        this.uniqueID = nbttagcompound.func_74779_i("uniqueID");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("activated", this.isActivated.booleanValue());
        nbttagcompound.func_74778_a("uniqueID", this.uniqueID);
    }

    @Override
    public String getType() {
        return "wirelessMTCRadio";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"activate", "deactivate", "sendMessage", "getSelfUUID", "getConnectedTrains"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                this.isActivated = true;
                Traincraft.tcLog.info("Wireless Transmitter UUID is: " + this.uniqueID);
                return new Object[]{true};
            }
            case 1: {
                this.isActivated = false;
                return new Object[]{true};
            }
            case 2: {
                this.sendMessage(new PDMMessage(this.uniqueID, arguments[0].toString(), arguments[1].toString(), 1));
                return new Object[]{true};
            }
            case 3: {
                Traincraft.tcLog.info("Wireless Transmitter UUID is: " + this.uniqueID);
                return new Object[]{this.uniqueID};
            }
            case 4: {
                return new Object[]{this.connectedTrains};
            }
        }
        return new Object[]{"nil"};
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Override
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Override
    public void sendMessage(PDMMessage message) {
        if (this.isActivated.booleanValue()) {
            for (WirelessTransmitter wt : this.getWirelessTransmittersInBoundingBox()) {
                if (wt instanceof Locomotive || wt instanceof TilePDMInstructionRadio) {
                    // empty if block
                }
                if (wt instanceof Locomotive) {
                    Locomotive actualLocomotive = (Locomotive)wt;
                    if (!actualLocomotive.trainID.equals(PDMMessage.UUIDTo)) continue;
                    wt.receiveMessage(new PDMMessage(this.uniqueID, PDMMessage.UUIDTo, PDMMessage.message, this.system));
                    continue;
                }
                if (!(wt instanceof TilePDMInstructionRadio)) continue;
                TilePDMInstructionRadio actualRadio = (TilePDMInstructionRadio)wt;
                if (!actualRadio.uniqueID.equals(PDMMessage.UUIDTo)) continue;
                wt.receiveMessage(message);
            }
        }
    }

    public ArrayList<WirelessTransmitter> getWirelessTransmittersInBoundingBox() {
        int i = this.field_145851_c / 16 - 50;
        int j = this.field_145851_c / 16 + 50;
        int k = this.field_145849_e / 16 - 50;
        int l = this.field_145849_e / 16 + 50;
        ArrayList<WirelessTransmitter> toAdd = new ArrayList<WirelessTransmitter>();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                List[] entities;
                if (!this.field_145850_b.func_72863_F().func_73149_a(i1, j1)) continue;
                for (List olist : entities = this.field_145850_b.func_72964_e((int)i1, (int)j1).field_76645_j) {
                    for (Object obj : olist) {
                        if (!(obj instanceof Locomotive)) continue;
                        toAdd.add((Locomotive)obj);
                    }
                }
            }
        }
        List allTEs = this.field_145850_b.field_147482_g;
        for (TileEntity te : allTEs) {
            if (!(te instanceof TilePDMInstructionRadio)) continue;
            toAdd.add((TilePDMInstructionRadio)te);
        }
        ArrayList<WirelessTransmitter> returnList = new ArrayList<WirelessTransmitter>();
        returnList.addAll(toAdd);
        return returnList;
    }

    @Override
    public void receiveMessage(PDMMessage message) {
        if (this.isActivated.booleanValue()) {
            try {
                if (this.computers != null && this.computers.size() > 0) {
                    for (IComputerAccess c : this.computers) {
                        Object[] objectArray = new Object[5];
                        objectArray[0] = c.getAttachmentName();
                        objectArray[1] = PDMMessage.UUIDFrom;
                        objectArray[2] = PDMMessage.UUIDTo;
                        objectArray[3] = PDMMessage.message;
                        objectArray[4] = PDMMessage.system;
                        c.queueEvent("radio_message", objectArray);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b == null) {
            return;
        }
    }
}

