/*
 * Decompiled with CFR 0.152.
 */
package train.common.items;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.core.items.IMinecartItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.api.AbstractTrains;
import train.common.api.DieselTrain;
import train.common.api.ElectricTrain;
import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;
import train.common.api.SteamTrain;
import train.common.api.Tender;
import train.common.core.handlers.ConfigHandler;
import train.common.core.util.TraincraftUtil;
import train.common.entity.rollingStock.EntityTracksBuilder;
import train.common.items.ItemTCRail;
import train.common.library.BlockIDs;
import train.common.library.EnumTrains;
import train.common.tile.TileTCRail;
import train.common.tile.TileTCRailGag;

public class ItemRollingStock
extends ItemMinecart
implements IMinecart,
IMinecartItem {
    private String iconName = "";
    private String trainName;
    private String trainCreator;
    private int trainColor = -1;

    public ItemRollingStock(String iconName) {
        super(1);
        this.iconName = iconName;
        this.field_77777_bU = 1;
        this.trainName = this.func_77658_a();
        this.func_77637_a(Traincraft.tcTab);
    }

    public int setNewUniqueID(ItemStack stack, EntityPlayer player, int numberOfTrains) {
        NBTTagCompound var3 = stack.func_77978_p();
        if (numberOfTrains <= 0) {
            numberOfTrains = AbstractTrains.uniqueIDs++;
        } else {
            AbstractTrains.uniqueIDs = numberOfTrains++;
        }
        if (var3 == null) {
            var3 = new NBTTagCompound();
            stack.func_77982_d(var3);
        }
        stack.func_77978_p().func_74768_a("uniqueID", numberOfTrains);
        stack.func_77978_p().func_74778_a("trainCreator", player.getDisplayName());
        return numberOfTrains;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77942_o()) {
            NBTTagCompound var5 = par1ItemStack.func_77978_p();
            this.trainCreator = var5.func_74779_i("trainCreator");
            if (this.trainCreator.length() > 0) {
                par3List.add("\u00a77Creator: " + this.trainCreator);
            }
            int color = var5.func_74762_e("trainColor");
            if (var5.func_74764_b("trainColor") && color <= 16) {
                par3List.add("\u00a77Color: " + AbstractTrains.getColorAsString(color));
            }
        }
        double mass = this.getMass();
        int power = this.getMHP();
        int maxSpeed = this.getMaxSpeed();
        if (this.getTrainType().length() > 0) {
            par3List.add("\u00a77Type: " + this.getTrainType());
        }
        if (power > 0) {
            par3List.add("\u00a77Power: " + power + " Mhp");
        }
        if (mass != 0.0) {
            par3List.add("\u00a77Mass: " + mass * 10.0);
        }
        if (maxSpeed > 0) {
            par3List.add("\u00a77Max Speed: " + maxSpeed);
        }
        if (this.getCargoCapacity() > 0) {
            par3List.add("\u00a77Slots: " + this.getCargoCapacity());
        }
        if (this.getAdditionnalInfo() != null) {
            par3List.add("\u00a77" + this.getAdditionnalInfo());
        }
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public String getTrainType() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getTrainType();
        }
        return "";
    }

    public double getMass() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getMass();
        }
        return 0.0;
    }

    public int getMaxSpeed() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getMaxSpeed();
        }
        return 0;
    }

    public int getMHP() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getMHP();
        }
        return 0;
    }

    public String getAdditionnalInfo() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getAdditionnalTooltip();
        }
        return null;
    }

    public int getCargoCapacity() {
        for (EnumTrains trains : EnumTrains.values()) {
            if (trains.getItem() != this) continue;
            return trains.getCargoCapacity();
        }
        return 0;
    }

    public String getTrainName() {
        return this.trainName;
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        int meta = par3World.func_72805_g(par4, par5, par6);
        TileEntity tileentity = par3World.func_147438_o(par4, par5, par6);
        if (par3World.field_72995_K) {
            return false;
        }
        if (tileentity != null && tileentity instanceof TileTCRail) {
            TileTCRail tile = (TileTCRail)tileentity;
            if (tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_STRAIGHT.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.SMALL_STRAIGHT.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.SMALL_ROAD_CROSSING.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.SMALL_ROAD_CROSSING_1.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.SMALL_ROAD_CROSSING_2.getLabel())) {
                this.placeCart(par2EntityPlayer, par1ItemStack, par3World, par4, par5, par6);
                return true;
            }
            par2EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track !"));
            return false;
        }
        if (tileentity != null && tileentity instanceof TileTCRailGag) {
            TileTCRailGag tileGag = (TileTCRailGag)tileentity;
            TileTCRail tile = (TileTCRail)par3World.func_147438_o(tileGag.originX, tileGag.originY, tileGag.originZ);
            if (tile != null && tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_STRAIGHT.getLabel())) {
                this.placeCart(par2EntityPlayer, par1ItemStack, par3World, par4, par5, par6);
                return true;
            }
            par2EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track !"));
            return false;
        }
        if (TraincraftUtil.isRailBlockAt(par3World, par4, par5, par6) && (meta < 2 || meta > 5)) {
            this.placeCart(par2EntityPlayer, par1ItemStack, par3World, par4, par5, par6);
            return true;
        }
        return false;
    }

    public EntityMinecart placeCart(EntityPlayer player, ItemStack itemstack, World world, int i, int j, int k) {
        EntityRollingStock rollingStock = null;
        for (EnumTrains train : EnumTrains.values()) {
            if (train.getItem() != itemstack.func_77973_b()) continue;
            rollingStock = (EntityRollingStock)train.getEntity(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
            if (train.getColors() == null || rollingStock == null) break;
            rollingStock.setColor(train.getColors()[0]);
            break;
        }
        if (rollingStock != null) {
            if (!world.field_72995_K) {
                if (rollingStock instanceof SteamTrain && !ConfigHandler.ENABLE_STEAM || rollingStock instanceof ElectricTrain && !ConfigHandler.ENABLE_ELECTRIC || rollingStock instanceof DieselTrain && !ConfigHandler.ENABLE_DIESEL || rollingStock instanceof EntityTracksBuilder && !ConfigHandler.ENABLE_BUILDER || rollingStock instanceof Tender && !ConfigHandler.ENABLE_TENDER) {
                    if (player != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("This type of train has been deactivated by the OP"));
                    }
                    rollingStock.func_70106_y();
                    return rollingStock;
                }
                int dir = 0;
                int meta = world.func_72805_g(i, j, k);
                if (player != null) {
                    dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                }
                if (dir == 2) {
                    rollingStock.field_70177_z = 0.0f;
                    rollingStock.serverRealRotation = meta == 0 ? -90.0f : 180.0f;
                    if (world.func_147439_a(i, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k) == BlockIDs.tcRailGag.block) {
                        rollingStock.field_70177_z = meta == 0 || meta == 2 ? 90.0f : 0.0f;
                    }
                    if (rollingStock instanceof Locomotive) {
                        if ((world.func_147439_a(i, j, k - 1) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k - 1) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i, j, k - 1))) && (world.func_147439_a(i, j, k - 2) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k - 2) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i, j, k - 2)))) {
                            if (meta == 0 || meta == 2) {
                                rollingStock.serverRealRotation = -90.0f;
                            }
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track!"));
                            rollingStock.func_70106_y();
                            return rollingStock;
                        }
                    }
                }
                if (dir == 1) {
                    rollingStock.field_70177_z = 90.0f;
                    rollingStock.serverRealRotation = meta == 1 ? 180.0f : -90.0f;
                    if (world.func_147439_a(i, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k) == BlockIDs.tcRailGag.block) {
                        rollingStock.field_70177_z = meta == 1 || meta == 3 ? 0.0f : 90.0f;
                    }
                    if (rollingStock instanceof Locomotive) {
                        if ((world.func_147439_a(i - 1, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i - 1, j, k) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i - 1, j, k))) && (world.func_147439_a(i - 2, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i - 2, j, k) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i - 2, j, k)))) {
                            if (meta == 1 || meta == 3) {
                                rollingStock.serverRealRotation = 180.0f;
                            }
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track!"));
                            rollingStock.func_70106_y();
                            return rollingStock;
                        }
                    }
                }
                if (dir == 0) {
                    rollingStock.field_70177_z = -178.5f;
                    rollingStock.serverRealRotation = meta == 0 ? 90.0f : 0.0f;
                    if (world.func_147439_a(i, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k) == BlockIDs.tcRailGag.block) {
                        rollingStock.field_70177_z = meta == 0 || meta == 2 ? -90.0f : 178.5f;
                    }
                    if (rollingStock instanceof Locomotive) {
                        if ((world.func_147439_a(i, j, k + 1) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k + 1) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i, j, k + 1))) && (world.func_147439_a(i, j, k + 2) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k + 2) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i, j, k + 2)))) {
                            if (meta == 0 || meta == 2) {
                                rollingStock.serverRealRotation = 90.0f;
                            }
                        } else {
                            if (player != null) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track!"));
                                rollingStock.func_70106_y();
                                return rollingStock;
                            }
                            if (meta == 0 || meta == 2) {
                                rollingStock.serverRealRotation = 90.0f;
                            }
                        }
                    }
                }
                if (dir == 3) {
                    rollingStock.field_70177_z = 178.5f;
                    rollingStock.serverRealRotation = meta == 1 ? 0.0f : 90.0f;
                    if (world.func_147439_a(i, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i, j, k) == BlockIDs.tcRailGag.block) {
                        rollingStock.field_70177_z = meta == 1 || meta == 3 ? 178.5f : 90.0f;
                    }
                    if (rollingStock instanceof Locomotive) {
                        if ((world.func_147439_a(i + 1, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i + 1, j, k) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i + 1, j, k))) && (world.func_147439_a(i + 2, j, k) == BlockIDs.tcRail.block || world.func_147439_a(i + 2, j, k) == BlockIDs.tcRailGag.block || BlockRailBase.func_150051_a((Block)world.func_147439_a(i + 2, j, k)))) {
                            if (meta == 1 || meta == 3) {
                                rollingStock.serverRealRotation = 0.0f;
                            }
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("Place me on a straight piece of track!"));
                            rollingStock.func_70106_y();
                            return rollingStock;
                        }
                    }
                }
                rollingStock.trainType = ((ItemRollingStock)itemstack.func_77973_b()).getTrainType();
                rollingStock.trainName = itemstack.func_77973_b().func_77653_i(itemstack);
                if (player != null) {
                    rollingStock.trainOwner = player.getDisplayName();
                }
                rollingStock.mass = this.getMass();
                int uniID = -1;
                if (itemstack.func_77942_o()) {
                    NBTTagCompound var5 = itemstack.func_77978_p();
                    uniID = var5.func_74762_e("uniqueID");
                    if (uniID != -1) {
                        rollingStock.uniqueID = uniID;
                    }
                    if (uniID != -1) {
                        rollingStock.getEntityData().func_74768_a("uniqueID", uniID);
                    }
                    this.trainCreator = var5.func_74779_i("trainCreator");
                    this.trainColor = var5.func_74762_e("trainColor");
                    if (var5.func_74764_b("trainColor")) {
                        rollingStock.setColor(this.trainColor);
                    }
                    rollingStock.trainCreator = this.trainCreator;
                }
                if (player != null) {
                    rollingStock.setInformation(((ItemRollingStock)itemstack.func_77973_b()).getTrainType(), player.getDisplayName(), this.trainCreator, itemstack.func_77973_b().func_77653_i(itemstack), uniID);
                }
                if (player == null) {
                    rollingStock.setInformation(((ItemRollingStock)itemstack.func_77973_b()).getTrainType(), "", this.trainCreator, itemstack.func_77973_b().func_77653_i(itemstack), uniID);
                }
                if (ConfigHandler.SHOW_POSSIBLE_COLORS && rollingStock.acceptedColors != null && rollingStock.acceptedColors.size() > 0) {
                    String concatColors = ": ";
                    for (int t = 0; t < rollingStock.acceptedColors.size(); ++t) {
                        if (AbstractTrains.getColorAsString(((Byte)rollingStock.acceptedColors.get(t)).byteValue()).equals("Empty") || AbstractTrains.getColorAsString(((Byte)rollingStock.acceptedColors.get(t)).byteValue()).equals("Full")) continue;
                        concatColors = concatColors.concat(AbstractTrains.getColorAsString(((Byte)rollingStock.acceptedColors.get(t)).byteValue()) + ", ");
                    }
                    if (concatColors.length() > 4 && player != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Possible colors" + concatColors));
                        player.func_145747_a((IChatComponent)new ChatComponentText("To paint, click me with the right (vanilla) dye"));
                    }
                }
                world.func_72838_d((Entity)rollingStock);
            }
            --itemstack.field_77994_a;
        }
        return rollingStock;
    }

    @Override
    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    @Override
    public EntityMinecart placeCart(GameProfile owner, ItemStack cart, World world, int i, int j, int k) {
        return this.placeCart((EntityPlayer)null, cart, world, i, j, k);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("tc".toLowerCase() + ":trains/" + this.iconName);
    }
}

