/*
 * Decompiled with CFR 0.152.
 */
package train.common.entity.rollingStock;

import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import train.common.Traincraft;
import train.common.api.LiquidManager;
import train.common.api.LiquidTank;
import train.common.library.EnumTrains;

public class EntityBUnitEMDF3
extends LiquidTank
implements IFluidHandler {
    public int freightInventorySize;
    private int update = 8;
    private LiquidManager.StandardTank theTank;

    public EntityBUnitEMDF3(World world) {
        super(world, EnumTrains.BUnitDD35.getTankCapacity());
        this.initFreightWater();
        LiquidManager liquidManager = LiquidManager.getInstance();
        liquidManager.getClass();
        this.theTank = liquidManager.new LiquidManager.FilteredTank(EnumTrains.BUnitDD35.getTankCapacity(), LiquidManager.dieselFilter());
    }

    public EntityBUnitEMDF3(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_70128_L = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.checkInvent(this.cargoItems[0]);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(18, (Object)this.theTank.getFluidAmount());
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().getFluidID());
            if (this.theTank.getFluid().amount <= 1) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(18, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
        if (this.getAmount() > 0) {
            this.setDefaultMass(-EnumTrains.BUnitEMDF3.getMass());
            if ((this.field_70159_w > 0.01 || this.field_70179_y > 0.01) && this.field_70173_aa % 40 == 0) {
                this.drain(ForgeDirection.UNKNOWN, 6, true);
            }
        } else if (this.getAmount() <= 0) {
            this.setDefaultMass(EnumTrains.BUnitEMDF3.getMass());
        }
    }

    public int getDiesel() {
        return this.field_70180_af.func_75679_c(18);
    }

    @Override
    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    @Override
    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.cargoItems.length; ++i) {
            if (this.cargoItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.cargoItems[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.theTank != null && this.theTank.getFluid() != null) {
            new FluidStack(this.theTank.getFluid(), this.field_70180_af.func_75679_c(18)).writeToNBT(nbttagcompound);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.cargoItems.length) continue;
            this.cargoItems[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbttagcompound.func_74764_b("FluidName")) {
            this.fill(ForgeDirection.UNKNOWN, FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound), true);
        }
    }

    private void placeInInvent(ItemStack itemstack1) {
        for (int i = 1; i < this.cargoItems.length; ++i) {
            if (this.cargoItems[i] == null) {
                this.cargoItems[i] = itemstack1;
                return;
            }
            if (this.cargoItems[i] != null && this.cargoItems[i].func_77973_b() == itemstack1.func_77973_b() && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.cargoItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.cargoItems[i], (ItemStack)itemstack1)) {
                int var9 = this.cargoItems[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= itemstack1.func_77976_d()) {
                    this.cargoItems[i].field_77994_a = var9;
                } else if (this.cargoItems[i].field_77994_a < itemstack1.func_77976_d()) {
                    ++this.cargoItems[i].field_77994_a;
                }
                return;
            }
            if (i != this.cargoItems.length - 1) continue;
            this.func_70099_a(itemstack1, 1.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this, itemstack)) != null) {
            this.placeInInvent(result);
        }
    }

    @Override
    public ItemStack checkInvent(ItemStack cargoItems0) {
        if (this.getDiesel() > 0) {
            this.fuelTrain = this.getDiesel();
        }
        if (this.fuelTrain <= 0) {
            this.field_70159_w *= 0.88;
            this.field_70179_y *= 0.88;
        }
        if (cargoItems0 != null) {
            this.liquidInSlot(cargoItems0);
        }
        return cargoItems0;
    }

    public void initFreightWater() {
        this.freightInventorySize = 2;
        this.cargoItems = new ItemStack[this.freightInventorySize];
    }

    @Override
    public String func_145825_b() {
        return "EMD F3 B-Unit";
    }

    @Override
    public int func_70302_i_() {
        return this.freightInventorySize;
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            entityplayer.openGui((Object)Traincraft.instance, 87, this.field_70170_p, this.func_145782_y(), -1, (int)this.field_70161_v);
        }
        return true;
    }

    @Override
    public boolean isStorageCart() {
        return true;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 2.2f;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    @Override
    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    @Override
    public int getFluidAmount() {
        return this.field_70180_af.func_75679_c(18);
    }

    @Override
    public String getLiquidName() {
        return FluidRegistry.getFluid((int)this.field_70180_af.func_75679_c(4)) != null ? FluidRegistry.getFluid((int)this.field_70180_af.func_75679_c(4)).getName() : null;
    }
}

