/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import train.common.api.EntityRollingStock;

public class PacketRollingStockRotation
implements IMessage {
    int entityID;
    int rotationYawServer;
    int realRotation;
    int anglePitch;
    int posY;
    boolean isInReverse;

    public PacketRollingStockRotation() {
    }

    public PacketRollingStockRotation(EntityRollingStock entity, int anglePitch) {
        this.entityID = entity.func_145782_y();
        this.rotationYawServer = (int)entity.field_70177_z;
        this.realRotation = (int)entity.serverRealRotation;
        this.anglePitch = anglePitch;
        this.posY = Float.floatToIntBits((float)entity.field_70163_u);
        this.isInReverse = entity.isServerInReverse;
    }

    public void fromBytes(ByteBuf bbuf) {
        this.entityID = bbuf.readInt();
        this.rotationYawServer = bbuf.readInt();
        this.realRotation = bbuf.readInt();
        this.anglePitch = bbuf.readInt();
        this.posY = bbuf.readInt();
        this.isInReverse = bbuf.readBoolean();
    }

    public void toBytes(ByteBuf bbuf) {
        bbuf.writeInt(this.entityID);
        bbuf.writeInt(this.rotationYawServer);
        bbuf.writeInt(this.realRotation);
        bbuf.writeInt(this.anglePitch);
        bbuf.writeInt(this.posY);
        bbuf.writeBoolean(this.isInReverse);
    }

    public static class Handler
    implements IMessageHandler<PacketRollingStockRotation, IMessage> {
        public IMessage onMessage(PacketRollingStockRotation message, MessageContext context) {
            Entity entity;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && (entity = mc.field_71441_e.func_73045_a(message.entityID)) instanceof EntityRollingStock) {
                EntityRollingStock rollingStock = (EntityRollingStock)entity;
                rollingStock.rotationYawClient = message.rotationYawServer;
                rollingStock.rotationYawClientReal = message.realRotation;
                rollingStock.anglePitchClient = message.anglePitch;
                rollingStock.isClientInReverse = message.isInReverse;
                rollingStock.setYFromServer(Float.intBitsToFloat(message.posY));
            }
            return null;
        }
    }
}

