/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import java.util.List;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.api.AbstractTrains;
import train.common.api.EntityRollingStock;

public class LinkHandler {
    private World worldObj;
    private float distanceBehindCart;

    public LinkHandler(World world) {
        this.worldObj = world;
    }

    public void handleStake(EntityRollingStock entityOne, AxisAlignedBB customBoundingBox) {
        if (entityOne.isAttaching) {
            List lis = this.worldObj.func_72839_b((Entity)entityOne, customBoundingBox.func_72314_b(15.0, 5.0, 15.0));
            if (entityOne.bogieLoco != null) {
                lis.addAll(this.worldObj.func_72839_b((Entity)entityOne, entityOne.bogieLoco.field_70121_D.func_72314_b(7.0, 5.0, 7.0)));
            }
            if (lis != null && lis.size() > 0) {
                for (Object ent : lis) {
                    if (!(ent instanceof EntityRollingStock) || !((EntityRollingStock)ent).isAttaching) continue;
                    this.addStake((EntityRollingStock)ent, entityOne, true);
                }
            }
        }
        if (entityOne.cartLinked1 != null) {
            this.StakePhysic(entityOne.cartLinked1, entityOne, 1);
        }
        if (entityOne.cartLinked2 != null) {
            this.StakePhysic(entityOne.cartLinked2, entityOne, 2);
        }
    }

    private void doesLink1StillExist(Entity entityOne, List lis) {
        boolean link1Missing = false;
        boolean link2Missing = false;
        for (int j1 = 0; j1 < lis.size(); ++j1) {
            Entity entity = (Entity)lis.get(j1);
            link1Missing = !(entity instanceof AbstractTrains) || (double)((AbstractTrains)entity).getUniqueTrainID() != ((AbstractTrains)entityOne).Link1;
            link2Missing = !(entity instanceof AbstractTrains) || (double)((AbstractTrains)entity).getUniqueTrainID() != ((AbstractTrains)entityOne).Link2;
        }
        ++((AbstractTrains)entityOne).clearLinkTimer;
        if (((AbstractTrains)entityOne).clearLinkTimer < 20) {
            return;
        }
        ((AbstractTrains)entityOne).clearLinkTimer = 0;
        if (link1Missing && ((AbstractTrains)entityOne).Link1 != 0.0 && ((AbstractTrains)entityOne).Link1 != -1.0) {
            System.out.println("clear 1   " + ((AbstractTrains)entityOne).Link1 + "  " + entityOne);
            this.freeLink1(entityOne);
        }
        if (link2Missing && ((AbstractTrains)entityOne).Link2 != 0.0 && ((AbstractTrains)entityOne).Link2 != -1.0) {
            System.out.println("clear 2   " + ((AbstractTrains)entityOne).Link2 + "  " + entityOne);
            this.freeLink2(entityOne);
        }
    }

    private void doesLink2StillExist(Entity entityOne, List lis) {
        for (int j1 = 0; j1 < lis.size(); ++j1) {
            Entity entity = (Entity)lis.get(j1);
            if (!(entity instanceof AbstractTrains) || (double)((AbstractTrains)entity).getUniqueTrainID() != ((AbstractTrains)entityOne).Link2) continue;
            return;
        }
        ++((AbstractTrains)entityOne).clearLinkTimer;
        if (((AbstractTrains)entityOne).clearLinkTimer < 60) {
            return;
        }
        ((AbstractTrains)entityOne).clearLinkTimer = 0;
        System.out.println("clear 1   " + ((AbstractTrains)entityOne).Link1 + "  " + entityOne);
        if (((AbstractTrains)entityOne).Link2 != 0.0) {
            this.freeLink2(entityOne);
        }
        if (((AbstractTrains)entityOne).Link2 == -1.0) {
            this.freeLink2(entityOne);
        }
    }

    private void freeLink1(Entity entity) {
        if (entity instanceof EntityRollingStock) {
            ((AbstractTrains)entity).Link1 = 0.0;
            ((AbstractTrains)entity).cartLinked1 = null;
            ((EntityRollingStock)entity).RollingStock.clear();
        }
    }

    private void freeLink2(Entity entity) {
        if (entity instanceof EntityRollingStock) {
            ((AbstractTrains)entity).Link2 = 0.0;
            ((AbstractTrains)entity).cartLinked2 = null;
            ((EntityRollingStock)entity).RollingStock.clear();
        }
    }

    private void addLinkNumber(Entity entity) {
        ((EntityRollingStock)entity).linkageNumber = 0;
        if (((AbstractTrains)entity).Link1 != 0.0) {
            ++((EntityRollingStock)entity).linkageNumber;
        } else if (((EntityRollingStock)entity).linkageNumber > 0) {
            --((EntityRollingStock)entity).linkageNumber;
        }
        if (((AbstractTrains)entity).Link2 != 0.0) {
            ++((EntityRollingStock)entity).linkageNumber;
        } else if (((EntityRollingStock)entity).linkageNumber > 0) {
            --((EntityRollingStock)entity).linkageNumber;
        }
    }

    public void addStake(EntityRollingStock cart1, EntityRollingStock cart2, boolean byPlayer) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        this.distanceBehindCart = cart1.getLinkageDistance(cart1);
        if (cart2.isAttaching && cart1.isAttaching) {
            double[] distancesX = new double[4];
            double[] distancesZ = new double[4];
            double[] euclidian = new double[4];
            double d = 0.0;
            double d1 = 0.0;
            if (cart1.bogieLoco != null || cart2.bogieLoco != null) {
                int i;
                if (cart1.bogieLoco != null && cart2.bogieLoco == null) {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.bogieLoco.field_70165_t - cart2.field_70165_t;
                    distancesZ[1] = cart1.bogieLoco.field_70161_v - cart2.field_70161_v;
                    distancesX[2] = 100.0;
                    distancesZ[2] = 100.0;
                    distancesX[3] = 100.0;
                    distancesZ[3] = 100.0;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                } else if (cart1.bogieLoco == null) {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[1] = cart1.field_70161_v - cart2.bogieLoco.field_70161_v;
                    distancesX[2] = 100.0;
                    distancesZ[2] = 100.0;
                    distancesX[3] = 100.0;
                    distancesZ[3] = 100.0;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                } else {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.bogieLoco.field_70165_t - cart2.field_70165_t;
                    distancesZ[1] = cart1.bogieLoco.field_70161_v - cart2.field_70161_v;
                    distancesX[2] = cart1.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[2] = cart1.field_70161_v - cart2.bogieLoco.field_70161_v;
                    distancesX[3] = cart1.bogieLoco.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[3] = cart1.bogieLoco.field_70161_v - cart2.bogieLoco.field_70161_v;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                }
                double minX = euclidian[0];
                int minIndex = 0;
                for (int k = 0; k < euclidian.length; ++k) {
                    if (!(Math.abs(euclidian[k]) < Math.abs(minX))) continue;
                    minX = euclidian[k];
                    minIndex = k;
                }
                d = distancesX[minIndex];
                d1 = distancesZ[minIndex];
            } else {
                d = cart1.field_70165_t - cart2.field_70165_t;
                d1 = cart1.field_70161_v - cart2.field_70161_v;
            }
            if (MathHelper.func_76133_a((double)(d * d + d1 * d1)) <= this.distanceBehindCart) {
                EntityPlayer entityplayer;
                if (cart1.Link1 == 0.0 || cart1.Link1 == -1.0) {
                    cart1.Link1 = cart2.getUniqueTrainID();
                } else if (cart1.Link2 == 0.0 || cart1.Link2 == -1.0) {
                    cart1.Link2 = cart2.getUniqueTrainID();
                }
                if (cart1.cartLinked1 == null) {
                    cart1.cartLinked1 = cart2;
                } else if (cart1.cartLinked2 == null) {
                    cart1.cartLinked2 = cart2;
                }
                if (cart2.Link1 == 0.0 || cart2.Link1 == -1.0) {
                    cart2.Link1 = cart1.getUniqueTrainID();
                } else if (cart2.Link2 == 0.0 || cart2.Link2 == -1.0) {
                    cart2.Link2 = cart1.getUniqueTrainID();
                }
                if (cart2.cartLinked1 == null) {
                    cart2.cartLinked1 = cart1;
                } else if (cart2.cartLinked2 == null) {
                    cart2.cartLinked2 = cart1;
                }
                cart2.isAttached = true;
                cart2.isAttaching = false;
                cart1.isAttaching = false;
                cart1.isAttached = true;
                if (cart2.cartLinked1.train != null) {
                    EntityRollingStock.allTrains.remove(cart2.cartLinked1.train);
                    cart2.cartLinked1.train.getTrains().clear();
                }
                if (cart2.cartLinked2 != null && cart2.cartLinked2.train != null) {
                    EntityRollingStock.allTrains.remove(cart2.cartLinked2.train);
                    cart2.cartLinked2.train.getTrains().clear();
                }
                if ((entityplayer = cart1.field_70170_p.func_72890_a((Entity)cart1, 20.0)) != null && byPlayer) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("attached!"));
                }
            }
        }
    }

    public boolean areLinked(Entity cart1, Entity cart2) {
        if (!(cart1 instanceof AbstractTrains) || !(cart2 instanceof AbstractTrains)) {
            return false;
        }
        return (double)((AbstractTrains)cart2).getUniqueTrainID() == ((AbstractTrains)cart1).Link1 || (double)((AbstractTrains)cart2).getUniqueTrainID() == ((AbstractTrains)cart1).Link2 || (double)((AbstractTrains)cart1).getUniqueTrainID() == ((AbstractTrains)cart2).Link1 || (double)((AbstractTrains)cart1).getUniqueTrainID() == ((AbstractTrains)cart2).Link2;
    }

    public float getOptimalDistance(AbstractTrains cart1, AbstractTrains cart2) {
        return cart1.getOptimalDistance(cart2) + cart2.getOptimalDistance(cart1);
    }

    private boolean canCartBeAdjustedBy(Entity cart1, Entity cart2) {
        if (cart1 == cart2) {
            return false;
        }
        if (cart1 instanceof EntityRollingStock && !((EntityRollingStock)cart1).canBeAdjusted((EntityMinecart)cart2)) {
            return false;
        }
        return !RailTools.isCartLockedDown((EntityMinecart)cart1);
    }

    private void StakePhysic(EntityRollingStock cart1, EntityRollingStock cart2, int linkIndex) {
        if (this.worldObj.field_72995_K || cart1.field_70173_aa < 5 || cart2.field_70173_aa < 5) {
            return;
        }
        if (cart2.isAttached && cart1.isAttached && this.areLinked((Entity)cart2, (Entity)cart1)) {
            boolean adj1 = this.canCartBeAdjustedBy((Entity)cart1, (Entity)cart2);
            boolean adj2 = this.canCartBeAdjustedBy((Entity)cart2, (Entity)cart1);
            double[] distancesX = new double[4];
            double[] distancesZ = new double[4];
            double[] euclidian = new double[4];
            double d = 0.0;
            double d1 = 0.0;
            double vecX = 0.0;
            double vecZ = 0.0;
            int minIndex = 0;
            if (cart1.bogieLoco != null || cart2.bogieLoco != null) {
                int i;
                if (cart1.bogieLoco != null && cart2.bogieLoco == null) {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.bogieLoco.field_70165_t - cart2.field_70165_t;
                    distancesZ[1] = cart1.bogieLoco.field_70161_v - cart2.field_70161_v;
                    distancesX[2] = 100.0;
                    distancesZ[2] = 100.0;
                    distancesX[3] = 100.0;
                    distancesZ[3] = 100.0;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                } else if (cart1.bogieLoco == null) {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[1] = cart1.field_70161_v - cart2.bogieLoco.field_70161_v;
                    distancesX[2] = 100.0;
                    distancesZ[2] = 100.0;
                    distancesX[3] = 100.0;
                    distancesZ[3] = 100.0;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                } else {
                    distancesX[0] = cart1.field_70165_t - cart2.field_70165_t;
                    distancesZ[0] = cart1.field_70161_v - cart2.field_70161_v;
                    distancesX[1] = cart1.bogieLoco.field_70165_t - cart2.field_70165_t;
                    distancesZ[1] = cart1.bogieLoco.field_70161_v - cart2.field_70161_v;
                    distancesX[2] = cart1.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[2] = cart1.field_70161_v - cart2.bogieLoco.field_70161_v;
                    distancesX[3] = cart1.bogieLoco.field_70165_t - cart2.bogieLoco.field_70165_t;
                    distancesZ[3] = cart1.bogieLoco.field_70161_v - cart2.bogieLoco.field_70161_v;
                    for (i = 0; i < distancesX.length; ++i) {
                        euclidian[i] = MathHelper.func_76133_a((double)(distancesX[i] * distancesX[i] + distancesZ[i] * distancesZ[i]));
                    }
                }
                double minX = euclidian[0];
                for (int k = 0; k < euclidian.length; ++k) {
                    if (!(Math.abs(euclidian[k]) < Math.abs(minX))) continue;
                    minX = euclidian[k];
                    minIndex = k;
                }
                d = distancesX[minIndex];
                d1 = distancesZ[minIndex];
                vecX = d;
                vecZ = d1;
            } else {
                d = cart1.field_70165_t - cart2.field_70165_t;
                d1 = cart1.field_70161_v - cart2.field_70161_v;
                vecX = cart1.field_70165_t - cart2.field_70165_t;
                vecZ = cart1.field_70161_v - cart2.field_70161_v;
            }
            double d2 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
            if (d2 > 20.0) {
                EntityPlayer player;
                if (cart1.field_70170_p != null && (player = cart1.field_70170_p.func_72977_a(cart1.field_70165_t, cart1.field_70163_u, cart1.field_70161_v, 300.0)) != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(String.format("[TRAINCRAFT] The rolling stock at %d %d %d had a problem loading and has lost its link. Attached cart was too far away", (int)cart1.field_70165_t, (int)cart1.field_70163_u, (int)cart1.field_70161_v)));
                }
                if (linkIndex == 1) {
                    this.freeLink1((Entity)cart1);
                    this.freeLink1((Entity)cart2);
                }
                if (linkIndex == 2) {
                    this.freeLink2((Entity)cart1);
                    this.freeLink2((Entity)cart2);
                }
                return;
            }
            double vecNorm = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
            double unitX = vecX / vecNorm;
            double unitZ = vecZ / vecNorm;
            double stretch = d2 - (double)this.getOptimalDistance(cart1, cart2);
            double springX = this.limitForce(0.4 * stretch * vecX * -1.0);
            double springZ = this.limitForce(0.4 * stretch * vecZ * -1.0);
            if (adj1) {
                cart1.field_70159_w += springX;
                cart1.field_70179_y += springZ;
            }
            if (adj2) {
                cart2.field_70159_w -= springX;
                cart2.field_70179_y -= springZ;
            }
            double dot = (cart1.field_70159_w - cart2.field_70159_w) * unitX + (cart1.field_70179_y - cart2.field_70179_y) * unitZ;
            double dampX = this.limitForce(0.4 * dot * unitX * -1.0);
            double dampZ = this.limitForce(0.4 * dot * unitZ * -1.0);
            if (adj1) {
                cart1.field_70159_w += dampX;
                cart1.field_70179_y += dampZ;
            }
            if (adj2) {
                cart2.field_70159_w -= dampX;
                cart2.field_70179_y -= dampZ;
            }
        }
    }

    private double limitForce(double force) {
        return Math.copySign(Math.abs(Math.min(Math.abs(force), 14.0)), force);
    }

    private double limitForce(double force, double max) {
        return Math.copySign(Math.abs(Math.min(Math.abs(force), max)), force);
    }
}

