/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import train.common.api.Locomotive;
import train.common.blocks.tracks.SpeedControllerSteel;
import train.common.blocks.tracks.TrackBaseTraincraft;
import train.common.library.Tracks;

public class BlockLocomotiveSpeedControllerTrack
extends TrackBaseTraincraft
implements ITrackPowered {
    private int mode = 0;
    private boolean powered;

    public BlockLocomotiveSpeedControllerTrack() {
        this.speedController = SpeedControllerSteel.getInstance();
    }

    @Override
    public Tracks getTrackType() {
        return Tracks.LOCO_SPEED_CONTROLLER;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.mode += 3;
            if (this.mode > 15) {
                this.mode = 0;
            }
            if (this.mode == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentText("20 percent of max speed"));
            }
            if (this.mode == 3) {
                player.func_145747_a((IChatComponent)new ChatComponentText("40 percent of max speed"));
            }
            if (this.mode == 6) {
                player.func_145747_a((IChatComponent)new ChatComponentText("60 percent of max speed"));
            }
            if (this.mode == 9) {
                player.func_145747_a((IChatComponent)new ChatComponentText("80 percent of max speed"));
            }
            if (this.mode == 12) {
                player.func_145747_a((IChatComponent)new ChatComponentText("90 percent of max speed"));
            }
            if (this.mode == 15) {
                player.func_145747_a((IChatComponent)new ChatComponentText("100 percent of max speed"));
            }
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        if (this.powered) {
            this.mode = this.getWorld().func_94577_B(this.getX(), this.getY(), this.getZ());
        }
        super.onNeighborBlockChange(block);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (cart instanceof Locomotive) {
            if (this.mode == 0) {
                ((Locomotive)cart).speedLimiter = 0.1;
            }
            if (this.mode == 1) {
                ((Locomotive)cart).speedLimiter = 0.15;
            }
            if (this.mode == 2) {
                ((Locomotive)cart).speedLimiter = 0.2;
            }
            if (this.mode == 3) {
                ((Locomotive)cart).speedLimiter = 0.25;
            }
            if (this.mode == 4) {
                ((Locomotive)cart).speedLimiter = 0.3;
            }
            if (this.mode == 5) {
                ((Locomotive)cart).speedLimiter = 0.35;
            }
            if (this.mode == 6) {
                ((Locomotive)cart).speedLimiter = 0.4;
            }
            if (this.mode == 7) {
                ((Locomotive)cart).speedLimiter = 0.45;
            }
            if (this.mode == 8) {
                ((Locomotive)cart).speedLimiter = 0.5;
            }
            if (this.mode == 9) {
                ((Locomotive)cart).speedLimiter = 0.6;
            }
            if (this.mode == 10) {
                ((Locomotive)cart).speedLimiter = 0.65;
            }
            if (this.mode == 11) {
                ((Locomotive)cart).speedLimiter = 0.7;
            }
            if (this.mode == 12) {
                ((Locomotive)cart).speedLimiter = 0.75;
            }
            if (this.mode == 13) {
                ((Locomotive)cart).speedLimiter = 0.85;
            }
            if (this.mode == 14) {
                ((Locomotive)cart).speedLimiter = 0.9;
            }
            if (this.mode == 15) {
                ((Locomotive)cart).speedLimiter = 1.0;
            }
            ((Locomotive)cart).speedWasSet = true;
        }
    }

    @Override
    public IIcon getIcon() {
        int value = 0;
        if (this.mode >= 0 && this.mode < 3) {
            value = 0;
        }
        if (this.mode >= 3 && this.mode < 6) {
            value = 1;
        }
        if (this.mode >= 6 && this.mode < 8) {
            value = 2;
        }
        if (this.mode >= 8 && this.mode < 13) {
            value = 3;
        }
        if (this.mode >= 13 && this.mode <= 15) {
            value = 4;
        }
        return this.getIcon(value);
    }

    protected void notifyNeighbors() {
        Block block = this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), block);
        this.getWorld().func_147459_d(this.getX(), this.getY() - 1, this.getZ(), block);
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("mode", this.mode);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.mode = nbttagcompound.func_74762_e("mode");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.mode);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.mode = data.readInt();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }
}

