/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockTraincraftFluid
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] theIcon;
    protected boolean flammable;
    protected int flammability = 0;

    public BlockTraincraftFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.theIcon != null ? (side != 0 && side != 1 ? this.theIcon[1] : this.theIcon[0]) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.theIcon = new IIcon[]{iconRegister.func_94245_a("tc".toLowerCase() + ":liquid_" + this.fluidName), iconRegister.func_94245_a("tc".toLowerCase() + ":liquid_" + this.fluidName + "_flow")};
    }

    public BlockTraincraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockTraincraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.flammable && this.flammability == 0;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && super.displaceIfPossible(world, x, y, z);
    }

    public String func_149739_a() {
        return "fluid.tc:" + this.fluidName;
    }
}

