/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import train.common.api.LiquidManager;
import train.common.api.Locomotive;
import train.common.api.Tender;
import train.common.core.handlers.FuelHandler;

public abstract class SteamTrain
extends Locomotive
implements IFluidHandler {
    public int fuelSlot = 1;
    public int waterSlot = 1;
    protected int maxTank;
    private int maxFuel = 20000;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];

    public SteamTrain(World world, int capacity) {
        this(capacity, world, null);
    }

    public SteamTrain(World world, int capacity, FluidStack filter) {
        this(capacity, world, filter);
    }

    private SteamTrain(int capacity, World world, FluidStack filter) {
        super(world);
        this.maxTank = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        } else {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)0);
        this.numCargoSlots = 3;
        this.numCargoSlots1 = 3;
        this.numCargoSlots2 = 3;
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1 + this.fuelSlot + this.waterSlot;
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public int getWaterConsumption() {
        if (this.trainSpec != null) {
            return this.trainSpec.getWaterConsumption();
        }
        return 200;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().getFluidID());
        }
        if (this.theTank != null && this.theTank.getFluid() != null && this.getIsFuelled()) {
            if (this.theTank.getFluid().amount <= 1) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
        if (this.field_70146_Z.nextInt(100) == 0 && this.getWater() > 0 && this.getIsFuelled()) {
            this.drain(ForgeDirection.UNKNOWN, this.getWaterConsumption() / 5, true);
        }
    }

    public int getWater() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
        this.canBeAdjusted = nbttagcompound.func_74767_n("canBeAdjusted");
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    private void placeInInvent(ItemStack itemstack1, SteamTrain loco) {
        for (int i = 2; i < loco.locoInvent.length; ++i) {
            if (loco.locoInvent[i] == null) {
                loco.locoInvent[i] = itemstack1;
                return;
            }
            if (loco.locoInvent[i] != null && loco.locoInvent[i].func_77973_b() == itemstack1.func_77973_b() && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.locoInvent[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.locoInvent[i], (ItemStack)itemstack1)) {
                int var9 = this.locoInvent[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= itemstack1.func_77976_d()) {
                    loco.locoInvent[i].field_77994_a = var9;
                    return;
                }
                if (this.locoInvent[i].field_77994_a >= this.locoInvent[i].func_77976_d()) continue;
                ++loco.locoInvent[i].field_77994_a;
                return;
            }
            if (i != loco.locoInvent.length - 1) continue;
            this.func_70099_a(itemstack1, 1.0f);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack, SteamTrain loco) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 1, this, itemstack)) != null) {
            this.placeInInvent(result, loco);
            this.func_70298_a(1, 1);
        }
    }

    protected void checkInvent(ItemStack locoInvent0, ItemStack locoInvent1, SteamTrain loco) {
        if (!this.canCheckInvent) {
            return;
        }
        boolean hasCoalInTender = false;
        if (this.isLocoTurnedOn() && this.field_70173_aa % 10 == 0) {
            FluidStack drain = null;
            if (this.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), false) == 100) {
                for (TileEntity block : this.blocksToCheck = new TileEntity[]{this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 2.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 3.0)), MathHelper.func_76128_c((double)this.field_70161_v)), this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 4.0)), MathHelper.func_76128_c((double)this.field_70161_v))}) {
                    if (drain != null || !(block instanceof IFluidHandler)) continue;
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        if (((IFluidHandler)block).drain(direction, 100, false) == null || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).fluid != FluidRegistry.WATER || ((IFluidHandler)block).drain((ForgeDirection)direction, (int)100, (boolean)false).amount != 100) continue;
                        drain = ((IFluidHandler)block).drain(direction, 100, true);
                    }
                }
            }
            if (this.cartLinked1 instanceof Tender) {
                if (drain == null && this.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), false) == 100 && (this.getFluid() == null || this.getFluid().getFluid() == FluidRegistry.WATER)) {
                    drain = ((Tender)this.cartLinked1).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                }
                for (int h = 0; h < ((Tender)this.cartLinked1).tenderItems.length; ++h) {
                    if (((Tender)this.cartLinked1).tenderItems[h] == null || FuelHandler.steamFuelLast(((Tender)this.cartLinked1).tenderItems[h]) == 0 || this.getFuel() >= this.maxFuel || this.getFuel() + FuelHandler.steamFuelLast(((Tender)this.cartLinked1).tenderItems[h]) > this.maxFuel) continue;
                    this.fuelTrain += FuelHandler.steamFuelLast(((Tender)this.cartLinked1).tenderItems[h]);
                    hasCoalInTender = true;
                    ((Tender)this.cartLinked1).func_70298_a(h, 1);
                    break;
                }
            } else if (this.cartLinked2 instanceof Tender) {
                if (drain == null && this.fill(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), false) == 100 && (this.getFluid() == null || this.getFluid().getFluid() == FluidRegistry.WATER)) {
                    drain = ((Tender)this.cartLinked2).drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.WATER, 100), true);
                }
                for (int h = 0; h < ((Tender)this.cartLinked2).tenderItems.length; ++h) {
                    if (((Tender)this.cartLinked2).tenderItems[h] == null || FuelHandler.steamFuelLast(((Tender)this.cartLinked2).tenderItems[h]) == 0 || this.getFuel() >= this.maxFuel || this.getFuel() + FuelHandler.steamFuelLast(((Tender)this.cartLinked2).tenderItems[h]) > this.maxFuel) continue;
                    this.fuelTrain += FuelHandler.steamFuelLast(((Tender)this.cartLinked2).tenderItems[h]);
                    hasCoalInTender = true;
                    ((Tender)this.cartLinked2).func_70298_a(h, 1);
                    break;
                }
            }
            if (drain != null) {
                this.fill(ForgeDirection.UNKNOWN, drain, true);
            }
        }
        if (!hasCoalInTender && locoInvent0 != null && FuelHandler.steamFuelLast(locoInvent0) != 0 && this.getFuel() < this.maxFuel && this.getFuel() + FuelHandler.steamFuelLast(locoInvent0) <= this.maxFuel) {
            this.fuelTrain += FuelHandler.steamFuelLast(locoInvent0);
            this.func_70298_a(0, 1);
        }
        if (locoInvent1 != null) {
            this.liquidInSlot(locoInvent1, loco);
            return;
        }
        if (this.getFuel() <= 0) {
            this.field_70159_w *= 0.88;
            this.field_70179_y *= 0.88;
        }
    }

    @Override
    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / this.maxFuel;
        }
        return this.fuelTrain * i / this.maxFuel;
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }
}

