/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import train.common.adminbook.ServerLogger;
import train.common.api.EntityRollingStock;
import train.common.api.Tender;

public abstract class Freight
extends EntityRollingStock
implements IInventory {
    public ItemStack[] cargoItems;
    protected double itemInsideCount = 0.0;
    private int slotsFilled = 0;

    public Freight(World world) {
        super(world);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            ServerLogger.deleteWagon(this);
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
            }
        }
        return true;
    }

    public ItemStack func_70301_a(int i) {
        return this.cargoItems[i];
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.cargoItems[i] != null) {
            if (this.cargoItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.cargoItems[i];
                this.cargoItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i].func_77979_a(j);
            if (this.cargoItems[i].field_77994_a == 0) {
                this.cargoItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargoItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70296_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.slotsFilled = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack == null) continue;
                ++this.slotsFilled;
            }
            this.field_70180_af.func_75692_b(22, (Object)this.slotsFilled);
        }
    }

    public String func_145825_b() {
        return "Freight cart";
    }

    public abstract int func_70302_i_();

    @Override
    public boolean isStorageCart() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.handleMass();
    }

    protected void handleMass() {
        if (this.field_70173_aa % 10 != 0) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.mass = this.getDefaultMass();
        this.itemInsideCount = 0.0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null || itemstack.field_77994_a <= 0) continue;
            this.itemInsideCount += (double)itemstack.field_77994_a;
        }
        this.mass += this.itemInsideCount * 1.0E-4;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int getAmmountOfCargo() {
        return this.field_70180_af.func_75679_c(22);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        int i;
        super.func_70037_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        ItemStack[] cargoItemsCount = new ItemStack[this.func_70302_i_()];
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= cargoItemsCount.length) continue;
            cargoItemsCount[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.slotsFilled = 0;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = cargoItemsCount[i];
            if (itemstack == null) continue;
            ++this.slotsFilled;
        }
        this.field_70180_af.func_75692_b(22, (Object)this.slotsFilled);
    }

    @Override
    public void dropCartAsItem(boolean isCreative) {
        if (!this.itemdropped) {
            super.dropCartAsItem(isCreative);
            if (!(this instanceof Tender) && this.cargoItems != null) {
                for (ItemStack stack : this.cargoItems) {
                    if (stack == null) continue;
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }
    }

    @Override
    public ItemStack[] getInventory() {
        return this.cargoItems;
    }
}

