/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IRoutableCart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.api.EntityRollingStock;
import train.common.blocks.BlockTCRail;
import train.common.blocks.BlockTCRailGag;
import train.common.items.ItemTCRail;
import train.common.library.BlockIDs;
import train.common.tile.TileTCRail;
import train.common.tile.TileTCRailGag;

public class EntityBogie
extends EntityMinecart
implements IMinecart,
IRoutableCart {
    public boolean isOnRail = false;
    public float prevDpdx = 0.0f;
    public float prevDpdz = 0.0f;
    public World field_70170_p;
    public int meta;
    public EntityRollingStock entityMainTrain;
    public int entityMainTrainID;
    protected int bogieIndex;
    public double bogieShift;
    protected Side side;
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private boolean isDerail = false;

    public EntityBogie(World world) {
        super(world);
        this.field_70170_p = world;
        if (this.entityMainTrain != null) {
            this.func_70105_a(this.entityMainTrain.field_70130_N, this.entityMainTrain.field_70131_O);
        } else {
            this.func_70105_a(0.98f, 1.98f);
        }
        EntityBogie.setCollisionHandler(null);
        this.field_70129_M = 0.65f;
        this.side = FMLCommonHandler.instance().getEffectiveSide();
    }

    public EntityBogie(World world, double d, double d1, double d2, EntityRollingStock mainTrain, int id, int index, double bogieShift) {
        this(world);
        this.entityMainTrain = mainTrain;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.entityMainTrainID = id;
        this.bogieIndex = index;
        this.bogieShift = bogieShift;
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
    }

    public boolean func_70104_M() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70097_a(DamageSource damageSource, float f) {
        return this.entityMainTrain != null && this.entityMainTrain.func_70097_a(damageSource, f);
    }

    public void func_70108_f(Entity entity) {
        if (this.entityMainTrain != null && entity != this.entityMainTrain) {
            this.entityMainTrain.func_70108_f(entity);
        }
    }

    public void updateDistance() {
        float angle = (float)Math.toDegrees(Math.atan2(this.field_70161_v - this.entityMainTrain.field_70161_v, this.field_70165_t - this.entityMainTrain.field_70165_t)) - 90.0f;
        angle = MathHelper.func_76142_g((float)angle);
        this.field_70159_w = this.entityMainTrain.field_70165_t + Math.cos(Math.toRadians(angle + 90.0f)) * Math.abs(this.bogieShift) - this.field_70165_t;
        this.field_70179_y = this.entityMainTrain.field_70161_v + Math.sin(Math.toRadians(angle + 90.0f)) * Math.abs(this.bogieShift) - this.field_70161_v;
        if (!(this.isOnRail() || this.entityMainTrain.field_70159_w == 0.0 && this.entityMainTrain.field_70179_y == 0.0)) {
            this.isDerail = true;
        }
    }

    public boolean isOnRail() {
        Block block;
        int k;
        int j;
        if (this.isDerail) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147437_c(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            --j;
        }
        return BlockRailBase.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(i, j, k))) || block == BlockIDs.tcRail.block || block == BlockIDs.tcRailGag.block;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return this.field_70131_O / 2.0f;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.entityMainTrain != null) {
            this.entityMainTrain.func_130002_c(entityplayer);
        }
        return true;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.entityMainTrainID = nbttagcompound.func_74762_e("trainID");
        this.bogieIndex = nbttagcompound.func_74762_e("bogieIndex");
        this.bogieShift = nbttagcompound.func_74769_h("bogieShift");
        super.func_70037_a(nbttagcompound);
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("trainID", this.entityMainTrainID);
        nbttagcompound.func_74768_a("bogieIndex", this.bogieIndex);
        nbttagcompound.func_74780_a("bogieShift", this.bogieShift);
        super.func_70014_b(nbttagcompound);
    }

    public int func_94087_l() {
        return -1;
    }

    @Override
    public String getDestination() {
        if (this.entityMainTrain != null) {
            return this.entityMainTrain.getDestination();
        }
        return null;
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        return this.entityMainTrain != null && this.entityMainTrain.setDestination(ticket);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return false;
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public double getSlopeAdjustment() {
        return 0.0;
    }

    public float getMaxCartSpeedOnRail() {
        return 1.8f;
    }

    protected void func_145821_a(int x, int y, int z, double maxSpeed, double slopeAdjustment, Block block, int railMeta) {
        super.func_145821_a(x, y, z, (double)this.getMaxCartSpeedOnRail(), slopeAdjustment, block, railMeta);
    }

    public void func_70071_h_() {
        this.setCurrentCartSpeedCapOnRail(1.8f);
        this.setMaxSpeedAirLateral(1.8f);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
        if (BlockRailBase.func_150051_a((Block)block) || block == BlockIDs.tcRail.block || block == BlockIDs.tcRailGag.block) {
            --j;
        } else {
            Block block2 = this.field_70170_p.func_147439_a(i, j + 1, k);
            if (BlockRailBase.func_150051_a((Block)block2) || block2 == BlockIDs.tcRail.block || block2 == BlockIDs.tcRailGag.block) {
                ++j;
            }
            block = this.field_70170_p.func_147439_a(i, j, k);
        }
        if (BlockRailBase.func_150051_a((Block)block)) {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M - 0.3, this.field_70161_v);
            }
        } else if (this.field_70170_p.field_72995_K) {
            if (this.turnProgress > 0) {
                double d6 = this.field_70165_t + (this.minecartX - this.field_70165_t) / (double)this.turnProgress;
                double d7 = this.field_70163_u + (this.minecartY - this.field_70163_u) / (double)this.turnProgress;
                double d1 = this.field_70161_v + (this.minecartZ - this.field_70161_v) / (double)this.turnProgress;
                double d3 = MathHelper.func_76138_g((double)(this.minecartYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.minecartPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(d6, d7, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            TileEntity tileEntity = this.field_70170_p.func_147438_o(i, j, k);
            if (block == BlockIDs.tcRailGag.block) {
                if (tileEntity instanceof TileTCRailGag) {
                    TileTCRailGag tileGag = (TileTCRailGag)tileEntity;
                    tileEntity = this.field_70170_p.func_147438_o(tileGag.originX, tileGag.originY, tileGag.originZ);
                } else {
                    return;
                }
            }
            if (!(tileEntity instanceof TileTCRail)) {
                super.func_70071_h_();
                return;
            }
            TileTCRail tileRail = (TileTCRail)tileEntity;
            this.limitSpeedOnTCRail();
            if (ItemTCRail.isTCTurnTrack(tileRail)) {
                int meta = tileRail.func_145832_p();
                if (this.shouldIgnoreSwitch(tileRail, i, j, k, meta)) {
                    this.moveOnTCStraight(j, tileRail.field_145851_c, tileRail.field_145849_e, tileRail.func_145832_p());
                } else if (ItemTCRail.isTCTurnTrack(tileRail)) {
                    this.moveOnTC90TurnRail(j, tileRail.r, tileRail.cx, tileRail.cz);
                }
            }
            if (ItemTCRail.isTCStraightTrack(tileRail)) {
                this.moveOnTCStraight(j, tileRail.field_145851_c, tileRail.field_145849_e, tileRail.func_145832_p());
            } else if (ItemTCRail.isTCTwoWaysCrossingTrack(tileRail)) {
                this.moveOnTCTwoWaysCrossing();
            } else if (ItemTCRail.isTCSlopeTrack(tileRail)) {
                this.moveOnTCSlope(j, tileRail.field_145851_c, tileRail.field_145849_e, tileRail.slopeAngle, tileRail.slopeHeight, tileRail.func_145832_p());
            }
        }
        this.func_145775_I();
        this.field_70125_A = 0.0f;
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisAlignedBB;
            List list;
            if (this.entityMainTrain == null) {
                this.func_70106_y();
                this.field_70170_p.func_72900_e((Entity)this);
            }
            if ((list = this.field_70170_p.func_72839_b((Entity)this, axisAlignedBB = EntityBogie.getCollisionHandler() != null ? EntityBogie.getCollisionHandler().getMinecartCollisionBox((EntityMinecart)this) : this.field_70121_D.func_72314_b(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity == this.field_70153_n) continue;
                    this.func_70108_f(entity);
                }
            }
        }
        if (this.field_70165_t == 0.0 && this.field_70161_v == 0.0) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    private void moveOnTCStraight(int j, double cx, double cz, int meta) {
        this.field_70163_u = j;
        if (meta == 2 || meta == 0) {
            double norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.func_70107_b(cx + 0.5, this.field_70163_u + (double)this.field_70129_M + (double)this.field_70139_V + 0.5, this.field_70161_v);
            this.field_70159_w = 0.0;
            this.field_70179_y = Math.copySign(norm, this.field_70179_y);
            this.field_70121_D.func_72317_d(0.0, 0.0, Math.copySign(norm, this.field_70179_y));
            List boxes = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D);
            for (Object b : boxes) {
                if (b instanceof BlockRailBase || b instanceof BlockTCRail || b instanceof BlockTCRailGag || b instanceof BlockAir) continue;
                return;
            }
            this.func_70107_b((this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) * 0.5, this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V - 0.5, (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) * 0.5);
        }
        if (meta == 1 || meta == 3) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M + (double)this.field_70139_V + 0.5, cz + 0.5);
            this.field_70159_w = Math.copySign(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y), this.field_70159_w);
            this.field_70179_y = 0.0;
            this.field_70121_D.func_72317_d(this.field_70159_w, 0.0, 0.0);
            List boxes = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D);
            for (Object b : boxes) {
                if (b instanceof BlockRailBase || b instanceof BlockTCRail || b instanceof BlockTCRailGag || b instanceof BlockAir) continue;
                return;
            }
            this.func_70107_b((this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) * 0.5, this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V - 0.5, (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) * 0.5);
        }
    }

    private void moveOnTCTwoWaysCrossing() {
        double norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (Math.abs(this.field_70179_y) > Math.abs(this.field_70159_w)) {
            this.func_70091_d(0.0, 0.0, Math.copySign(norm, this.field_70179_y));
        } else {
            this.func_70091_d(Math.copySign(norm, this.field_70159_w), 0.0, 0.0);
        }
    }

    private void moveOnTCSlope(int j, double cx, double cz, double slopeAngle, double slopeHeight, int meta) {
        this.field_70163_u = (double)j + 0.5;
        if (meta == 2 || meta == 0) {
            if (meta == 2) {
                cz += 1.0;
            }
            double norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            double newPosY = Math.abs((double)j + Math.tan(slopeAngle * Math.abs(cz - this.field_70161_v)) + (double)this.field_70129_M + 0.3);
            this.func_70107_b(cx + 0.5, newPosY, this.field_70161_v);
            this.field_70121_D.func_72317_d(0.0, 0.0, Math.copySign(norm, this.field_70179_y));
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = Math.copySign(norm, this.field_70179_y);
        } else if (meta == 1 || meta == 3) {
            if (meta == 1) {
                cx += 1.0;
            }
            double norm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            double newPosY = (double)j + Math.tan(slopeAngle * Math.abs(cx - this.field_70165_t)) + (double)this.field_70129_M + 0.3;
            this.func_70107_b(this.field_70165_t, newPosY, cz + 0.5);
            this.field_70121_D.func_72317_d(Math.copySign(norm, this.field_70159_w), 0.0, 0.0);
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            this.field_70159_w = Math.copySign(norm, this.field_70159_w);
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    private void moveOnTC90TurnRail(int j, double r, double cx, double cz) {
        this.field_70163_u = j;
        double cpx = this.field_70165_t - cx;
        double cpz = this.field_70161_v - cz;
        double cp_norm = Math.sqrt(cpx * cpx + cpz * cpz);
        double vnorm = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double vx2 = -(cpz / cp_norm) * vnorm;
        double vz2 = cpx / cp_norm * vnorm;
        double px2_cx = this.field_70165_t + this.field_70159_w - cx;
        double pz2_cz = this.field_70161_v + this.field_70179_y - cz;
        double p2_c_norm = Math.sqrt(px2_cx * px2_cx + pz2_cz * pz2_cz);
        double p_corr_x = cx + cpx / cp_norm * r;
        double p_corr_z = cz + cpz / cp_norm * r;
        this.func_70107_b(p_corr_x, this.field_70163_u + (double)this.field_70129_M, p_corr_z);
        this.field_70159_w = Math.copySign(vx2, cx + px2_cx / p2_c_norm * r - this.field_70165_t);
        this.field_70179_y = Math.copySign(vz2, cz + pz2_cz / p2_c_norm * r - this.field_70161_v);
        this.func_70091_d(this.field_70159_w, 0.0, this.field_70179_y);
    }

    private boolean shouldIgnoreSwitch(TileTCRail tile, int i, int j, int k, int meta) {
        if (tile != null && (tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_RIGHT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.MEDIUM_LEFT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.LARGE_LEFT_TURN.getLabel()) || tile.getType().equals(ItemTCRail.TrackTypes.LARGE_RIGHT_TURN.getLabel())) && tile.canTypeBeModifiedBySwitch) {
            if (meta == 2 && this.field_70179_y > 0.0 && Math.abs(this.field_70159_w) < 0.01) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i, j, k + 1);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 0 && this.field_70179_y < 0.0 && Math.abs(this.field_70159_w) < 0.01) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i, j, k - 1);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 1 && Math.abs(this.field_70179_y) < 0.01 && this.field_70159_w > 0.0) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i + 1, j, k);
                if (tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
            if (meta == 3 && Math.abs(this.field_70179_y) < 0.01 && this.field_70159_w < 0.0) {
                TileEntity tile2 = this.field_70170_p.func_147438_o(i - 1, j, k);
                if (tile2 != null && tile2 instanceof TileTCRail) {
                    ((TileTCRail)tile2).setSwitchState(false, true);
                }
                return true;
            }
        }
        return false;
    }

    private void limitSpeedOnTCRail() {
        double maxSpeed = Math.min(3.0, (double)this.getMaxCartSpeedOnRail());
        if (this.field_70159_w < -maxSpeed) {
            this.field_70159_w = -maxSpeed;
        } else if (this.field_70159_w > maxSpeed) {
            this.field_70159_w = maxSpeed;
        }
        if (this.field_70179_y < -maxSpeed) {
            this.field_70179_y = -maxSpeed;
        } else if (this.field_70179_y > maxSpeed) {
            this.field_70179_y = maxSpeed;
        }
    }

    @Override
    public GameProfile getOwner() {
        return this.entityMainTrain.getOwner();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double p_70056_1_, double p_70056_3_, double p_70056_5_, float p_70056_7_, float p_70056_8_, int p_70056_9_) {
        super.func_70056_a(p_70056_1_, p_70056_3_, p_70056_5_, p_70056_7_, p_70056_8_, p_70056_9_);
        this.minecartX = p_70056_1_;
        this.minecartY = p_70056_3_;
        this.minecartZ = p_70056_5_;
        this.minecartYaw = p_70056_7_;
        this.minecartPitch = p_70056_8_;
        this.turnProgress = p_70056_9_ + 2;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }
}

