/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IRoutableCart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import train.client.render.RenderEnum;
import train.common.Traincraft;
import train.common.adminbook.ItemAdminBook;
import train.common.api.AbstractWorkCart;
import train.common.api.EntityRollingStock;
import train.common.api.IPassenger;
import train.common.api.Locomotive;
import train.common.core.handlers.ConfigHandler;
import train.common.core.handlers.TrainHandler;
import train.common.items.ItemChunkLoaderActivator;
import train.common.items.ItemWrench;
import train.common.library.EnumTrains;

public abstract class AbstractTrains
extends EntityMinecart
implements IMinecart,
IRoutableCart,
IEntityAdditionalSpawnData {
    protected int color;
    public boolean isAttached = false;
    public boolean isAttaching = false;
    public static int numberOfTrains;
    public EntityPlayer playerEntity;
    public double Link1;
    public double Link2;
    protected boolean linked = false;
    public EntityRollingStock cartLinked1;
    public EntityRollingStock cartLinked2;
    public int clearLinkTimer = 0;
    protected ForgeChunkManager.Ticket chunkTicket;
    public float renderYaw;
    protected float renderPitch;
    public TrainHandler train;
    public List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();
    public boolean shouldChunkLoad = true;
    protected boolean itemdropped = false;
    protected EnumTrains trainSpec;
    public String trainName = "";
    public double accelerate = 0.7;
    public double brake = 0.96;
    public double mass = 1.0;
    public double defaultMass = 1.0;
    public int power = 0;
    public boolean locked = false;
    public String trainOwner = "";
    public String trainCreator = "";
    public String trainType = "";
    protected String trainDestroyer = "";
    public int uniqueID = -1;
    public static int uniqueIDs;
    public RenderEnum renderData = null;
    public double trainDistanceTraveled = 0.0;
    public String destination = "";
    public ArrayList<Byte> acceptedColors;

    public String getTrainOwner() {
        return this.trainOwner;
    }

    public void setTrainOwner(String trainOwner) {
        this.trainOwner = trainOwner;
    }

    public AbstractTrains(World world) {
        super(world);
        this.field_70155_l = 2.0;
        this.color = -1;
        this.field_70180_af.func_75682_a(12, (Object)this.color);
        this.acceptedColors = new ArrayList();
        this.field_70180_af.func_75682_a(6, (Object)this.trainType);
        this.field_70180_af.func_75682_a(7, (Object)this.trainOwner);
        this.field_70180_af.func_75682_a(8, (Object)this.trainDestroyer);
        this.field_70180_af.func_75682_a(9, (Object)this.trainName);
        this.field_70180_af.func_75682_a(10, (Object)numberOfTrains);
        this.field_70180_af.func_75682_a(11, (Object)this.uniqueID);
        this.field_70180_af.func_75682_a(13, (Object)this.trainCreator);
        this.shouldChunkLoad = ConfigHandler.CHUNK_LOADING;
        this.func_70052_a(7, this.shouldChunkLoad);
        for (EnumTrains trains : EnumTrains.values()) {
            if (!trains.getEntityClass().equals(this.getClass())) continue;
            this.setDefaultMass(trains.getMass());
            this.trainSpec = trains;
            if (trains.getColors() != null) {
                for (int i = 0; i < trains.getColors().length; ++i) {
                    this.acceptedColors.add(trains.getColors()[i]);
                }
            }
            this.func_70105_a(0.98f, 1.98f);
            this.func_96094_a(this.trainSpec.name());
            break;
        }
    }

    public AbstractTrains(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public AxisAlignedBB func_70114_g(Entity p_70114_1_) {
        if (this.field_70153_n != p_70114_1_) {
            return super.func_70114_g(p_70114_1_);
        }
        return null;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.locked = additionalData.readBoolean();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.locked);
    }

    public abstract boolean isLocomotive();

    public abstract boolean isPassenger();

    public abstract boolean isFreightCart();

    public abstract boolean isFreightOrPassenger();

    public abstract boolean isBuilder();

    public abstract boolean isTender();

    public abstract boolean isWorkCart();

    public abstract boolean isElectricTrain();

    public abstract boolean isLinked();

    protected abstract boolean canOverheat();

    protected abstract int getOverheatTime();

    public abstract float getLinkageDistance(EntityMinecart var1);

    public abstract boolean canBeAdjusted(EntityMinecart var1);

    public abstract float getOptimalDistance(EntityMinecart var1);

    public abstract List<ItemStack> getItemsDropped();

    public int getUniqueTrainID() {
        return this.uniqueID;
    }

    public void manageChunkLoading() {
        if (!this.field_70170_p.field_72995_K && this.uniqueID == -1 && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            this.setNewUniqueID(this.func_145782_y());
        }
        this.shouldChunkLoad = this.func_70083_f(7);
        if (this.shouldChunkLoad && this.chunkTicket == null) {
            this.requestTicket();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this instanceof EntityRollingStock)) {
            this.manageChunkLoading();
        }
    }

    public void func_70106_y() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    public int setNewUniqueID(int numberOfTrains) {
        if (numberOfTrains <= 0) {
            numberOfTrains = uniqueIDs++;
        } else {
            uniqueIDs = numberOfTrains++;
        }
        this.uniqueID = numberOfTrains;
        this.getEntityData().func_74768_a("uniqueID", numberOfTrains);
        return numberOfTrains;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && ConfigHandler.CHUNK_LOADING && this instanceof Locomotive) {
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemChunkLoaderActivator) {
                this.playerEntity = entityplayer;
                if (this.func_70083_f(7)) {
                    this.func_70052_a(7, false);
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Stop loading chunks"));
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                    this.chunkTicket = null;
                } else if (!this.func_70083_f(7)) {
                    this.func_70052_a(7, true);
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentText("Start loading chunks"));
                }
                itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                return true;
            }
            if (this.lockThisCart(itemstack, entityplayer)) {
                return true;
            }
        }
        return false;
    }

    public void setColor(int color) {
        if (color == -1 && EnumTrains.getCurrentTrain(this.getCartItem().func_77973_b()).getColors() != null) {
            color = EnumTrains.getCurrentTrain(this.getCartItem().func_77973_b()).getColors()[0];
        }
        this.field_70180_af.func_75692_b(12, (Object)color);
    }

    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public void setRenderPitch(float pitch) {
        this.renderPitch = pitch;
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(12);
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("color", this.getColor());
        nbttagcompound.func_74757_a("chunkLoadingState", this.func_70083_f(7));
        nbttagcompound.func_74780_a("trainDistanceTraveled", this.trainDistanceTraveled);
        nbttagcompound.func_74778_a("theOwner", this.trainOwner);
        nbttagcompound.func_74757_a("locked", this.locked);
        nbttagcompound.func_74778_a("theCreator", this.trainCreator);
        nbttagcompound.func_74778_a("theName", this.trainName);
        nbttagcompound.func_74778_a("theType", this.trainType);
        nbttagcompound.func_74768_a("uniqueID", this.uniqueID);
        nbttagcompound.func_74768_a("numberOfTrains", numberOfTrains);
        nbttagcompound.func_74757_a("isAttached", this.isAttached);
        nbttagcompound.func_74757_a("linked", this.linked);
        nbttagcompound.func_74780_a("Link1", this.Link1);
        nbttagcompound.func_74780_a("Link2", this.Link2);
        nbttagcompound.func_74768_a("Dim", this.field_71093_bK);
        nbttagcompound.func_74772_a("UUIDM", this.func_110124_au().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDL", this.func_110124_au().getLeastSignificantBits());
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setColor(nbttagcompound.func_74762_e("color"));
        this.func_70052_a(7, nbttagcompound.func_74767_n("chunkLoadingState"));
        this.trainDistanceTraveled = nbttagcompound.func_74769_h("trainDistanceTraveled");
        this.trainOwner = nbttagcompound.func_74779_i("theOwner");
        this.locked = nbttagcompound.func_74767_n("locked");
        this.func_70052_a(8, this.locked);
        this.trainCreator = nbttagcompound.func_74779_i("theCreator");
        this.trainName = nbttagcompound.func_74779_i("theName");
        this.trainType = nbttagcompound.func_74779_i("theType");
        this.uniqueID = nbttagcompound.func_74762_e("uniqueID");
        this.setInformation(this.trainType, this.trainOwner, this.trainCreator, this.trainName, this.uniqueID);
        numberOfTrains = nbttagcompound.func_74762_e("numberOfTrains");
        this.isAttached = nbttagcompound.func_74767_n("isAttached");
        this.linked = nbttagcompound.func_74767_n("linked");
        this.Link1 = nbttagcompound.func_74769_h("Link1");
        this.Link2 = nbttagcompound.func_74769_h("Link2");
        if (nbttagcompound.func_74764_b("Dim")) {
            this.field_71093_bK = nbttagcompound.func_74762_e("Dim");
        }
        if (nbttagcompound.func_74764_b("UUIDM")) {
            this.field_96093_i = new UUID(nbttagcompound.func_74763_f("UUIDM"), nbttagcompound.func_74763_f("UUIDL"));
        }
    }

    public boolean func_98035_c(NBTTagCompound tag) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound p_70039_1_) {
        if (!this.field_70128_L && this.func_70022_Q() != null) {
            p_70039_1_.func_74778_a("id", this.func_70022_Q());
            this.func_70109_d(p_70039_1_);
            return true;
        }
        return false;
    }

    public void setInformation(String trainType, String trainOwner, String trainCreator, String trainName, int uniqueID) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(6, (Object)trainType);
            this.field_70180_af.func_75692_b(7, (Object)trainOwner);
            this.field_70180_af.func_75692_b(9, (Object)trainName);
            this.field_70180_af.func_75692_b(11, (Object)uniqueID);
            if (trainCreator != null && trainCreator.length() > 0) {
                this.field_70180_af.func_75692_b(13, (Object)trainCreator);
            }
        }
    }

    public static String getColorAsString(int i) {
        switch (i) {
            case 0: {
                return "Black";
            }
            case 1: {
                return "Red";
            }
            case 2: {
                return "Green";
            }
            case 3: {
                return "Brown";
            }
            case 4: {
                return "Blue";
            }
            case 5: {
                return "Purple";
            }
            case 6: {
                return "Cyan";
            }
            case 7: {
                return "LightGrey";
            }
            case 8: {
                return "Grey";
            }
            case 13: {
                return "Magenta";
            }
            case 10: {
                return "Lime";
            }
            case 11: {
                return "Yellow";
            }
            case 12: {
                return "LightBlue";
            }
            case 9: {
                return "Pink";
            }
            case 14: {
                return "Orange";
            }
            case 15: {
                return "White";
            }
            case 100: {
                return "Empty";
            }
            case 101: {
                return "Full";
            }
        }
        return "" + i;
    }

    public String getColorAsString() {
        switch (this.getColor()) {
            case 0: {
                return "Black";
            }
            case 1: {
                return "Red";
            }
            case 2: {
                return "Green";
            }
            case 3: {
                return "Brown";
            }
            case 4: {
                return "Blue";
            }
            case 5: {
                return "Purple";
            }
            case 6: {
                return "Cyan";
            }
            case 7: {
                return "LightGrey";
            }
            case 8: {
                return "Grey";
            }
            case 13: {
                return "Magenta";
            }
            case 10: {
                return "Lime";
            }
            case 11: {
                return "Yellow";
            }
            case 12: {
                return "LightBlue";
            }
            case 9: {
                return "Pink";
            }
            case 14: {
                return "Orange";
            }
            case 15: {
                return "White";
            }
            case 100: {
                return "Empty";
            }
            case 101: {
                return "Full";
            }
        }
        return "" + this.getColor();
    }

    public void dropCartAsItem(boolean isCreative) {
        if (!isCreative && !this.itemdropped) {
            this.itemdropped = true;
            for (ItemStack item : this.getItemsDropped()) {
                this.setUniqueIDToItem(item);
                this.func_70099_a(item, 0.0f);
            }
        }
    }

    protected void setUniqueIDToItem(ItemStack stack) {
        NBTTagCompound var3 = stack.func_77978_p();
        if (var3 == null) {
            var3 = new NBTTagCompound();
            stack.func_77982_d(var3);
        }
        if (this.uniqueID != -1) {
            stack.func_77978_p().func_74768_a("uniqueID", this.uniqueID);
        }
        if (this.trainCreator != null && this.trainCreator.length() > 0) {
            stack.func_77978_p().func_74778_a("trainCreator", this.trainCreator);
        }
        if (this.getColor() != -1) {
            stack.func_77978_p().func_74768_a("trainColor", this.getColor());
        }
    }

    protected void setDefaultMass(double def) {
        this.mass = def;
        this.defaultMass = def;
    }

    protected double getDefaultMass() {
        return this.defaultMass;
    }

    public boolean getTrainLockedFromPacket() {
        return this.locked;
    }

    public void setTrainLockedFromPacket(boolean set) {
        this.locked = set;
    }

    protected boolean lockThisCart(ItemStack itemstack, EntityPlayer entityplayer) {
        if (itemstack != null && (itemstack.func_77973_b() instanceof ItemWrench || itemstack.func_77973_b() instanceof ItemAdminBook)) {
            if (entityplayer.getDisplayName().equals(this.trainOwner) || entityplayer.func_146103_bH().getName().equals(this.trainOwner) || this.trainOwner.equals("") || entityplayer.func_70003_b(2, "")) {
                if (this.locked) {
                    this.locked = false;
                    if (this.field_70170_p.field_72995_K) {
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText("unlocked"));
                    }
                } else {
                    this.locked = true;
                    if (this.field_70170_p.field_72995_K) {
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentText("locked"));
                    }
                }
            } else if (this.field_70170_p.field_72995_K) {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentText("You are not the owner!"));
            }
            return true;
        }
        return false;
    }

    protected boolean canBeRiddenWhileLocked(AbstractTrains train) {
        return train instanceof Locomotive || train instanceof IPassenger || train instanceof AbstractWorkCart;
    }

    protected boolean canBeDestroyedByPlayer(DamageSource damagesource) {
        if (this.getTrainLockedFromPacket()) {
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                if (damagesource.func_76346_g() instanceof EntityPlayerMP && ((EntityPlayerMP)damagesource.func_76346_g()).func_70003_b(2, "") && ((EntityPlayer)damagesource.func_76346_g()).field_71071_by.func_70448_g() != null && ((EntityPlayer)damagesource.func_76346_g()).field_71071_by.func_70448_g().func_77973_b() instanceof ItemWrench) {
                    ((EntityPlayer)damagesource.func_76346_g()).func_145747_a((IChatComponent)new ChatComponentText("Removing the train using OP permission"));
                    return false;
                }
                if (!((EntityPlayer)damagesource.func_76346_g()).getDisplayName().toLowerCase().equals(this.trainOwner.toLowerCase())) {
                    ((EntityPlayer)damagesource.func_76346_g()).func_145747_a((IChatComponent)new ChatComponentText("You are not the owner!"));
                    return true;
                }
            } else if (!damagesource.func_76352_a()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        if (stack == null || cart == null) {
            return false;
        }
        ItemStack cartItem = cart.getCartItem();
        return cartItem != null && stack.func_77969_a(cartItem);
    }

    @Override
    public String getDestination() {
        if (this.destination == null) {
            return "";
        }
        return this.destination;
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        return false;
    }

    public static String getTicketDestination(ItemStack ticket) {
        if (ticket == null) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("dest");
    }

    public String func_70005_c_() {
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return StatCollector.func_74838_a((String)("entity." + s + ".name"));
    }

    public void setTicket(ForgeChunkManager.Ticket ticket) {
        this.chunkTicket = ticket;
    }

    public ForgeChunkManager.Ticket getTicket() {
        return this.chunkTicket;
    }

    public void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket = ForgeChunkManager.requestTicket((Object)Traincraft.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (chunkTicket != null) {
            chunkTicket.setChunkListDepth(25);
            chunkTicket.bindEntity((Entity)this);
            this.setTicket(chunkTicket);
        }
    }

    static {
        uniqueIDs = 1;
    }
}

