/*
 * Decompiled with CFR 0.152.
 */
package train.common.adminbook;

import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import train.common.Traincraft;
import train.common.api.EntityRollingStock;
import train.common.api.LiquidTank;

public class ServerLogger {
    public static void writeWagonToFolder(EntityRollingStock wagon) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(Traincraft.configDirectory.getAbsolutePath());
            sb.append("/traincraft/");
            if (!new File(sb.toString()).exists()) {
                new File(sb.toString()).mkdir();
            }
            if (wagon.getOwner() != null && wagon.getOwner().getName() != null && !wagon.getOwner().getName().equals("")) {
                sb.append(wagon.getOwner().getName().toLowerCase());
            } else if (wagon.getTrainOwner() != null && !wagon.getTrainOwner().equals("")) {
                sb.append(wagon.getTrainOwner().toLowerCase());
            } else {
                sb.append("unknown_player");
            }
            sb.append("/");
            if (!new File(sb.toString()).exists()) {
                new File(sb.toString()).mkdir();
            }
            sb.append(wagon.getCartItem().func_77973_b().delegate.name().replace(":", "~").toLowerCase());
            sb.append("_");
            sb.append(wagon.func_110124_au().toString().toLowerCase());
            sb.append(".txt");
            FileOutputStream fileoutputstream = new FileOutputStream(new File(sb.toString()));
            sb = new StringBuilder();
            sb.append("<xmlRoot>\n   <uuid>");
            sb.append(wagon.func_110124_au());
            sb.append("</uuid>\n   <delegate>");
            sb.append(wagon.getCartItem().func_77973_b().delegate.name());
            sb.append("</delegate>\n   <pos_x>");
            sb.append(wagon.field_70165_t);
            sb.append("</pos_x>\n   <pos_y>");
            sb.append(wagon.field_70163_u);
            sb.append("</pos_y>\n   <pos_z>");
            sb.append(wagon.field_70161_v);
            sb.append("</pos_z>\n    <inventory>\n");
            if (wagon instanceof IInventory) {
                if (wagon.getInventory() != null) {
                    for (ItemStack itemStack : wagon.getInventory()) {
                        ServerLogger.addItemXML(sb, itemStack);
                    }
                }
                if (wagon instanceof LiquidTank) {
                    for (ItemStack itemStack : ((LiquidTank)wagon).getTankInfo(ForgeDirection.UNKNOWN)) {
                        ServerLogger.addFluidXML(sb, itemStack.fluid);
                    }
                }
                sb.append("   </inventory>");
            }
            sb.append("\n</xmlRoot>");
            fileoutputstream.write(sb.toString().getBytes());
            fileoutputstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteWagon(EntityRollingStock wagon) {
        StringBuilder sb = new StringBuilder();
        sb.append(Traincraft.configDirectory.getAbsolutePath());
        sb.append("/traincraft/");
        if (wagon.getOwner() != null && wagon.getOwner().getName() != null && !wagon.getOwner().getName().equals("")) {
            sb.append(wagon.getOwner().getName().toLowerCase());
        } else if (wagon.getTrainOwner() != null && !wagon.getTrainOwner().equals("")) {
            sb.append(wagon.getTrainOwner().toLowerCase());
        } else {
            sb.append("unknown_player");
        }
        sb.append("/");
        sb.append(wagon.getCartItem().func_77973_b().delegate.name().replace(":", "~").toLowerCase());
        sb.append("_");
        sb.append(wagon.func_110124_au().toString().toLowerCase());
        sb.append(".txt");
        try {
            File f = new File(sb.toString());
            if (f.exists() && !f.isDirectory()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addItemXML(StringBuilder string, ItemStack item) {
        if (item == null || item.func_77973_b() == null || item.field_77994_a <= 0) {
            return;
        }
        string.append("        <ItemStack>\n            <ID>");
        string.append(Item.func_150891_b((Item)item.func_77973_b()));
        string.append("</ID>\n            <delegate>");
        string.append(item.func_77973_b().delegate.name());
        string.append("</delegate>\n            <meta>");
        string.append(item.func_77960_j());
        string.append("</meta>\n            <StackSize>");
        string.append(item.field_77994_a);
        string.append("</StackSize>\n        </ItemStack>\n");
    }

    private static void addFluidXML(StringBuilder string, FluidStack item) {
        if (item == null || item.getFluid() == null || item.amount <= 0) {
            return;
        }
        for (int fill = 1000; fill < item.amount; fill += 1000) {
            ServerLogger.addItemXML(string, FluidContainerRegistry.fillFluidContainer((FluidStack)item, (ItemStack)new ItemStack(Items.field_151133_ar)));
        }
    }

    public static List<ItemStack> getItems(String doc) {
        try {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            itemStacks.add(new ItemStack((Item)GameData.getItemRegistry().func_82594_a(doc.substring(doc.indexOf("<delegate>") + 10, doc.indexOf("</delegate>")))));
            ArrayList<String> stacks = new ArrayList<String>();
            while (doc.contains("<ItemStack>")) {
                stacks.add(doc.substring(doc.indexOf("<ItemStack>") + 11, doc.indexOf("</ItemStack>")));
                doc = doc.substring(doc.indexOf("</ItemStack>") + 12);
            }
            for (String s : stacks) {
                ItemStack stack = ServerLogger.parseItemFromXML(s);
                if (stack == null) continue;
                itemStacks.add(stack);
            }
            return itemStacks;
        }
        catch (Exception e) {
            return new ArrayList<ItemStack>();
        }
    }

    public static ItemStack parseItemFromXML(String doc) {
        try {
            ItemStack stack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(doc.substring(doc.indexOf("<delegate>") + 10, doc.indexOf("</delegate>"))), Integer.parseInt(doc.substring(doc.indexOf("<StackSize>") + 11, doc.indexOf("</StackSize>"))));
            stack.func_77964_b(Integer.parseInt(doc.substring(doc.indexOf("<meta>") + 6, doc.indexOf("</meta>"))));
            return stack;
        }
        catch (Exception e) {
            return null;
        }
    }
}

