/*
 * Decompiled with CFR 0.152.
 */
package train.common.adminbook;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import train.common.Traincraft;
import train.common.adminbook.ServerLogger;

public class ItemAdminBook
extends Item {
    public ItemAdminBook() {
        this.func_77637_a(Traincraft.tcTab);
        this.func_77655_b("adminbook");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack thisStack, EntityPlayer player, List stringList, boolean p_77624_4_) {
        stringList.add("This book is for Operators ONLY, and allows the following:");
        stringList.add("- drop trains/rollingstock and their inventory lost during a crash");
        stringList.add("- Lock or unlock trains/rollingstock");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        try {
            if (world.field_72995_K) {
                return stack;
            }
            if (!player.func_70003_b(2, "")) {
                return stack;
            }
            if (new File(Traincraft.configDirectory.getAbsolutePath() + "/traincraft/").exists()) {
                StringBuilder sb = new StringBuilder();
                File[] list = new File(Traincraft.configDirectory.getAbsolutePath() + "/traincraft/").listFiles();
                if (list != null) {
                    Arrays.sort(list, new compareFile());
                    for (File f : list) {
                        if (!f.isDirectory() || f.list() == null || f.list().length <= 0) continue;
                        sb.append(f.getName());
                        sb.append(",");
                    }
                    Traincraft.keyChannel.sendTo((IMessage)new PacketAdminBook(1, -1, sb.toString()), (EntityPlayerMP)player);
                }
                return stack;
            }
            return stack;
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.func_77659_a(stack, world, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("tc".toLowerCase() + ":parts/item_book_blue");
    }

    public static class PacketAdminBook
    implements IMessage {
        private int key;
        private int ID;
        private String datacsv;

        public PacketAdminBook() {
        }

        public PacketAdminBook(int key, int ID, String data) {
            this.key = key;
            this.ID = ID;
            this.datacsv = data;
        }

        public void fromBytes(ByteBuf bbuf) {
            try {
                String data = new String(bbuf.array(), "UTF-8");
                if (!data.equals("")) {
                    this.key = Integer.parseInt(data.substring(data.indexOf(":") + 1, data.indexOf(",")));
                    data = data.substring(data.indexOf(",") + 1, data.length());
                    this.ID = Integer.parseInt(data.substring(0, data.indexOf(",")));
                    this.datacsv = data.substring(data.indexOf(",") + 1, data.length());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public void toBytes(ByteBuf bbuf) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(":");
                sb.append(this.key);
                sb.append(",");
                sb.append(this.ID);
                sb.append(",");
                sb.append(this.datacsv);
                bbuf.writeBytes(sb.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public static class Handler
        implements IMessageHandler<PacketAdminBook, IMessage> {
            public IMessage onMessage(PacketAdminBook message, MessageContext context) {
                Traincraft.proxy.openadmingui(message.datacsv);
                return null;
            }
        }
    }

    public static class PacketAdminBookClient
    implements IMessage {
        private String id;
        private int player;

        public PacketAdminBookClient() {
        }

        public PacketAdminBookClient(String data, int playerID) {
            this.id = data;
            this.player = playerID;
        }

        public void fromBytes(ByteBuf bbuf) {
            try {
                String data = new String(bbuf.array(), "UTF-8");
                if (!data.equals("")) {
                    this.player = Integer.parseInt(data.substring(data.indexOf(":") + 1, data.indexOf(",")));
                    this.id = data.substring(data.indexOf(",") + 1, data.length());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public void toBytes(ByteBuf bbuf) {
            try {
                bbuf.writeBytes((":" + this.player + "," + this.id).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public static class Handler
        implements IMessageHandler<PacketAdminBookClient, IMessage> {
            public IMessage onMessage(PacketAdminBookClient message, MessageContext context) {
                File f;
                int event = 0;
                if (message.id.length() > 2 && message.id.substring(0, 2).equals("0:")) {
                    message.id = message.id.substring(2, message.id.length());
                    event = 1;
                }
                if (message.id.length() > 2 && message.id.substring(0, 2).equals("1:")) {
                    message.id = message.id.substring(2, message.id.length());
                    event = 2;
                }
                if ((f = new File(Traincraft.configDirectory.getAbsolutePath() + "/traincraft/" + message.id)).exists()) {
                    StringBuilder sb = new StringBuilder();
                    if (!f.isDirectory()) {
                        try {
                            if (event == 0) {
                                sb.append("<");
                                sb.append(message.id);
                                sb.append(",");
                                sb.append(message.id.substring(0, message.id.indexOf("/") + 1));
                                sb.append(",");
                                String document = new String(Files.readAllBytes(Paths.get(Traincraft.configDirectory.getAbsolutePath() + "/traincraft/" + message.id, new String[0])), "UTF-8");
                                sb.append("Delegate:,");
                                sb.append(document.substring(document.indexOf("<delegate>") + 10, document.indexOf("</delegate>")));
                                sb.append(",UUID:,");
                                sb.append(document.substring(document.indexOf("<uuid>") + 6, document.indexOf("</uuid>")).substring(0, 19));
                                sb.append(",");
                                sb.append(document.substring(document.indexOf("<uuid>") + 6, document.indexOf("</uuid>")).substring(19));
                                sb.append(",Last Known Position:,X:");
                                sb.append(document.substring(document.indexOf("<pos_x>") + 7, document.indexOf("</pos_x>")));
                                sb.append("- Y:");
                                sb.append(document.substring(document.indexOf("<pos_y>") + 7, document.indexOf("</pos_y>")));
                                sb.append("- Z:");
                                sb.append(document.substring(document.indexOf("<pos_z>") + 7, document.indexOf("</pos_z>")));
                                if (document.contains("<fuel>")) {
                                    sb.append(",Fuel amount: ");
                                    sb.append(document.substring(document.indexOf("<fuel>") + 6, document.indexOf("</fuel>")));
                                }
                                if (document.contains("<inventory>")) {
                                    sb.append(",");
                                    sb.append(document.substring(document.indexOf("<inventory>"), document.indexOf("</inventory>") + 12));
                                }
                            } else if (event == 1) {
                                for (WorldServer world : DimensionManager.getWorlds()) {
                                    if (world.func_73045_a(message.player) == null) continue;
                                    EntityPlayerMP p = (EntityPlayerMP)world.func_73045_a(message.player);
                                    List<ItemStack> items = ServerLogger.getItems(new String(Files.readAllBytes(Paths.get(Traincraft.configDirectory.getAbsolutePath() + "/traincraft/" + message.id, new String[0])), "UTF-8"));
                                    for (ItemStack i : items) {
                                        if (i.field_77994_a == 0 || i.func_77973_b() == null) continue;
                                        EntityItem entityitem = new EntityItem((World)world, p.field_70165_t, p.field_70163_u + 3.0, p.field_70161_v, i);
                                        entityitem.field_145804_b = 120;
                                        if (p.captureDrops) {
                                            p.capturedDrops.add(entityitem);
                                            continue;
                                        }
                                        world.func_72838_d((Entity)entityitem);
                                    }
                                }
                            } else if (event == 2 && f.exists()) {
                                f.delete();
                            }
                        }
                        catch (Exception document) {}
                    } else {
                        File[] folder;
                        if (!message.id.equals("")) {
                            sb.append(",");
                        }
                        if ((folder = f.listFiles()) != null) {
                            File[] fileArray = folder;
                            int n = fileArray.length;
                            for (int world = 0; world < n; ++world) {
                                File file = fileArray[world];
                                if (file == null) continue;
                                sb.append(message.id);
                                if (!message.id.equals("")) {
                                    sb.append("/");
                                }
                                sb.append(file.getName());
                                sb.append(",");
                            }
                        }
                    }
                    if (sb.toString().length() < 5) {
                        return null;
                    }
                    for (WorldServer world : DimensionManager.getWorlds()) {
                        if (world.func_73045_a(message.player) == null) continue;
                        Traincraft.keyChannel.sendTo((IMessage)new PacketAdminBook(1, -1, sb.toString()), (EntityPlayerMP)world.func_73045_a(message.player));
                        return null;
                    }
                }
                return null;
            }
        }
    }

    class compareFile
    implements Comparator<File> {
        compareFile() {
        }

        @Override
        public int compare(File d, File d1) {
            return d.getName().toLowerCase().compareTo(d1.getName().toLowerCase());
        }
    }
}

