/*
 * Decompiled with CFR 0.152.
 */
package train.client.core.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class CapesHelper
extends Thread {
    private String username;
    public boolean MCCape = true;
    private boolean isStatic = false;
    private boolean isAnimated = false;
    private String staticUrl;
    private ArrayList<String> animatedFrameUrls;
    private ResourceLocation staticRL;
    private ResourceLocation[] animatedFramesRL;
    private ThreadDownloadImageData staticImage;
    private ThreadDownloadImageData[] animatedFramesImages;
    private int currFrame;
    private long lastFrameTime;
    private int animInterval = 500;
    public static HashMap<String, CapesHelper> users = new HashMap();
    public static boolean isLoaded = false;

    public CapesHelper(String username) {
        this.username = username;
    }

    @Override
    public void run() {
        try {
            String line;
            URL url = new URL("https://dl.dropbox.com/u/25602663/Traincraft/Capes/" + this.username.toLowerCase() + "_cape.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            int sub = 3;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("SU")) {
                    this.isStatic = true;
                    this.staticUrl = line.substring(sub);
                    continue;
                }
                if (line.startsWith("AU")) {
                    this.isAnimated = true;
                    if (this.animatedFrameUrls == null) {
                        this.animatedFrameUrls = new ArrayList();
                    }
                    this.animatedFrameUrls.add(line.substring(sub));
                    continue;
                }
                if (!line.startsWith("AI")) continue;
                this.animInterval = Integer.parseInt(line.substring(sub));
            }
            reader.close();
            this.dlImages();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dlImages() {
        if (this.isAnimated) {
            this.animatedFramesRL = new ResourceLocation[this.animatedFrameUrls.size()];
            this.animatedFramesImages = new ThreadDownloadImageData[this.animatedFrameUrls.size()];
            for (int i = 0; i < this.animatedFrameUrls.size(); ++i) {
                this.animatedFramesRL[i] = CapesHelper.capeAnimatedRL(this.username, i + 1);
                this.animatedFramesImages[i] = CapesHelper.dlImage(this.animatedFramesRL[i], this.animatedFrameUrls.get(i));
            }
        } else if (this.isStatic) {
            this.staticRL = CapesHelper.capeStaticRL(this.username);
            this.staticImage = CapesHelper.dlImage(this.staticRL, this.staticUrl);
        } else {
            this.MCCape = false;
        }
        isLoaded = true;
    }

    public ResourceLocation getCurrentRL() {
        if (this.isAnimated) {
            long time = Minecraft.func_71386_F();
            if (time > this.lastFrameTime + (long)this.animInterval) {
                this.lastFrameTime = time;
                ++this.currFrame;
                if (this.currFrame >= this.animatedFramesImages.length) {
                    this.currFrame = 0;
                }
            }
            return this.animatedFramesRL[this.currFrame];
        }
        return this.staticRL;
    }

    private static ResourceLocation capeStaticRL(String username) {
        return new ResourceLocation("cloaks/" + StringUtils.func_76338_a((String)username));
    }

    private static ResourceLocation capeAnimatedRL(String username, int frameNumber) {
        return new ResourceLocation("cloaks/" + StringUtils.func_76338_a((String)username) + "/" + frameNumber);
    }

    private static ThreadDownloadImageData dlImage(ResourceLocation rl, String url) {
        TextureManager textures = Minecraft.func_71410_x().field_71446_o;
        File file = new File(rl.func_110623_a());
        ThreadDownloadImageData data = new ThreadDownloadImageData(file, url, rl, null);
        textures.func_110579_a(rl, (ITextureObject)data);
        return data;
    }
}

