/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tmt.PositionTransformVertex;
import tmt.TextureGroup;
import tmt.TexturedPolygon;

public abstract class ModelPoolEntry {
    public String name;
    public PositionTransformVertex[] vertices;
    public TexturedPolygon[] faces;
    public Map<String, TextureGroup> textures;
    protected TextureGroup texture;
    protected String[] fileExtensions;

    public File checkValidPath(String path) {
        File file = null;
        for (int index = 0; !(index >= this.fileExtensions.length || file != null && file.exists()); ++index) {
            String absPath = path;
            if (!path.endsWith("." + this.fileExtensions[index])) {
                absPath = absPath + "." + this.fileExtensions[index];
            }
            file = new File(absPath);
        }
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    public abstract void getModel(File var1);

    protected void setTextureGroup(String groupName) {
        if (this.textures.size() == 0 || !this.textures.containsKey(groupName)) {
            this.textures.put(groupName, new TextureGroup());
        }
        this.texture = this.textures.get(groupName);
    }

    protected void applyGroups(Map<String, TextureGroup> texturesMap) {
        Set<String> texturesCol = this.textures.keySet();
        Iterator texturesItr = texturesCol.iterator();
        while (texturesItr.hasNext()) {
            int nameIdx = 0;
            String groupKey = (String)texturesItr.next();
            String currentGroup = this.name + "_" + nameIdx + ":" + groupKey;
            while (texturesMap.containsKey(currentGroup)) {
                currentGroup = this.name + "_" + ++nameIdx + ":" + groupKey;
            }
            texturesMap.put(currentGroup, this.textures.get(groupKey));
        }
    }
}

