/*
 * Decompiled with CFR 0.152.
 */
package tmt;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.client.model.ModelBase;
import tmt.ModelRendererTurbo;

public class JsonToTMT {
    public static final float def = 0.0f;
    public static final int idef = 0;
    public static final String[] format = new String[]{"format", "form", "f"};
    public static final String[] width = new String[]{"width", "wid", "w"};
    public static final String[] height = new String[]{"height", "hgt", "h"};
    public static final String[] depth = new String[]{"depth", "dep", "d"};
    public static final String[] offx = new String[]{"offset_x", "off_x", "offx", "ox"};
    public static final String[] offy = new String[]{"offset_y", "off_y", "offy", "oy"};
    public static final String[] offz = new String[]{"offset_z", "off_z", "offz", "oz"};
    public static final String[] expansion = new String[]{"expansion", "exp", "e"};
    public static final String[] scale = new String[]{"scale", "s"};
    public static final String[] texturex = new String[]{"texture_x", "texturex", "tex_x", "tx"};
    public static final String[] texturey = new String[]{"texture_y", "texturey", "tex_y", "ty"};
    public static final String[] posx = new String[]{"rotation_point_x", "pos_x", "posx", "px", "x"};
    public static final String[] posy = new String[]{"rotation_point_y", "pos_y", "posy", "py", "y"};
    public static final String[] posz = new String[]{"rotation_point_z", "pos_z", "posz", "pz", "z"};
    public static final String[] rotx = new String[]{"rotation_angle_x", "rotangle_x", "rotanglex", "rot_x", "rx"};
    public static final String[] roty = new String[]{"rotation_angle_y", "rotangle_y", "rotangley", "rot_y", "ry"};
    public static final String[] rotz = new String[]{"rotation_angle_z", "rotangle_z", "rotanglez", "rot_z", "rz"};
    public static final String[] oldrot = new String[]{"old_ration", "old_rotation_order", "oro"};
    public static final String[] mirror = new String[]{"mirror", "mir", "m"};
    public static final String[] flip = new String[]{"flip", "fl", "usd"};
    public static final String[] radius = new String[]{"radius", "rad", "r"};
    public static final String[] length = new String[]{"length", "len", "l"};
    public static final String[] segments = new String[]{"segments", "seg", "sg"};
    public static final String[] basescale = new String[]{"base_scale", "basescale", "bs"};
    public static final String[] topscale = new String[]{"top_scale", "topscale", "ts"};
    public static final String[] direction = new String[]{"direction", "dir", "facing"};

    public static final ModelRendererTurbo parse(ModelBase base, JsonObject obj, int tx, int ty) {
        ModelRendererTurbo model = new ModelRendererTurbo(base, JsonToTMT.get(texturex, obj, 0), JsonToTMT.get(texturey, obj, 0), tx, ty);
        float x = JsonToTMT.get(offx, obj, 0.0f);
        float y = JsonToTMT.get(offy, obj, 0.0f);
        float z = JsonToTMT.get(offz, obj, 0.0f);
        int w = JsonToTMT.get(width, obj, 0);
        int h = JsonToTMT.get(height, obj, 0);
        int d = JsonToTMT.get(depth, obj, 0);
        String s = obj.get("type").getAsString();
        if (s.equals("box") || s.equals("cube") || s.equals("s")) {
            model.func_78790_a(x, y, z, w, h, d, JsonToTMT.get(expansion, obj, 0.0f));
        } else if (s.equals("shapebox") || s.equals("sbox") || s.equals("sb")) {
            model.addShapeBox(x, y, z, w, h, d, JsonToTMT.get(scale, obj, 0.0f), JsonToTMT.get("x0", obj, 0.0f), JsonToTMT.get("y0", obj, 0.0f), JsonToTMT.get("z0", obj, 0.0f), JsonToTMT.get("x1", obj, 0.0f), JsonToTMT.get("y1", obj, 0.0f), JsonToTMT.get("z1", obj, 0.0f), JsonToTMT.get("x2", obj, 0.0f), JsonToTMT.get("y2", obj, 0.0f), JsonToTMT.get("z2", obj, 0.0f), JsonToTMT.get("x3", obj, 0.0f), JsonToTMT.get("y3", obj, 0.0f), JsonToTMT.get("z3", obj, 0.0f), JsonToTMT.get("x4", obj, 0.0f), JsonToTMT.get("y4", obj, 0.0f), JsonToTMT.get("z4", obj, 0.0f), JsonToTMT.get("x5", obj, 0.0f), JsonToTMT.get("y5", obj, 0.0f), JsonToTMT.get("z5", obj, 0.0f), JsonToTMT.get("x6", obj, 0.0f), JsonToTMT.get("y6", obj, 0.0f), JsonToTMT.get("z6", obj, 0.0f), JsonToTMT.get("x7", obj, 0.0f), JsonToTMT.get("y7", obj, 0.0f), JsonToTMT.get("z7", obj, 0.0f));
        } else if (s.equals("cylinder") || s.equals("c")) {
            model.addCylinder(x, y, z, JsonToTMT.get(radius, obj, 1.0f), JsonToTMT.get(length, obj, 1.0f), JsonToTMT.get(segments, obj, 16), JsonToTMT.get(basescale, obj, 1.0f), JsonToTMT.get(topscale, obj, 1.0f), JsonToTMT.get(direction, obj, 4));
        } else if (s.equals("cone") || s.equals("cn")) {
            model.addCone(x, y, z, JsonToTMT.get(radius, obj, 1.0f), JsonToTMT.get(length, obj, 1.0f), JsonToTMT.get(segments, obj, 12), JsonToTMT.get(basescale, obj, 1.0f), JsonToTMT.get(direction, obj, 4));
        }
        model.field_78795_f = JsonToTMT.get(rotx, obj, 0.0f);
        model.field_78796_g = JsonToTMT.get(roty, obj, 0.0f);
        model.field_78808_h = JsonToTMT.get(rotz, obj, 0.0f);
        model.func_78793_a(JsonToTMT.get(posx, obj, 0.0f), JsonToTMT.get(posy, obj, 0.0f), JsonToTMT.get(posz, obj, 0.0f));
        return model;
    }

    public static final ModelRendererTurbo[] parse(ModelBase base, JsonArray array, int tx, int ty) {
        if (array != null) {
            ModelRendererTurbo[] model = new ModelRendererTurbo[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                model[i] = JsonToTMT.parse(base, array.get(i).getAsJsonObject(), tx, ty);
            }
            return model;
        }
        return new ModelRendererTurbo[0];
    }

    public static final ModelRendererTurbo[] parse(ModelBase base, String string, JsonObject object, int tx, int ty) {
        if (base == null) {
            // empty if block
        }
        if (object.has(string) && object.get(string).isJsonArray()) {
            return JsonToTMT.parse(base, object.get(string).getAsJsonArray(), tx, ty);
        }
        return new ModelRendererTurbo[0];
    }

    public static final float get(String s, JsonObject obj, float def) {
        if (obj.has(s)) {
            return obj.get(s).getAsFloat();
        }
        return def;
    }

    public static final float get(String[] s, JsonObject obj, float def) {
        for (String str : s) {
            if (!obj.has(str)) continue;
            return obj.get(str).getAsFloat();
        }
        return 0.0f;
    }

    public static final int get(String[] s, JsonObject obj, int def) {
        for (String str : s) {
            if (!obj.has(str)) continue;
            return obj.get(str).getAsInt();
        }
        return 0;
    }
}

