/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import java.util.List;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class EnergyDisplayHelper {
    public static void getEnergyDisplayTooltip(float energyVal, float maxEnergy, List strList) {
        strList.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"gui.message.energy") + ": " + EnergyDisplayHelper.getEnergyDisplayS(energyVal));
        strList.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"gui.message.maxEnergy") + ": " + EnergyDisplayHelper.getEnergyDisplayS(maxEnergy));
    }

    public static String getEnergyDisplayS(float energyVal) {
        if (EnergyConfigHandler.displayEnergyUnitsIC2) {
            return EnergyDisplayHelper.getEnergyDisplayIC2(energyVal * EnergyConfigHandler.TO_IC2_RATIOdisp);
        }
        if (EnergyConfigHandler.displayEnergyUnitsBC) {
            return EnergyDisplayHelper.getEnergyDisplayBC(energyVal * EnergyConfigHandler.TO_BC_RATIOdisp);
        }
        if (EnergyConfigHandler.displayEnergyUnitsMek) {
            return EnergyDisplayHelper.getEnergyDisplayMek(energyVal * EnergyConfigHandler.TO_MEKANISM_RATIOdisp);
        }
        if (EnergyConfigHandler.displayEnergyUnitsRF) {
            return EnergyDisplayHelper.getEnergyDisplayRF(energyVal * EnergyConfigHandler.TO_RF_RATIOdisp);
        }
        String val = String.valueOf(EnergyDisplayHelper.getEnergyDisplayI(energyVal));
        String newVal = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            newVal = newVal + val.charAt(val.length() - 1 - i);
            if (i % 3 != 0 || i == 0) continue;
            newVal = newVal + ',';
        }
        return newVal + " gJ";
    }

    public static String getEnergyDisplayIC2(float energyVal) {
        String val = String.valueOf(EnergyDisplayHelper.getEnergyDisplayI(energyVal));
        String newVal = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            newVal = newVal + val.charAt(val.length() - 1 - i);
            if (i % 3 != 0 || i == 0) continue;
            newVal = newVal + ',';
        }
        return newVal + " EU";
    }

    public static String getEnergyDisplayBC(float energyVal) {
        String val = String.valueOf(EnergyDisplayHelper.getEnergyDisplayI(energyVal));
        return val + " MJ";
    }

    public static String getEnergyDisplayMek(float energyVal) {
        if (energyVal < 1000.0f) {
            String val = String.valueOf(EnergyDisplayHelper.getEnergyDisplayI(energyVal));
            return val + " J";
        }
        if (energyVal < 1000000.0f) {
            String val = EnergyDisplayHelper.getEnergyDisplay1DP(energyVal / 1000.0f);
            return val + " kJ";
        }
        String val = EnergyDisplayHelper.getEnergyDisplay1DP(energyVal / 1000000.0f);
        return val + " MJ";
    }

    public static String getEnergyDisplayRF(float energyVal) {
        String val = String.valueOf(EnergyDisplayHelper.getEnergyDisplayI(energyVal));
        return val + " RF";
    }

    public static int getEnergyDisplayI(float energyVal) {
        return MathHelper.func_76141_d((float)energyVal);
    }

    public static String getEnergyDisplay1DP(float energyVal) {
        return "" + MathHelper.func_76141_d((float)energyVal) + "." + MathHelper.func_76141_d((float)(energyVal * 10.0f)) % 10 + MathHelper.func_76141_d((float)(energyVal * 100.0f)) % 10;
    }
}

