/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpinThruster;
import micdoodle8.mods.galacticraft.core.dimension.OrbitSpinSaveData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SpinManager {
    private static final float GFORCE = 0.024525002f;
    private OrbitSpinSaveData savefile;
    public boolean doSpinning = true;
    public float angularVelocityRadians = 0.0f;
    public float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);
    private float angularVelocityTarget = 0.0f;
    private float angularVelocityAccel = 0.0f;
    public double spinCentreX;
    public double spinCentreZ;
    private float momentOfInertia;
    private float massCentreX;
    private float massCentreZ;
    public int ssBoundsMaxX;
    public int ssBoundsMinX;
    public int ssBoundsMaxY;
    public int ssBoundsMinY;
    public int ssBoundsMaxZ;
    public int ssBoundsMinZ;
    private LinkedList<BlockVec3> thrustersPlus = new LinkedList();
    private LinkedList<BlockVec3> thrustersMinus = new LinkedList();
    private BlockVec3 oneSSBlock;
    private HashSet<BlockVec3> checked = new HashSet();
    private float artificialG;
    public boolean thrustersFiring = false;
    private boolean dataNotLoaded = true;
    private List<Entity> loadedEntities = new LinkedList<Entity>();
    private double pPrevMotionX = 0.0;
    public double pPrevMotionY = 0.0;
    private double pPrevMotionZ = 0.0;
    private WorldProviderSpaceStation worldProvider;
    private boolean clientSide = true;

    public SpinManager(WorldProviderSpaceStation provider) {
        this.worldProvider = provider;
    }

    public void registerServerSide() {
        if (!this.worldProvider.field_76579_a.field_72995_K) {
            this.clientSide = false;
        }
    }

    public float getSpinRate() {
        return this.skyAngularVelocity;
    }

    public void setSpinRate(float angle) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        if (this.clientSide) {
            this.updateSkyProviderSpinRate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkyProviderSpinRate() {
        this.worldProvider.setSpinDeltaPerTick(this.skyAngularVelocity);
    }

    public void setSpinRate(float angle, boolean firing) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        this.worldProvider.setSpinDeltaPerTick(this.skyAngularVelocity);
        this.thrustersFiring = firing;
    }

    public void setSpinCentre(double x, double z) {
        this.spinCentreX = x;
        this.spinCentreZ = z;
        if (this.clientSide && ConfigManagerCore.enableDebug) {
            GCLog.info("Clientside update to spin centre: " + x + "," + z);
        }
    }

    public void setSpinBox(int mx, int xx, int my, int yy, int mz, int zz) {
        this.ssBoundsMinX = mx;
        this.ssBoundsMaxX = xx;
        this.ssBoundsMinY = my;
        this.ssBoundsMaxY = yy;
        this.ssBoundsMinZ = mz;
        this.ssBoundsMaxZ = zz;
    }

    public void addThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.add(thruster);
            this.thrustersMinus.remove(thruster);
        } else {
            this.thrustersPlus.remove(thruster);
            this.thrustersMinus.add(thruster);
        }
    }

    public void removeThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.remove(thruster);
        } else {
            this.thrustersMinus.remove(thruster);
        }
    }

    public boolean checkSS(BlockVec3 baseBlock, boolean placingThruster) {
        World worldObj = this.worldProvider.field_76579_a;
        if (this.oneSSBlock == null || this.oneSSBlock.getBlockID(worldObj) instanceof BlockAir) {
            this.oneSSBlock = baseBlock != null ? baseBlock.clone() : new BlockVec3(0, 64, 0);
        }
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> foundThrusters = new LinkedList<BlockVec3>();
        this.checked.clear();
        currentLayer.add(this.oneSSBlock.clone());
        this.checked.add(this.oneSSBlock.clone());
        Block bStart = this.oneSSBlock.getBlockID(worldObj);
        if (bStart instanceof BlockSpinThruster) {
            foundThrusters.add(this.oneSSBlock);
        }
        float thismass = 0.1f;
        float thismassCentreX = 0.1f * (float)this.oneSSBlock.x;
        float thismassCentreY = 0.1f * (float)this.oneSSBlock.y;
        float thismassCentreZ = 0.1f * (float)this.oneSSBlock.z;
        float thismoment = 0.0f;
        int thisssBoundsMaxX = this.oneSSBlock.x;
        int thisssBoundsMinX = this.oneSSBlock.x;
        int thisssBoundsMaxY = this.oneSSBlock.y;
        int thisssBoundsMinY = this.oneSSBlock.y;
        int thisssBoundsMaxZ = this.oneSSBlock.z;
        int thisssBoundsMinZ = this.oneSSBlock.z;
        while (currentLayer.size() > 0) {
            for (BlockVec3 vec : currentLayer) {
                int bits = vec.sideDoneBits;
                if (vec.x < thisssBoundsMinX) {
                    thisssBoundsMinX = vec.x;
                }
                if (vec.y < thisssBoundsMinY) {
                    thisssBoundsMinY = vec.y;
                }
                if (vec.z < thisssBoundsMinZ) {
                    thisssBoundsMinZ = vec.z;
                }
                if (vec.x > thisssBoundsMaxX) {
                    thisssBoundsMaxX = vec.x;
                }
                if (vec.y > thisssBoundsMaxY) {
                    thisssBoundsMaxY = vec.y;
                }
                if (vec.z > thisssBoundsMaxZ) {
                    thisssBoundsMaxZ = vec.z;
                }
                for (int side = 0; side < 6; ++side) {
                    BlockVec3 sideVec;
                    if ((bits & 1 << side) == 1 || this.checked.contains(sideVec = vec.newVecSide(side))) continue;
                    this.checked.add(sideVec);
                    Block b = sideVec.getBlockID(worldObj);
                    if (b == null || b.isAir((IBlockAccess)worldObj, sideVec.x, sideVec.y, sideVec.z)) continue;
                    nextLayer.add(sideVec);
                    if (bStart.isAir((IBlockAccess)worldObj, this.oneSSBlock.x, this.oneSSBlock.y, this.oneSSBlock.z)) {
                        this.oneSSBlock = sideVec.clone();
                        bStart = b;
                    }
                    float m = 1.0f;
                    if (!(b instanceof BlockLiquid)) {
                        m = b.func_149712_f(worldObj, sideVec.x, sideVec.y, sideVec.z);
                        if (m < 0.1f) {
                            m = 0.1f;
                        } else if (m > 30.0f) {
                            m = 30.0f;
                        }
                        if (b.func_149688_o() == Material.field_151575_d) {
                            m /= 4.0f;
                        }
                    }
                    thismassCentreX += m * (float)sideVec.x;
                    thismassCentreY += m * (float)sideVec.y;
                    thismassCentreZ += m * (float)sideVec.z;
                    thismass += m;
                    thismoment += m * (float)(sideVec.x * sideVec.x + sideVec.z * sideVec.z);
                    if (!(b instanceof BlockSpinThruster) || RedstoneUtil.isBlockReceivingRedstone(worldObj, sideVec.x, sideVec.y, sideVec.z)) continue;
                    foundThrusters.add(sideVec);
                }
            }
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (placingThruster && !this.checked.contains(baseBlock)) {
            if (foundThrusters.size() > 0) {
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Thruster placed on wrong part of space station: base at " + this.oneSSBlock.x + "," + this.oneSSBlock.y + "," + this.oneSSBlock.z + " - baseBlock was " + baseBlock.x + "," + baseBlock.y + "," + baseBlock.z + " - found " + foundThrusters.size());
                }
                return false;
            }
            if (!this.oneSSBlock.equals(baseBlock)) {
                this.oneSSBlock = baseBlock.clone();
                if (this.oneSSBlock.getBlockID(worldObj).func_149688_o() != Material.field_151579_a) {
                    return this.checkSS(baseBlock, true);
                }
            }
            return false;
        }
        this.thrustersPlus.clear();
        this.thrustersMinus.clear();
        for (BlockVec3 thruster : foundThrusters) {
            int facing = thruster.getBlockMetadata((IBlockAccess)worldObj) & 8;
            if (facing == 0) {
                this.thrustersPlus.add(thruster.clone());
                continue;
            }
            this.thrustersMinus.add(thruster.clone());
        }
        float mass = thismass;
        this.massCentreX = thismassCentreX / thismass + 0.5f;
        float massCentreY = thismassCentreY / thismass + 0.5f;
        this.massCentreZ = thismassCentreZ / thismass + 0.5f;
        this.setSpinCentre(this.massCentreX, this.massCentreZ);
        this.ssBoundsMaxX = thisssBoundsMaxX + 1;
        this.ssBoundsMinX = thisssBoundsMinX;
        this.ssBoundsMaxY = thisssBoundsMaxY + 1;
        this.ssBoundsMinY = thisssBoundsMinY;
        this.ssBoundsMaxZ = thisssBoundsMaxZ + 1;
        this.ssBoundsMinZ = thisssBoundsMinZ;
        thismoment -= this.massCentreX * this.massCentreX * mass;
        this.momentOfInertia = thismoment -= this.massCentreZ * this.massCentreZ * mass;
        GCLog.debug("MoI = " + this.momentOfInertia + " CoMx = " + this.massCentreX + " CoMz = " + this.massCentreZ);
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.worldProvider.field_76574_g);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.worldProvider.field_76574_g);
        this.updateSpinSpeed();
        return true;
    }

    public void updateSpinSpeed() {
        if (this.momentOfInertia > 0.0f) {
            float zz;
            float xx;
            float netTorque = 0.0f;
            int countThrusters = 0;
            int countThrustersReverse = 0;
            for (BlockVec3 thruster : this.thrustersPlus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque += MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrusters;
            }
            for (BlockVec3 thruster : this.thrustersMinus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque -= MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrustersReverse;
            }
            if (countThrusters == countThrustersReverse) {
                this.angularVelocityAccel = 4.0E-6f;
                this.angularVelocityTarget = 0.0f;
            } else {
                if ((countThrusters += countThrustersReverse) > 4) {
                    countThrusters = 4;
                }
                float maxRx = Math.max((float)this.ssBoundsMaxX - this.massCentreX, this.massCentreX - (float)this.ssBoundsMinX);
                float maxRz = Math.max((float)this.ssBoundsMaxZ - this.massCentreZ, this.massCentreZ - (float)this.ssBoundsMinZ);
                float maxR = Math.max(maxRx, maxRz);
                this.angularVelocityTarget = MathHelper.func_76129_c((float)(0.024525002f / maxR)) / 2.0f;
                float spinCap = 0.00125f * (float)countThrusters;
                this.angularVelocityAccel = netTorque / this.momentOfInertia / 20.0f;
                if (this.angularVelocityAccel < 0.0f) {
                    this.angularVelocityAccel = -this.angularVelocityAccel;
                    this.angularVelocityTarget = -this.angularVelocityTarget;
                    if (this.angularVelocityTarget < -spinCap) {
                        this.angularVelocityTarget = -spinCap;
                    }
                } else if (this.angularVelocityTarget > spinCap) {
                    this.angularVelocityTarget = spinCap;
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("MaxR = " + maxR + " Angular vel = " + this.angularVelocityTarget + " Angular accel = " + this.angularVelocityAccel);
                }
            }
        }
        if (!this.clientSide) {
            if (this.savefile == null) {
                this.savefile = OrbitSpinSaveData.initWorldData(this.worldProvider.field_76579_a);
                this.dataNotLoaded = false;
            } else {
                this.writeToNBT(this.savefile.datacompound);
                this.savefile.func_76185_a();
            }
        }
    }

    public void updateSpin() {
        if (!this.clientSide) {
            if (this.dataNotLoaded) {
                this.savefile = OrbitSpinSaveData.initWorldData(this.worldProvider.field_76579_a);
                this.readFromNBT(this.savefile.datacompound);
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Loading data from save: " + this.savefile.datacompound.func_74760_g("omegaSky"));
                }
                this.dataNotLoaded = false;
            }
            if (this.doSpinning) {
                float newAngle;
                boolean updateNeeded = true;
                if (this.angularVelocityTarget < this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians - this.angularVelocityAccel;
                    if (newAngle < this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.angularVelocityTarget > this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians + this.angularVelocityAccel;
                    if (newAngle > this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.thrustersFiring) {
                    this.thrustersFiring = false;
                } else {
                    updateNeeded = false;
                }
                if (updateNeeded) {
                    this.writeToNBT(this.savefile.datacompound);
                    this.savefile.func_76185_a();
                    ArrayList<Object> objList = new ArrayList<Object>();
                    objList.add(Float.valueOf(this.angularVelocityRadians));
                    objList.add(this.thrustersFiring);
                    GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.worldProvider.field_76574_g);
                }
                World worldObj = this.worldProvider.field_76579_a;
                this.loadedEntities.clear();
                this.loadedEntities.addAll(worldObj.field_72996_f);
                for (Entity e : this.loadedEntities) {
                    if (!(e instanceof EntityItem) && (!(e instanceof EntityLivingBase) || e instanceof EntityPlayer) && !(e instanceof EntityTNTPrimed) && !(e instanceof EntityFallingBlock) || e.field_70122_E) continue;
                    boolean freefall = true;
                    if (e.field_70121_D.field_72336_d >= (double)this.ssBoundsMinX && e.field_70121_D.field_72340_a <= (double)this.ssBoundsMaxX && e.field_70121_D.field_72337_e >= (double)this.ssBoundsMinY && e.field_70121_D.field_72338_b <= (double)this.ssBoundsMaxY && e.field_70121_D.field_72334_f >= (double)this.ssBoundsMinZ && e.field_70121_D.field_72339_c <= (double)this.ssBoundsMaxZ) {
                        int xmx = MathHelper.func_76128_c((double)(e.field_70121_D.field_72336_d + 0.2));
                        int ym = MathHelper.func_76128_c((double)(e.field_70121_D.field_72338_b - 0.1));
                        int yy = MathHelper.func_76128_c((double)(e.field_70121_D.field_72337_e + 0.1));
                        int zm = MathHelper.func_76128_c((double)(e.field_70121_D.field_72339_c - 0.2));
                        int zz = MathHelper.func_76128_c((double)(e.field_70121_D.field_72334_f + 0.2));
                        block1: for (int x = MathHelper.func_76128_c((double)(e.field_70121_D.field_72340_a - 0.2)); x <= xmx; ++x) {
                            for (int y = ym; y <= yy; ++y) {
                                for (int z = zm; z <= zz; ++z) {
                                    if (!worldObj.func_72899_e(x, y, z) || Blocks.field_150350_a == worldObj.func_147439_a(x, y, z)) continue;
                                    freefall = false;
                                    break block1;
                                }
                            }
                        }
                    }
                    if (!freefall) continue;
                    if (this.angularVelocityRadians != 0.0f) {
                        double xx = e.field_70165_t - this.spinCentreX;
                        double zz = e.field_70161_v - this.spinCentreZ;
                        double arc = Math.sqrt(xx * xx + zz * zz);
                        float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
                        if (xx < 0.0) {
                            angle += (float)Math.PI;
                        }
                        double offsetX = -(arc *= (double)this.angularVelocityRadians) * (double)MathHelper.func_76126_a((float)(angle += this.angularVelocityRadians / 3.0f));
                        double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
                        e.field_70165_t += offsetX;
                        e.field_70161_v += offsetZ;
                        e.field_70142_S += offsetX;
                        e.field_70136_U += offsetZ;
                        if (!worldObj.func_72899_e(MathHelper.func_76128_c((double)e.field_70165_t), 64, MathHelper.func_76128_c((double)e.field_70161_v))) {
                            e.func_70106_y();
                        }
                        e.field_70121_D.func_72317_d(offsetX, 0.0, offsetZ);
                        e.field_70177_z += this.skyAngularVelocity;
                        while (e.field_70177_z > 360.0f) {
                            e.field_70177_z -= 360.0f;
                        }
                    }
                    if (e instanceof EntityLivingBase) {
                        e.field_70159_w /= (double)0.91f;
                        e.field_70179_y /= (double)0.91f;
                        if (e instanceof EntityFlying) {
                            e.field_70181_x /= (double)0.91f;
                            continue;
                        }
                        e.field_70181_x /= (double)0.98f;
                        continue;
                    }
                    if (e instanceof EntityFallingBlock) {
                        e.field_70181_x /= (double)0.98f;
                        continue;
                    }
                    e.field_70159_w /= (double)0.98f;
                    e.field_70181_x /= (double)0.98f;
                    e.field_70179_y /= (double)0.98f;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean updatePlayerForSpin(EntityPlayerSP p, float partialTicks) {
        float angleDelta = partialTicks * this.angularVelocityRadians;
        if (this.doSpinning && angleDelta != 0.0f) {
            boolean doGravity = false;
            double xx = p.field_70165_t - this.spinCentreX;
            double zz = p.field_70161_v - this.spinCentreZ;
            double arc = Math.sqrt(xx * xx + zz * zz);
            float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
            if (xx < 0.0) {
                angle += (float)Math.PI;
            }
            double offsetX = -(arc *= (double)angleDelta) * (double)MathHelper.func_76126_a((float)(angle += angleDelta / 3.0f));
            double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
            if (p.field_70170_p.func_72945_a((Entity)p, p.field_70121_D).size() == 0) {
                int collisions = 0;
                do {
                    List list;
                    if ((collisions = (list = p.field_70170_p.func_72945_a((Entity)p, p.field_70121_D.func_72321_a(offsetX, 0.0, offsetZ))).size()) <= 0) continue;
                    if (!doGravity) {
                        p.field_70159_w += -offsetX;
                        p.field_70179_y += -offsetZ;
                    }
                    offsetX /= 2.0;
                    offsetZ /= 2.0;
                    if (offsetX < 0.01 && offsetX > -0.01) {
                        offsetX = 0.0;
                    }
                    if (offsetZ < 0.01 && offsetZ > -0.01) {
                        offsetZ = 0.0;
                    }
                    doGravity = true;
                } while (collisions > 0);
                p.field_70165_t += offsetX;
                p.field_70161_v += offsetZ;
                p.field_70121_D.func_72317_d(offsetX, 0.0, offsetZ);
            }
            p.field_70177_z += this.skyAngularVelocity * partialTicks;
            p.field_70761_aq += this.skyAngularVelocity * partialTicks;
            while (p.field_70177_z > 360.0f) {
                p.field_70177_z -= 360.0f;
            }
            while (p.field_70177_z < 0.0f) {
                p.field_70177_z += 360.0f;
            }
            return doGravity;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCentrifugalForce(EntityPlayerSP p) {
        int quadrant = 0;
        double xd = p.field_70165_t - this.spinCentreX;
        double zd = p.field_70161_v - this.spinCentreZ;
        double accel = Math.sqrt(xd * xd + zd * zd) * (double)this.angularVelocityRadians * (double)this.angularVelocityRadians * 4.0;
        quadrant = xd < 0.0 ? (xd < -Math.abs(zd) ? 2 : (zd < 0.0 ? 3 : 1)) : (xd > Math.abs(zd) ? 0 : (zd < 0.0 ? 3 : 1));
        switch (quadrant) {
            case 0: {
                p.field_70159_w += accel;
                break;
            }
            case 1: {
                p.field_70179_y += accel;
                break;
            }
            case 2: {
                p.field_70159_w -= accel;
                break;
            }
            default: {
                p.field_70179_y -= accel;
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.doSpinning = true;
        this.angularVelocityRadians = nbt.func_74760_g("omegaRad");
        this.skyAngularVelocity = nbt.func_74760_g("omegaSky");
        this.angularVelocityTarget = nbt.func_74760_g("omegaTarget");
        this.angularVelocityAccel = nbt.func_74760_g("omegaAcc");
        NBTTagCompound oneBlock = (NBTTagCompound)nbt.func_74781_a("oneBlock");
        this.oneSSBlock = oneBlock != null ? BlockVec3.readFromNBT(oneBlock) : null;
        this.checkSS(this.oneSSBlock, false);
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(this.thrustersFiring);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.worldProvider.field_76574_g);
        objList = new ArrayList();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.worldProvider.field_76574_g);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.worldProvider.field_76574_g);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("doSpinning", this.doSpinning);
        nbt.func_74776_a("omegaRad", this.angularVelocityRadians);
        nbt.func_74776_a("omegaSky", this.skyAngularVelocity);
        nbt.func_74776_a("omegaTarget", this.angularVelocityTarget);
        nbt.func_74776_a("omegaAcc", this.angularVelocityAccel);
        if (this.oneSSBlock != null) {
            NBTTagCompound oneBlock = new NBTTagCompound();
            this.oneSSBlock.writeToNBT(oneBlock);
            nbt.func_74782_a("oneBlock", (NBTBase)oneBlock);
        }
    }

    public void sendPacketsToClient(EntityPlayerMP player) {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(this.thrustersFiring);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), player);
        objList = new ArrayList();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), player);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), player);
    }
}

