/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public abstract class CustomizableSCTE
extends TileEntityOwnable
implements IInventory {
    public ItemStack[] itemStacks = new ItemStack[this.getNumberOfCustomizableOptions()];

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Modules", 10);
        this.itemStacks = new ItemStack[this.getNumberOfCustomizableOptions()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("ModuleSlot");
            if (b0 < 0 || b0 >= this.itemStacks.length) continue;
            this.itemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("ModuleSlot", (byte)i);
            this.itemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Modules", (NBTBase)nbttaglist);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.getNumberOfCustomizableOptions();
    }

    public ItemStack func_70301_a(int par1) {
        return this.itemStacks[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemStacks[par1] != null) {
            if (this.itemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacks[par1];
                this.itemStacks[par1] = null;
                this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[par1].func_77979_a(par2);
            if (this.itemStacks[par1].field_77994_a == 0) {
                this.itemStacks[par1] = null;
            }
            this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
            return itemstack;
        }
        return null;
    }

    public ItemStack safeDecrStackSize(int par1, int par2) {
        if (this.itemStacks[par1] != null) {
            if (this.itemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacks[par1];
                this.itemStacks[par1] = null;
                this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[par1].func_77979_a(par2);
            if (this.itemStacks[par1].field_77994_a == 0) {
                this.itemStacks[par1] = null;
            }
            this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemStacks[par1] != null) {
            ItemStack itemstack = this.itemStacks[par1];
            this.itemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2) {
        this.itemStacks[par1] = par2;
        if (par2 != null && par2.field_77994_a > this.func_70297_j_()) {
            par2.field_77994_a = this.func_70297_j_();
        }
        if (par2 != null) {
            this.onModuleInserted(par2, ((ItemModule)par2.func_77973_b()).getModule());
        }
    }

    public void safeSetInventorySlotContents(int par1, ItemStack par2) {
        this.itemStacks[par1] = par2;
        if (par2 != null && par2.field_77994_a > this.func_70297_j_()) {
            par2.field_77994_a = this.func_70297_j_();
        }
        if (par2 != null && par2.func_77973_b() != null && par2.func_77973_b() instanceof ItemModule) {
            this.onModuleInserted(par2, ((ItemModule)par2.func_77973_b()).getModule());
        }
    }

    public String func_145825_b() {
        return "Customize";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() instanceof ItemModule;
    }

    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
    }

    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
    }

    public ArrayList<EnumCustomModules> getModules() {
        ArrayList<EnumCustomModules> modules = new ArrayList<EnumCustomModules>();
        for (ItemStack stack : this.itemStacks) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemModule)) continue;
            modules.add(((ItemModule)stack.func_77973_b()).getModule());
        }
        return modules;
    }

    public ItemStack getModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            return this.itemStacks[i];
        }
        return null;
    }

    public static Item getModuleFromType(EnumCustomModules module) {
        if (module == EnumCustomModules.WHITELIST) {
            return mod_SecurityCraft.whitelistModule;
        }
        if (module == EnumCustomModules.BLACKLIST) {
            return mod_SecurityCraft.blacklistModule;
        }
        if (module == EnumCustomModules.HARMING) {
            return mod_SecurityCraft.harmingModule;
        }
        if (module == EnumCustomModules.SMART) {
            return mod_SecurityCraft.smartModule;
        }
        if (module == EnumCustomModules.REDSTONE) {
            return mod_SecurityCraft.redstoneModule;
        }
        if (module == EnumCustomModules.STORAGE) {
            return mod_SecurityCraft.storageModule;
        }
        return null;
    }

    public static EnumCustomModules getTypeFromModule(ItemStack module) {
        if (module.func_77973_b() == mod_SecurityCraft.whitelistModule) {
            return EnumCustomModules.WHITELIST;
        }
        if (module.func_77973_b() == mod_SecurityCraft.blacklistModule) {
            return EnumCustomModules.BLACKLIST;
        }
        if (module.func_77973_b() == mod_SecurityCraft.harmingModule) {
            return EnumCustomModules.HARMING;
        }
        if (module.func_77973_b() == mod_SecurityCraft.smartModule) {
            return EnumCustomModules.SMART;
        }
        if (module.func_77973_b() == mod_SecurityCraft.redstoneModule) {
            return EnumCustomModules.REDSTONE;
        }
        if (module.func_77973_b() == mod_SecurityCraft.storageModule) {
            return EnumCustomModules.STORAGE;
        }
        return null;
    }

    public void insertModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null && module != null) {
                this.itemStacks[i] = new ItemStack(CustomizableSCTE.getModuleFromType(module));
                break;
            }
            if (this.itemStacks[i] == null || module != null) continue;
            this.itemStacks[i] = null;
        }
    }

    public void insertModule(ItemStack module) {
        if (module == null || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] != null) continue;
            this.itemStacks[i] = module.func_77946_l();
            break;
        }
    }

    public void removeModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            this.itemStacks[i] = null;
        }
    }

    public boolean hasModule(EnumCustomModules module) {
        if (module == null) {
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
                return true;
            }
        }
        return false;
    }

    public int getNumberOfCustomizableOptions() {
        return this.getCustomizableOptions().length;
    }

    public ArrayList<EnumCustomModules> getOptions() {
        ArrayList<EnumCustomModules> list = new ArrayList<EnumCustomModules>();
        for (EnumCustomModules module : this.getCustomizableOptions()) {
            list.add(module);
        }
        return list;
    }

    public abstract EnumCustomModules[] getCustomizableOptions();

    public abstract String[] getOptionDescriptions();
}

