/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import portalgun.common.PortalGun;
import portalgun.common.entity.EntityPortalBall;
import portalgun.common.item.ItemPortalGun;
import portalgun.common.item.ItemPortalGunBlue;
import portalgun.common.item.ItemPortalGunOrange;

public class EntityPedestal
extends Entity {
    public int prevUseTimer;
    public int pickupTimeout;
    public int firingTimeout;
    public int lastHit;
    public int timesHit;
    public double spawnX;
    public double spawnY;
    public double spawnZ;
    public byte yawLock;

    public EntityPedestal(World world) {
        super(world);
        this.func_70105_a(0.4f, 1.6f);
        this.field_70158_ak = true;
        this.prevUseTimer = -60;
        this.pickupTimeout = 0;
        this.firingTimeout = 0;
        this.lastHit = 0;
        this.timesHit = 0;
        this.spawnZ = 0.0;
        this.spawnY = 0.0;
        this.spawnX = 0.0;
        this.yawLock = 0;
    }

    public EntityPedestal(World world, double d, double d1, double d2, int yawDir) {
        this(world);
        ++yawDir;
        float f = (float)(yawDir %= 4) * 90.0f;
        this.spawnX = d;
        this.spawnY = d1;
        this.spawnZ = d2;
        this.func_70012_b(d, d1, d2, f, 0.0f);
        this.setIsAimed();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new ItemStack(Blocks.field_150346_d));
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(19, (Object)-60);
        this.field_70180_af.func_75682_a(20, (Object)1);
    }

    public void setPortalGun(ItemStack is, EntityPlayer player) {
        if (is != null && player != null) {
            this.field_70180_af.func_75692_b(17, (Object)PortalGun.getCHex(PortalGun.getOwnerName(player, player.field_71071_by.field_70461_c) + (is.func_77973_b() instanceof ItemPortalGunBlue ? "1" : "2")));
            this.field_70180_af.func_75692_b(18, (Object)PortalGun.getOwnerName(player, player.field_71071_by.field_70461_c));
        }
        if (is == null) {
            is = new ItemStack(Blocks.field_150346_d);
        } else {
            this.pickupTimeout = 5;
        }
        this.field_70180_af.func_75692_b(16, (Object)is);
    }

    public ItemStack getPortalGun() {
        ItemStack is = this.field_70180_af.func_82710_f(16);
        return is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) ? null : is;
    }

    public void setColour(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    public int getColour() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setOwner(String own) {
        this.field_70180_af.func_75692_b(18, (Object)own);
    }

    public String getOwner() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setUseTimer(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    public int getUseTimer() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setIsAimed() {
        for (float yaw = this.field_70177_z; yaw < 0.0f; yaw += 360.0f) {
        }
        this.field_70180_af.func_75692_b(20, (Object)((byte)((yaw %= 360.0f) / 90.0f)));
    }

    public byte getAim() {
        return this.field_70180_af.func_75683_a(20);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.setPortalGun(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("gun")), null);
        this.setColour(tag.func_74762_e("rendColour"));
        this.setOwner(tag.func_74779_i("owner"));
        this.setUseTimer(tag.func_74762_e("useTimer"));
        this.firingTimeout = tag.func_74762_e("firingTimeout");
        this.spawnX = tag.func_74769_h("spawnX");
        this.spawnY = tag.func_74769_h("spawnY");
        this.spawnZ = tag.func_74769_h("spawnZ");
        this.field_70177_z -= this.field_70177_z % 90.0f;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        NBTTagCompound gunTag = new NBTTagCompound();
        if (this.getPortalGun() != null) {
            this.getPortalGun().func_77955_b(gunTag);
        }
        tag.func_74782_a("gun", (NBTBase)gunTag);
        tag.func_74768_a("rendColour", this.getColour());
        tag.func_74778_a("owner", this.getOwner());
        tag.func_74768_a("useTimer", this.getUseTimer());
        tag.func_74768_a("firingTimeout", this.firingTimeout);
        tag.func_74780_a("spawnX", this.spawnX);
        tag.func_74780_a("spawnY", this.spawnY);
        tag.func_74780_a("spawnZ", this.spawnZ);
    }

    public void dropAsItem() {
        if (!this.field_70170_p.field_72995_K && PortalGun.getSettings("apgDrops") == 1) {
            double f1 = 0.5;
            double d = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * f1;
            double d1 = this.field_70146_Z.nextDouble() * f1;
            double d2 = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * f1;
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + d, this.field_70163_u + d1, this.field_70161_v + d2, new ItemStack(PortalGun.itemPedestal, 1));
            entityitem.field_145804_b = 10;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            if (this.getPortalGun() != null) {
                f1 = 0.5;
                d = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * f1;
                d1 = this.field_70146_Z.nextDouble() * f1;
                d2 = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * f1;
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + d, this.field_70163_u + d1, this.field_70161_v + d2, this.getPortalGun().func_77946_l());
                entityitem.field_145804_b = 10;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (!(this.field_70170_p.field_72995_K || this.pickupTimeout > 0 || PortalGun.getSettings("apgGiveMode") != 1 && PortalGun.getSettings("apgGiveMode") != 2 || this.getPortalGun() == null || !(damagesource.func_76346_g() instanceof EntityPlayer) || damagesource instanceof EntityDamageSourceIndirect)) {
            EntityPlayer player = (EntityPlayer)damagesource.func_76346_g();
            boolean add = true;
            if (PortalGun.getSettings("autoMergeGuns") >= 1) {
                for (int i1 = 0; i1 < player.field_71071_by.field_70462_a.length; ++i1) {
                    ItemStack is2 = player.field_71071_by.field_70462_a[i1];
                    if (is2 == null) continue;
                    if (is2.func_77973_b() == PortalGun.itemPGBlue && is2.func_77960_j() == 5 && this.getPortalGun().func_77973_b() instanceof ItemPortalGunOrange && this.getPortalGun().func_77960_j() == 5) {
                        add = false;
                    } else if (is2.func_77973_b() == PortalGun.itemPGOrange && is2.func_77960_j() == 5 && this.getPortalGun().func_77973_b() instanceof ItemPortalGunBlue && this.getPortalGun().func_77960_j() == 5) {
                        add = false;
                    }
                    if (add) continue;
                    ItemStack is = new ItemStack(PortalGun.itemPGBlue, 1, 0);
                    is.func_77982_d(this.getPortalGun().func_77978_p());
                    player.field_71071_by.field_70462_a[i1] = is;
                    break;
                }
            }
            if (add && player.field_71071_by.func_70441_a(this.getPortalGun().func_77946_l())) {
                this.setPortalGun(null, null);
                if (PortalGun.getSettings("apgSingleUse") == 1) {
                    this.setUseTimer(1);
                }
                player.field_71071_by.func_70296_d();
                return true;
            }
        } else if (i > 0.0f && PortalGun.getSettings("apgIsInvincible") != 1) {
            this.lastHit = 20;
            ++this.timesHit;
            if (this.timesHit >= 5 && !this.field_70170_p.field_72995_K) {
                this.dropAsItem();
                this.func_70106_y();
            } else if (damagesource.func_76346_g() != null && (double)this.func_70032_d(damagesource.func_76346_g()) <= 3.0) {
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70050_g(300);
        this.field_70125_A = 0.0f;
        this.field_70126_B = this.field_70177_z %= 360.0f;
        this.prevUseTimer = this.getUseTimer();
        if (!this.field_70170_p.field_72995_K) {
            if (this.spawnX == 0.0 && this.spawnY == 0.0 && this.spawnZ == 0.0) {
                this.func_70106_y();
                return;
            }
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.func_70107_b(this.spawnX, this.spawnY, this.spawnZ);
        } else if (this.yawLock != this.getAim()) {
            this.yawLock = this.getAim();
            this.field_70126_B = this.field_70177_z = (float)this.getAim() * 90.0f;
            this.firingTimeout = 80;
        }
        if (Math.abs(this.getUseTimer()) > 0) {
            this.setUseTimer(this.getUseTimer() + 1);
        } else if (this.pickupTimeout > 0) {
            --this.pickupTimeout;
        } else if (this.field_70170_p.isSideSolid((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) - 1, (int)Math.floor(this.field_70161_v), ForgeDirection.UP, false)) {
            if (this.field_70170_p.func_72864_z((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) - 1, (int)Math.floor(this.field_70161_v)) || this.firingTimeout > 0) {
                if (this.getPortalGun() != null) {
                    if (this.firingTimeout > 0) {
                        if (this.firingTimeout == 80) {
                            this.field_70170_p.func_72956_a((Entity)this, "portalgun:apg_firing", 0.3f, 1.0f);
                        } else if (this.firingTimeout == 60 && this.field_70170_p.func_72864_z((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) - 1, (int)Math.floor(this.field_70161_v)) && !this.field_70170_p.field_72995_K) {
                            EntityPortalBall ball = new EntityPortalBall(this.field_70170_p, this, this.getPortalGun().func_77973_b() instanceof ItemPortalGunBlue ? 1 : 2, this.getOwner());
                            this.field_70170_p.func_72838_d((Entity)ball);
                        } else if (this.firingTimeout == 1 && this.field_70170_p.func_72864_z((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) - 1, (int)Math.floor(this.field_70161_v))) {
                            this.field_70170_p.func_72956_a((Entity)this, "portalgun:apg_turn", 0.2f, 1.0f);
                            this.field_70177_z += 1.5f;
                        }
                        --this.firingTimeout;
                    } else {
                        this.field_70177_z += 1.5f;
                        if (this.field_70177_z % 90.0f == 0.0f) {
                            this.setIsAimed();
                            this.firingTimeout = 90;
                        }
                    }
                } else if (this.field_70177_z % 90.0f != 0.0f) {
                    this.field_70177_z += 1.5f;
                }
            } else if (this.field_70177_z % 90.0f != 0.0f) {
                this.field_70177_z += 1.5f;
            }
        } else {
            this.dropAsItem();
            this.func_70106_y();
        }
        if (this.field_70170_p.func_147439_a((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)).func_149662_c() || this.field_70170_p.func_147439_a((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u) + 1, (int)Math.floor(this.field_70161_v)).func_149662_c()) {
            this.dropAsItem();
            this.func_70106_y();
        }
        if (this.lastHit > 0) {
            --this.lastHit;
            if (this.lastHit == 0) {
                this.timesHit = 0;
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.getPortalGun() != null && (PortalGun.getSettings("apgGiveMode") == 1 || PortalGun.getSettings("apgGiveMode") == 3) && this.pickupTimeout <= 0 && this.func_70032_d((Entity)player) < 1.25f) {
            boolean add = true;
            if (PortalGun.getSettings("autoMergeGuns") >= 1) {
                for (int i1 = 0; i1 < player.field_71071_by.field_70462_a.length; ++i1) {
                    ItemStack is2 = player.field_71071_by.field_70462_a[i1];
                    if (is2 == null) continue;
                    if (is2.func_77973_b() == PortalGun.itemPGBlue && is2.func_77960_j() == 5 && this.getPortalGun().func_77973_b() instanceof ItemPortalGunOrange && this.getPortalGun().func_77960_j() == 5) {
                        add = false;
                    } else if (is2.func_77973_b() == PortalGun.itemPGOrange && is2.func_77960_j() == 5 && this.getPortalGun().func_77973_b() instanceof ItemPortalGunBlue && this.getPortalGun().func_77960_j() == 5) {
                        add = false;
                    }
                    if (add) continue;
                    ItemStack is = new ItemStack(PortalGun.itemPGBlue, 1, 0);
                    is.func_77982_d(this.getPortalGun().func_77978_p());
                    player.field_71071_by.field_70462_a[i1] = is;
                    break;
                }
            }
            if (add && player.field_71071_by.func_70441_a(this.getPortalGun().func_77946_l())) {
                this.setPortalGun(null, null);
                if (PortalGun.getSettings("apgSingleUse") == 1) {
                    this.setUseTimer(1);
                }
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public float func_70047_e() {
        return 1.3f;
    }

    protected void func_70081_e(int i) {
        this.func_70066_B();
    }

    protected void func_70069_a(float f) {
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(PortalGun.itemPedestal, 1);
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemStack is;
        if (!this.field_70170_p.field_72995_K && (PortalGun.getSettings("apgSingleUse") == 1 && this.getUseTimer() == 0 || PortalGun.getSettings("apgSingleUse") != 1 && this.getUseTimer() >= 0) && this.getPortalGun() == null && (is = player.func_71045_bC()) != null && is.func_77973_b() instanceof ItemPortalGun) {
            this.setPortalGun(is, player);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            player.field_71071_by.func_70296_d();
            return true;
        }
        return this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

