#include <stdio.h>

long int readl(FILE *in)
{
	unsigned long int v = 0L;
	unsigned int ch;

	ch = fgetc(in); v += ch;
	ch = fgetc(in); v += (ch << 8);
	ch = fgetc(in); v += (((unsigned long int) ch) << 16);
	ch = fgetc(in); v += (((unsigned long int) ch) << 24);
	return(v);
}

long int readw(FILE *in)
{
	unsigned long int v = 0L;
	unsigned int ch;

	ch = fgetc(in); v += ch;
	ch = fgetc(in); v += (ch << 8);
	return(v);
}

main (int argc, char *argv[])
{
	FILE *in;
	FILE *out;

	int ch = 0, l, tp;
	long int i1, i2;
	long line = 0,zz;

	printf("SHEMU sld line number extractor by A.R.Hartley 1994\n");
	printf("(C) Nordic Concepts & S N Systems 1994\n");

	if ((in = fopen(argv[1], "rb")) == NULL)
	{
		printf("Problem opening input file '%s'",argv[1]);
		exit(0);
	}

	if ((out = fopen(argv[2], "w")) == NULL)
	{
		printf("Problem opening output file '%s'",argv[2]);
		exit(0);
	}

	ch = fgetc(in);
	ch = fgetc(in);
	ch = fgetc(in);
	ch = fgetc(in);

	ch = fgetc(in);
	ch = fgetc(in); ch = fgetc(in); ch = fgetc(in);

	while(! feof(in)) {
		i1 = readl(in);
		tp = fgetc(in);

		if (tp == -1) break;

		if (tp == 8) {
			l = fgetc(in) & 0xff;
			fprintf(out,"$%08lx %x MX-info %x", i1, tp, l);
		} else if (tp & 0x80) {
			switch(tp) {

				/* inc sld line by 1 */

				case 0x80:  
					line++;
					fprintf(out,"$%08lx * %lx", i1, line);
					break;

				/* add byte linenum */

				case 0x82:
					l = fgetc(in) & 0xff;
					line+=l;
					fprintf(out,"$%08lx * %lx", i1, line);
					break;

				/* add word linenum */

				case 0x84:
					l = readw(in);
					line+=l;
					fprintf(out,"$%08lx * %lx", i1, line);
					break;

				/* set linenum */

				case 0x86:
					i2 = readl(in);
					line=i2;
					fprintf(out,"$%08lx * %lx", i1, line);
					break;

				/* set linenum and file */

				case 0x88:
					i2 = readl(in);
					line=i2;

					fputc('>',out);

					l = fgetc(in) & 0xff;
					while (l--)
						fputc(fgetc(in),out);
	
					fprintf(out,"\n$%08lx * %lx ", i1, line);

					break;

				/* end sld data */

				case 0x8A:
					/* printf("$%08lx %x End", i1, tp); */
					break;

				/* crap */

				case 0x8C:
					zz = readw(in);
					zz = readl(in);
					zz = readw(in);
					zz = readl(in);
					zz = readl(in);
					zz = readl(in);

					l = fgetc(in) & 0xff;
					while (l--)
						zz = fgetc(in);

					l = fgetc(in) & 0xff;
					while (l--)
						zz = fgetc(in);
					break;

				case 0x8E:
					zz = readl(in);
					break;

				case 0x90:
					zz = readl(in);
					break;

				case 0x92:
					zz = readl(in);
					break;

				case 0x94:

					zz = readw(in);
					zz = readw(in);
					zz = readl(in);
	
					l = fgetc(in) & 0xff;
					while (l--)
						zz = fgetc(in);
					break;

				case 0x96:

					zz = readw(in);
					zz = readw(in);
					zz = readl(in);

					i1 = readw(in);
					while(i1--)
						 zz = readl(in);

					l = fgetc(in) & 0xff;
					while (l--)
						zz = fgetc(in);

					l = fgetc(in) & 0xff;
					while (l--)
						zz = fgetc(in);
					break;

				default:
					fprintf(out,"?? %02x ??\n", tp);
					break;
			}
		} else {


			if (tp == 1) {
				fprintf(out,"$%08lx E ", i1);
				for (l = fgetc(in); l > 0; l--)
				fputc(fgetc(in),out);
						    }

			if (tp == 2) {
				fprintf(out,"$%08lx N ", i1);
				for (l = fgetc(in); l > 0; l--)
				fputc(fgetc(in),out);
						    }

			if (tp == 6) {
				fprintf(out,"$%08lx L ", i1);
				for (l = fgetc(in); l > 0; l--)
				fputc(fgetc(in),out);
						    }

		}
		fprintf(out,"\n");
	}

	zz++;

	fclose(in);
	fclose(out);
}

