/*
** CdcStat PSYQcdinit(void) 
**
** This function initialises the Saturn CD block
** causing ot to read the Sega Security area.
** 
** If you have a Psy-Q interface in the Saturn cart port then you
** must execute this function before you can use CDROM functions.
**
** 25-May-95	delay necessary in do loop else CDblock stalls.
**
*/

#include <sega_cdc.h>

#define SYS_CDINIT1(i) \
        ((**(void(**)(int))0x60002dc)(i))

#define SYS_CDINIT2() \
        ((**(void(**)(void))0x600029c)())

int PSYQcdinit (void)
{
	Sint32 ret;
	CdcStat stat;
	volatile int delay;

	SYS_CDINIT1(3);

	SYS_CDINIT2();

	do
	{
		for(delay = 100000; delay; delay--)
			;

		ret = CDC_GetCurStat(&stat);

	} while ((ret != 0) || (CDC_STAT_STATUS(&stat) == 0xff));

	return (int) CDC_STAT_STATUS(&stat);
}


