/*******************************************************/
/* Before running, SET LANG= to the correct language.  */
/* It may already be correctly set in your CONFIG.SYS. */
/* For examples:                                       */
/* SET LANG=ar_AA for Arabic / Egypt                   */
/* SET LANG=pt_BR for Portugese / Brazil               */
/* SET LANG=zh_CN for Simplified Chinese / China       */
/* SET LANG=zh_CX for Simplified Chinese GBX / China   */
/* SET LANG=de_DE for German / Germany                 */
/* SET LANG=da_DK for Danish / Denmark                 */
/* SET LANG=es_ES for Spanish / Spain                  */
/* SET LANG=el_GR for Greek / Greece                   */
/* SET LANG=fi_FI for Finnish / Finland                */
/* SET LANG=fr_FR for French / France                  */
/* SET LANG=zh_HK for Traditional Chinese / Hong Kong  */
/* SET LANG=iw_IL for Hebrew / Israel                  */
/* SET LANG=it_IT for Italian / Italy                  */
/* SET LANG=ja_JP for Japanese / Japan                 */
/* SET LANG=ko_KR for Korean / Korea                   */
/* SET LANG=nl_NL for Dutch / Netherlands              */
/* SET LANG=no_NO for Norwegian / Norway               */
/* SET LANG=sv_SE for Swedish / Sweden                 */
/* SET LANG=zh_SG for Simplified Chinese / Singapore   */
/* SET LANG=zh_TW for Traditional Chinese / Taiwan     */
/* SET LANG=en_US for English (default)                */
/*******************************************************/

/*****************************************
* Intialize Rexxutil Functions
******************************************/

  call RxFuncAdd 'SysLoadFuncs' , 'REXXUTIL', 'SysLoadFuncs'

  signal on syntax name MsgExit

  call SysLoadFuncs

  numeric digits 12

/******************************************
* Define message ids from *mid*.h
*******************************************/

  MSG_NO_ERROR               =    0
  MSG_SYSINIT_BOOT_NOT_FD    = 1475
  MSG_INCORRECT_DOSVER       = 1210
  MSG_NO_META_MATCH          =  257
  MSG_PRINT_FILE_NOT_FOUND   = 1533
  MSG_COMP_INVALID_PATH      = 1171
  MSG_BOOT_MUST_RESTART      = 1716
  MSG_INSTALL_UNSUCCESSFUL   = 1975
  MSG_INSTALL_HY_HDR         = 1976
  MSG_PROC_NOT_FOUND         =  127
  MSG_REP_SOUR_PATH_REQ      = 1137
  MSG_SYS_INV_DRIVE          = 1461
  MSG_CHCP_INVALID_PARAMETER = 1761
  MSG_UNP_INSERT_PI          = 1218
  MSG_ERR_PROC_ARG           = 1249
  MSG_MBS_INVALID_COMMAND    =  872
  MSG_USAGE                  =  734
  MSG_BAD_UNIT               =   20
  MSG_CANNOT_MAKE            =   82
  REXX_FUNCTION_NOT_FOUND    =   43
  SPTReboot                  = x2d('FE00',4)
  SPTRebootErr               = x2d('FE08',4)
  SPTWithErr                 = x2d('0008',4)

/***************************************************************************
* Define Locale Mappings
*
* loc = a location which maps to multiple keys where first is more common
* Some locations are languages or nlv where not ambiguous with location.
* Table entries are sorted by location.  The algorithm depends on this!
* Some locations have more than one language/locale/table entry.
* Most common language locale is listed first.  The algorithm depends on this!
*
* key = a locale which maps to single nlv, splits into language and location
* Many locales have more than one location/table entry,
* because they have more than one location/language/nlv string.
*
* nlv = national language version which is source subdirectory
* Most nlv's support more than one locale.
* Some nlv's are no longer supported and subsequently mapped instead to EN.
****************************************************************************/

  locale_loc =               '    AA    AL    AR    AS    AT    AU    BA    BE'
  locale_key =               ' AR_AA SQ_AL ES_AR EN_AS DE_AT EN_AU SH_BA FR_BE'
  locale_nlv =               '    AR    EN    ES    EN    DE    EN    EN    FR'

  locale_loc = locale_loc || '    BE    BG    BH    BO    BR    BY    CA    CA'
  locale_key = locale_key || ' NL_BE BG_BG AR_BH ES_BO PT_BR BE_BY EN_CA FR_CA'
  locale_nlv = locale_nlv || '    NL    BG    AR    ES    BR    UK    EN    FR'

  locale_loc = locale_loc || '    CF    CH    CH    CH    CL    CN    CO    CR'
  locale_key = locale_key || ' FR_CA DE_CH FR_CH IT_CH ES_CL ZH_CN ES_CO ES_CR'
  locale_nlv = locale_nlv || '    FR    DE    FR    IT    ES    CN    ES    ES'

  locale_loc = locale_loc || '    CS    CX    CZ    DA    DE    DK    DO    DZ'
  locale_key = locale_key || ' CS_CZ ZH_CX CS_CZ DA_DK DE_DE DA_DK ES_DO AR_DZ'
  locale_nlv = locale_nlv || '    CZ    CN    CZ    DK    DE    DK    ES    AR'

  locale_loc = locale_loc || '    EC    EE    EG    EL    EN    ES    ES    ES'
  locale_key = locale_key || ' ES_EC ET_EE AR_EG EL_GR EN_US ES_ES CA_ES EU_ES'
  locale_nlv = locale_nlv || '    ES    EN    AR    GR    EN    ES    CA    ES'

  locale_loc = locale_loc || '    ET    EU    FI    FR    GB    GE    GK    GR'
  locale_key = locale_key || ' ET_EE EU_ES FI_FI FR_FR EN_GB EN_GR EL_GR EL_GR'
  locale_nlv = locale_nlv || '    EN    ES    FI    FR    UK    GE    GR    GR'

  locale_loc = locale_loc || '    GR    GT    HE    HK    HN    HR    HU    IC'
  locale_key = locale_key || ' EN_GR ES_GT IW_IL ZH_HK ES_HN HR_HR HU_HU IS_IS'
  locale_nlv = locale_nlv || '    GE    ES    HE    TW    ES    EN    HU    UK'

  locale_loc = locale_loc || '    ID    IE    IL    IN    IS    IT    IW    JA'
  locale_key = locale_key || ' IN_ID EN_IE IW_IL EN_IN IS_IS IT_IT IW_IL JA_JP'
  locale_nlv = locale_nlv || '    UK    UK    HE    UK    UK    IT    HE    JP'

  locale_loc = locale_loc || '    JO    JP    KO    KR    KW    LA    LB    LI'
  locale_key = locale_key || ' AR_JO JA_JP KO_KR KO_KR AR_KW ES_LA AR_LB DE_LI'
  locale_nlv = locale_nlv || '    AR    JP    KR    KR    AR    ES    AR    DE'

  locale_loc = locale_loc || '    LT    LU    LU    LV    MA    MK    MX    NE'
  locale_key = locale_key || ' LT_LT FR_LU DE_LU LV_LV AR_MA MK_MK ES_MX NL_NL'
  locale_nlv = locale_nlv || '    EN    FR    DE    EN    AR    EN    ES    NL'

  locale_loc = locale_loc || '    NI    NL    NO    NZ    OM    PA    PE    PK'
  locale_key = locale_key || ' ES_NI NL_NL NO_NO EN_NZ AR_OM ES_PA ES_PE EN_PK'
  locale_nlv = locale_nlv || '    ES    NL    NO    EN    AR    ES    ES    EN'

  locale_loc = locale_loc || '    PL    PO    PT    PY    QA    RO    RU    SA'
  locale_key = locale_key || ' PL_PL PT_PT PT_PT ES_PY AR_QA RO_RO RU_RU AR_SA'
  locale_nlv = locale_nlv || '    PL    PT    PT    ES    AR    EN    RU    AR'

  locale_loc = locale_loc || '    SD    SE    SF    SG    SH    SI    SK    SL'
  locale_key = locale_key || ' DE_CH SV_SE FR_CH ZH_SG SH_BA SL_SI SK_SK SL_SI'
  locale_nlv = locale_nlv || '    DE    SE    FR    CN    EN    EN    EN    EN'

  locale_loc = locale_loc || '    SP    SQ    SR    SU    SV    SW    SY    TH'
  locale_key = locale_key || ' SR_SP SQ_AL SR_SP FI_FI ES_SV SV_SE AR_SY TH_TH'
  locale_nlv = locale_nlv || '    EN    EN    EN    FI    ES    SE    AR    TH'

  locale_loc = locale_loc || '    TN    TR    TW    UA    UA    UK    US    US'
  locale_key = locale_key || ' AR_TN TR_TR ZH_TW AR_UA UK_UA EN_GB EN_US ES_US'
  locale_nlv = locale_nlv || '    AR    TR    TW    AR    UK    UK    EN    ES'

  locale_loc = locale_loc || '    UX    UY    VE    YE    ZA    ZH'
  locale_key = locale_key || ' IN_ID ES_UY ES_VE AR_YE EN_ZA ZH_CX'
  locale_nlv = locale_nlv || '    UK    ES    ES    AR    UK    CN'

/*****************************************
* Initialized globals
******************************************/

  if arg() == 0
  then cmdline = ''
  else cmdline = arg( 1 )
  parse source one two me
  srcPath = filespec( 'Drive', me ) || filespec( 'Path', me )
  env = 'OS2ENVIRONMENT'
  envlang = value( 'LANG', , env )
  Parse Upper Var envlang locale

  /* Goal is to find an index which seem to match intent. */
  if Length( locale ) >= 5
  then do /* Check whether long form locale is supported: */
    /* remove "_euro" etc */
    locale = SubStr(locale, 1, 5)
    index = wordpos( locale, locale_key )
  end
  else index = 0

  if ((index == 0) & (Length( locale ) >= 2) )
  then do /* locale should be nlv/location/language: */
    lang = SubStr( locale, 1, 2 )
    index = wordpos( lang , locale_nlv )
    if index > 0
    then do /* It was an nlv.  Should also be a location string. */
      nlv = lang
      index = wordpos( nlv , locale_loc )
      if( nlv \= word( locale_nlv, index ) )
        /* Was an ambiguous language/location/nlv. */
        /* Must be AR/CA. Use as nlv only. */
      then index = wordpos( nlv , locale_nlv )
    end
      /* Not an nlv. */
      /* So see if it's a location or lang:   */
      /* Note that BE/IN/UA are ambiguous. */
      /* We pick the most likely meaning.     */
    else index = wordpos( lang , locale_loc )
  end
  if index == 0
    /* It was not an nlv, location, or lang. So it's unknown. */
  then index = wordpos( 'EN_US', locale_key )
  locale = word( locale_key, index )
  nlv = word( locale_nlv, index )
  say 'ENV LANG=' || envlang || ', LOCALE=' || locale || ', NLV=' || nlv
  say ''

  files = srcPath || nlv || '\*.*'
  if stream(files, 'c', 'query exists') == ''
  then nlv = 'EN' /* All unsupported nlv's map to EN */

  if nlv == 'CN' or nlv == 'JP' or nlv == 'KR' or nlv == 'TW'
  then cs = 'DBCS'
  else cs = 'SBCS'
  if nlv == 'KR'
  then dos = 'KR'
  else dos = cs
  cidInst = ''

/*****************************************
* GRADD only globals
******************************************/

  GRADDKEYS    = 'GEN SDD SNAP VGA'
  GRADDDSCS    = 'gengrdbb sddgrdbb sddgrdbb vgagrdbb'
  graddPackDSC = 'grdpack.dsc'

/*****************************************
* Set up Source Paths
******************************************/

  srcName = filespec('Name', me)

/*****************************************
* Set up default boot drive.
* GRADD is not supported on OS/2 Versions less than 3.0.
* Let us verify we have the right version now.
******************************************/

  parse value(SysOS2Ver()) with major '.' os2Ver
  rc = MSG_INCORRECT_DOSVER
  select
    when major < 2
      then call MsgExit MyGetMsg(SysGetMessage(MSG_INCORRECT_DOSVER))
    when datatype(os2Ver) \= 'NUM'
      then call MsgExit MyGetMsg(SysGetMessage(MSG_INCORRECT_DOSVER))
    when os2Ver < 30
      then call MsgExit MyGetMsg(SysGetMessage(MSG_INCORRECT_DOSVER))
    /* SysBootDrive() only works on WSeB level code */
    when os2Ver < 45 /* Before WSeB */
      then do
        /* We must make best "guess" */
        rc = MSG_NO_ERROR
        os2bootpath = SysSearchPath('PATH', 'os2boot')
        if os2bootpath == ''
        then do
          /* Maybe boot drive root is not in path! */
          os2bootpath = translate(value('PATH',,env))
          if os2bootpath \= ''
          then do
            first = pos(':\OS2;', os2bootpath)
            if first <= 0
            then os2bootpath = ''
            else do
              os2bootpath = SubStr(os2bootpath, first - 1, 2)
              bootDrive = filespec('drive', os2bootPath)
              file1 = bootDrive || '\os2boot'
              call SysFileTree file1,'file','F'
              if file.0 == 0
              then os2bootpath = ''
            end
          end
        end
        if os2bootpath == ''
        then do
          /* Maybe boot drive \OS2 has been renamed! */
          os2bootpath = SysSearchPath('PATH', 'unpack2.exe')
          if os2bootpath \= ''
          then do
            bootDrive = filespec('drive', os2bootPath)
            file1 = bootDrive || '\os2boot'
            call SysFileTree file1,'file','F'
            if file.0 == 0
            then os2bootpath = ''
          end
          if os2bootpath == ''
          then do
            /* Maybe unpack2 is not on boot drive! */
            os2bootpath = Directory()
            bootDrive = filespec('drive', os2bootPath)
            file1 = bootDrive || '\os2boot'
            call SysFileTree file1,'file','F'
            if file.0 == 0
            then call MsgExit SysGetMessage(MSG_SYSINIT_BOOT_NOT_FD)
          end
        end
      end
    otherwise /* WSeB or after */
      os2bootpath = SysBootDrive()
  end
  rc = MSG_NO_ERROR
  bootDrive = filespec('drive', os2bootPath)

/******************************************
* Verify options if any
*******************************************/

  if arg() == 0
  then call Usage
  else do
    parse value(cmdline) with tmp1 '/' option tmp2
    if option \= ''
    then do
      if translate(option) == 'U'
      then do
        cidInst = ' /u'
        cmdline = tmp1 || tmp2
      end
      else do
        say MyGetMsg(SysGetMessage(MSG_MBS_INVALID_COMMAND,, '"' || '/' || option || '"'))
        call Usage
      end
    end
    parse value(cmdline) with gradd srcTmp bootTmp junk
    if junk \= ''
    then call Usage
    if wordpos(translate(gradd), GRADDKEYS) == 0
    then call Usage
    else dscFile = word(GRADDDSCS, wordpos(translate(gradd), GRADDKEYS)) || '.dsc'
    if srcTmp \= ''
    then do
      if filespec('Drive',srcTmp) == strip(srcTmp, 'T', '\')
      then srcChk = srcTmp
      else srcChk = strip(srcTmp, 'T', '\') || '\'
      file1 = srcChk || srcName
      call SysFileTree file1, 'file', 'F'
      if file.0 == 0
      then do
        say FileNotFound( file1 )
        say MyGetMsg(SysGetMessage(MSG_CHCP_INVALID_PARAMETER,,srcTmp))
        call Usage
      end
      else srcPath = srcChk
    end
    if bootTmp \= ''
    then do
      bootTmp   = strip(bootTmp, 'T', '\')
      file1 = bootTmp || '\OS2BOOT'
      call SysFileTree file1, 'file', 'F'
      if file.0 == 0
      then do
        msg = MyGetMsg(SysGetMessage(MSG_SYSINIT_BOOT_NOT_FD))
        parse value(msg) with first 'OS2BOOT' last
        msg = first || '"' || file1 || '"' || last
        say msg
        say MyGetMsg(SysGetMessage(MSG_SYS_INV_DRIVE))
        call Usage
      end
      else bootDrive = bootTmp
    end
  end
  if filespec('Drive', srcPath) \= strip(srcPath, 'T', '\')
  then srcDir = strip(srcPath, 'T', '\')
  else srcDir = srcPath

/*****************************************
* Set up Target Paths
******************************************/

  installDir = bootDrive || '\os2\install'
  restoreDir = installDir || '\vga'
  snapDir = bootDrive || '\snap'

/*****************************************
* Start logging
******************************************/

  call SysFileTree installDir, 'file', 'D'
  if file.0 == 0
  then call MsgExit MyGetMsg(SysGetMessage(MSG_COMP_INVALID_PATH,,'"' || installDir || '"'))
  logFile = installDir || '\display.log'
  call SysFileTree logFile, 'file', 'F', ,'-----'
  startmsg = MyGetMsg(SysGetMessage(MSG_UNP_INSERT_PI,, SubStr(dscFile,1, pos('.', dscFile)-1 ) || ' ' ))
  cmd = 'parse value(startmsg) with . '''D2c(10)''' installmsg '''D2c(13)''' junk'
  interpret cmd
  installmsg = strip(installmsg)
  call LogIt '======================================================================'
  say installmsg
  call LogIt installmsg ' - ' Date('L')  Time()
  file1 = srcPath || 'build.lvl'
  call SysFileTree file1,'file','F'
  if file.0 == 0
  then call LogFileNotFound file1
  else '@type ' || file1 || ' >> ' || logFile

/*****************************************
* GRADD also requires a certain fixpak level for both version 3.x and 4.0.
* Let us verify we have the right levels now.
******************************************/

  rc = MSG_INCORRECT_DOSVER
  select
     when os2Ver < 40   /* Warp 3.0 needs fixpak 35 or later */
        then do
           needFPLevel = 8.259
        end
     when os2Ver < 45   /* Warp 4.0 needs fixpak 5 or later */
        then do
           needFPLevel = 9.029
        end
     otherwise          /* Releases after Warp 4.0 should be GRADD ready */
        do
           needFPLevel = 0
        end
  end
  parse value(GetGraddLevel(bootDrive || '\os2\dll\gre2vman.dll')) with graddLevel graddStamp

  if (GetFPLevel() >= needFPLevel)
  then do
     newStamp   = 1
  end
  else call MsgExit MyGetMsg(SysGetMessage(MSG_INCORRECT_DOSVER))
  rc = MSG_NO_ERROR

/*******************************************************
* Setup path and Copy required files to \os2\install
********************************************************/

  oldPath = value('PATH',,env)
  newPath = value('PATH', srcPath || ';' || oldPath, env)

  file1 = srcPath || 'unpack2.exe'
  call SysFileTree file1,'file','F'
  if file.0 == 0
  then call LogFileNotFound file1
  else call LogAndDoCmd 'copy ' || file1 || ' ' || installDir
  rc = MSG_NO_ERROR
  unpackFiles =                       'dspinstl.ex_'
  unpackFiles = unpackFiles || ' ' || 'inscfg32.dl_'
  unpackFiles = unpackFiles || ' ' || nlv || '\unpack'
  unpackFiles = unpackFiles || ' ' || nlv || '\vgamri'
  do i = 1 to words(unpackFiles)
    call LogAndDoCmd 'unpack2 ' || srcPath || word(unpackFiles, i) || ' ' || bootDrive
    if rc \= MSG_NO_ERROR
    then call MsgExit ""
  end
  call LogAndDoCmd 'unpack2 ' || srcPath || 'dspinstl.ex_ ' || restoreDir
  if rc \= MSG_NO_ERROR
  then call MsgExit ""
  call LogAndDoCmd 'copy ' || bootDrive || '\os2\dll\dspimri.dll ' || restoreDir
  if rc \= MSG_NO_ERROR
  then call MsgExit ""

/********************************************************
* Obtain .DSC file
*********************************************************/

  call SysFileTree installDir || '\' || dscFile, 'file', 'F'
  if file.0 == 0
  then call MsgExit MyGetMsg(SysGetMessage(MSG_PRINT_FILE_NOT_FOUND,, '"' || installDir || '\' || dscFile || '"')),
                                   || MyGetMsg(SysGetMessage(MSG_NO_META_MATCH))
  else parse value(file.1) with . . . . dscFile
  dscFile = installDir || '\' || FileSpec('Name', dscFile)

  if SysFileTree(bootDrive || '\os2\video.cfg','file','F',,'+****') == 0
  then call SysFileDelete bootDrive || '\os2\video.cfg'

  if translate(gradd) == 'VGA'
  then call SysIni ,'PM_DISPLAYDRIVERS','DEFAULTSYSTEMRESOLUTION','DELETE:'

  graddPackDSC = installDir || '\' || graddPackDSC
  parse value(GetGraddLevel(srcPath || 'gre2vman.dll')) with . tmpStamp
  if datatype(tmpStamp) == 'NUM'
  then newStamp = tmpStamp

  dspInstall = installDir || '\dspinstl.exe'

  if ((symbol('newStamp') == 'VAR') & (newStamp \= ''))
  then
     if ((graddStamp == '') | ( newStamp > graddStamp))
     then do
        '@' || dspInstall '/pk:other /s:' || srcDir,
                       || ' /t:' || bootDrive,
                       || ' /pd:' || strip(graddPackDSC),
                       || ' /l:' || logFile || cidInst
     end

  '@' || dspInstall '/pk:svga /s:' || srcDir,
                 || ' /t:' || bootDrive,
                 || ' /pd:' || strip(dscFile),
                 || ' /l:' || logFile || cidInst

  if ( (rc == MSG_NO_ERROR) | ((cidInst \= '') & ( rc == SPTReboot)) )
  then do
    call LogAndDoCmd 'copy ' || srcDir  || '\*.txt ' || snapDir
    call LogAndDoCmd 'call ' || snapDir || '\sddvcfg'
    call LogAndDoCmd 'call ' || snapDir || '\makewps'
    call MsgExit MyGetMsg(SysGetMessage(MSG_BOOT_MUST_RESTART))
  end
  else call MsgExit MyGetMsg(SysGetMessage(MSG_ERR_PROC_ARG,,dscFile))

/******************************************************
* Procedure for determining level of Gradd subsystem
*******************************************************/

GetGraddLevel: Procedure

  parse arg graddModule

  gtvVer = ''

  if stream(graddModule,'c', 'query exists') \= ''
  then do
    newQueue = RxQueue('Create')
    oldQueue = RxQueue('Set', newQueue)
    '@bldlevel 'graddModule '| rxqueue' newQueue
    do while queued() \=0
      parse upper pull tag data
      if tag == 'SIGNATURE:'
      then
        do while queued() \= 0
          parse upper pull tag data
          if tag == 'DESCRIPTION:'
          then parse value(data) with 'V' gtvVer gtvStamp .
        end
    end
    call RxQueue 'Delete', newQueue
    call RxQueue 'Set', oldQueue
  end
  if datatype(gtvVer) \= 'NUM'
  then gtvVer = 0
  if datatype(gtvStamp) \= 'NUM'
  then gtvStamp = 0
  return gtvVer gtvStamp

/******************************************************
* Procedure for determining fix pack level of system
*******************************************************/

GetFPLevel: Procedure

  newQueue = RxQueue('Create')
  oldQueue = RxQueue('Set', newQueue)
  '@ver /r | rxqueue' newQueue
  do while queued() \=0
    parse upper pull tag data
    if tag == 'REVISION'
    then leave
  end
  call RxQueue 'Delete', newQueue
  call RxQueue 'Set', oldQueue

  return data

/******************************************************
* Error message processing and exit
*******************************************************/

MsgExit:

  parse arg errmsg

  result = rc
  if rc == REXX_FUNCTION_NOT_FOUND
  then do
    say sigl'  +++      'SourceLine(sigl)
    say 'REX0043: 'ErrorText(REXX_FUNCTION_NOT_FOUND)
  end
  else do
    if errmsg == ''
    then errmsg = 'REXX' || right(rc,4,'0') || ': 'ErrorText(rc)
    say errmsg
    if ( (rc \= MSG_NO_ERROR) & ((cidInst \= '') & ( rc \= SPTReboot)) )
    then do
      exitmsg = MyGetMsg(SysGetMessage(MSG_INSTALL_UNSUCCESSFUL))
      say exitmsg
    end
    if symbol('logfile') == 'VAR'
    then do
      call LogIt errmsg
      if symbol('exitmsg') == 'VAR'
      then do
        call LogIt exitmsg
        say MyGetMsg(SysGetMessage(MSG_INSTALL_HY_HDR)) || ' ' || logfile
      end
    end
  end
  if rc == MSG_INCORRECT_DOSVER
  then '@pause && e ' || srcPath || 'readme.txt'
  if symbol('oldPath') == 'VAR'
  then call value 'PATH' , oldPath, env
  exit result

/******************************************************
* Safely write to logfile
*******************************************************/

LogAndDoCmd:

  call LogIt arg(1)
  '@' || arg(1) || ' >> ' || logfile || ' 2>&1'
  return

/******************************************************
* Log File Not Found
*******************************************************/

LogFileNotFound:

  call LogIt FileNotFound( arg(1) )
  return

/******************************************************
* File Not Found
*******************************************************/

FileNotFound:

  return MyGetMsg(SysGetMessage(MSG_PRINT_FILE_NOT_FOUND,, '"' || arg(1) || '"'))

/******************************************************
* Safely write to logfile
*******************************************************/

LogIt: Procedure expose logfile

  parse arg message
  call lineout logfile, message
  call stream logfile, 'c', 'close'
  return

/******************************************************
* Remove SYSXXXX: from messages
*******************************************************/

MyGetMsg: Procedure

  parse arg message
  if pos('SYS', word(message, 1)) == 1
  then parse arg . message
  return message

/*****************************************************
* Print usage and exit
******************************************************/

Usage:

  msg = MyGetMsg(SysGetMessage(MSG_USAGE,,srcName))
  cmd = 'parse value(msg) with msg '''srcName''' .'
  interpret cmd
  say msg
  say 'SET LANG = ll_cc'
  say me || ' xxx [' || srcPath || '] [' || bootDrive || '] [/u]'
  say ''
  say '   ll_cc = ar_AA | pt_BR | zh_CN | zh_CX | de_DE | da_DK |'
  say '           es_ES | el_GR | fi_FI | fr_FR | el_GR | zh_HK |'
  say '           iw_IL | it_IT | ja_JP | ko_KR | nl_NL | no_NO |'
  say '           sv_SE | zh_SG | zh_TW | en_US | ...'
  say ''
  say '   xxx = SNAP | GEN | VGA'
  say ''
  say '   MORE < ' srcPath || 'README.TXT'
  say ''
  exit 1
