#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <math.h>

#include "uniaud.h"
#include "unidef.h"
#include "errno.h"


int pcms_num[MAX_CARDS] = {0}; // number of pcm instances
int cards_num = 0; // number of cards

POSS32_DEVCAPS pcmcaps[MAX_CARDS] = {0}; // pointer to pcm caps

UniaudCardInfo *CardInfo[MAX_CARDS] = {0};

snd_pcm_status_t status;


int main (int argc, char *argv[])
{
    int ArgNum;
    int ver, err, ret;
    int channels,i, bytesread, count;
    int card_id = 0;
    uniaud_pcm *pcm = NULL;
    char *Buffer;
    char *Buf;
    int readed, written, state, fsize;
    snd_pcm_uframes_t number_of_frames;
    FILE *input_handle;


    printf("PCM test tool for UNIAUD. Version 0.01\n");
    printf("Copyright 2004 by Vlad Stelmahosky aka Vladest\n");

    ver = uniaud_get_version();

    switch (ver)
    {
    case -2:
        printf("Error: uniaud not detected\n");
        return 1;
        break;
    case -1:
        printf("Error: uniaud error\n");
        return 1;
        break;
    default:
        if (ver < 111)
        {
            printf("Error: unsupported version of uniaud\n");
            return 1;
        } else
            printf("Detected UNIAUD version %1d.%02d\n", ver / 100, ver % 100 );
    }

    cards_num = uniaud_get_cards();
    if (!cards_num)
    {
        printf("No audio cards detected\n");
        return 1;
    }

    printf("Detected %i audio adapter(s)\n", cards_num);

    // set pcm to ON
    if (uniaud_mixer_put_value_by_name(card_id,"Master Playback Switch",1, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    if (uniaud_mixer_put_value_by_name(card_id,"Master Playback Volume",50, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    if (uniaud_mixer_put_value_by_name(card_id,"Master Playback Volume",50, 1, 0) < 0)
    {
        printf("Error in mixer\n");
    }
#if 1
    if (uniaud_mixer_put_value_by_name(card_id,"PCM Playback Switch",1, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    if (uniaud_mixer_put_value_by_name(card_id,"PCM Playback Volume",31, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    if (uniaud_mixer_put_value_by_name(card_id,"PCM Playback Volume",31, 1, 0) < 0)
    {
        printf("Error in mixer\n");
    }
#endif
    readed = written = 0;
    err = uniaud_pcm_open(card_id, PCM_TYPE_WRITE, 0, 0, 44100, 2,
                          SNDRV_PCM_FORMAT_S16_LE, &pcm);
    if (pcm && err == 0)
    {
        printf("opened. pcm = %x\n", pcm);
        err = uniaud_pcm_prepare(pcm);
        printf("prepare err = %i\n", err);
        uniaud_pcm_status(pcm, &status);
        if (argc > 1)
            input_handle = fopen(argv[1], "rb");
        else
            input_handle = fopen("debug.wav", "rb");
        if (!input_handle)
        {
            err = uniaud_pcm_close(pcm);
            printf("Error opening file\n");
            return 0;
        }
        //count = pcm->bufsize;
        count = pcm->period_size*2;
        fseek(input_handle, 0L, SEEK_END);
        fsize = ftell(input_handle);
        Buffer = malloc(fsize);
        fseek(input_handle, 0L, SEEK_SET);
        //        memset(Buffer,0, count);
        bytesread = fread (Buffer, 1, fsize, input_handle);
        fclose(input_handle);

        while (1)
        {
            // read file and play into driver
            if (written >= fsize) break;

            err = uniaud_pcm_write(pcm, Buffer+written, count);

            ret = uniaud_pcm_wait(pcm, 1000);
            if (ret <= 0)
                printf("error waiting pcm interrupt %i\n", ret);

            if (err > 0) // write something
            {
                written=written+err;
                printf("written=%i\r",written);
                if (written >= fsize) break;
            }
            if (err == -EAGAIN) //
            {
//                printf("eagain\n");
                continue;
            }
            if (err < 0) {
                if (err < -10000)
                {
                    printf("internal uniaud err = %i\n", err);
                    break;
                }
                state = uniaud_pcm_state(pcm);
                printf("state after write: %i, err = %i\n",state, err);
                if ( (state != SND_PCM_STATE_PREPARED) &&
                     (state != SND_PCM_STATE_RUNNING) &&
                     (state != SND_PCM_STATE_DRAINING) ) {
                    printf("write:BAD STATE2, state = %d, going to try XRUN\n",state);
                    if ((ret = uniaud_pcm_prepare(pcm))<0) {
//                        printf("xrun: prepare error: %i", err);
                        return 0;
                    }
                }
            }
        }
        free(Buffer);
        err = uniaud_pcm_close(pcm);
    }
    else
    {
        printf("open err: %i, pcm %x\n", err, pcm);
        if (err == 10005)
            err = uniaud_pcm_close(pcm);
        printf("close err: %i\n", err);
    }

    return 0;
}
