Program UltraEx1;

Uses Crt,UltraDev;

{
  Small example playing a 16bit sample stored in file 'Sound.Dat'
  by Timo Maier 13.01.1996 using VirtualPascal/2
}

Const SoundFile = 'Sound.Dat';
var SampleSize,SampleLoc : LongInt;

Function LoadSoundToGUS : boolean;
var SndBuffer : pointer;
    f         : File;
begin
  Assign(f,SoundFile);
  {$I-}
  Reset(f,1);
  {$I+}
  if IOResult = 0 then begin
    SampleSize := FileSize(f);
    GetMem(SndBuffer,SampleSize);
    BlockRead(f,SndBuffer^,SampleSize);
    if UltiMODMemAlloc(SampleSize,SampleLoc) = 0 then begin
      if UltraDownLoad(SndBuffer,Convert,SampleLoc,SampleSize,TRUE) <> 0 then
        UltiMODMemFree;
    end
    else
      writeln('Not enought GUS RAM to download sample!');
    FreeMem(SndBuffer,SampleSize);
    Close(f);
    LoadSoundToGUS := true;
  end
  else begin {File read Error}
    LoadSoundToGUS := false;
    writeln('Cannot open ',SoundFile);
  end;
end;

Procedure PlaySounds;
begin
  UltraSetAll(1,BalanceCenter,KHz_11,4000,63,0);
  UltraStartVoice(1,SampleLoc,SampleLoc,SampleLoc+SampleSize-1,Voice16Bit);
  write('playing ....');
  repeat until UltraVoiceStopped(1);
  writeln;
  writeln('Done!');
  While Keypressed do
    readkey;
  UltraStopVoice(1);
end;

Procedure NormalStuff;
begin
  CheckBreak := FALSE;
  DirectVideo := TRUE;
  CheckSnow := FALSE;
end;

begin
  if OpenUltraSound then begin
    NormalStuff;
    ClrScr;
    WriteLn(' UltraEx1 by TAM');
    WriteLn(' Manley Driver Version : ',GetManleyVersion);
    WriteLn(' ',UltraSizeDram,'kB DRAM on GravisUltraSound');
    UltraSetNVoices(14);
    UltraEnableOutput;
    if LoadSoundToGUS then
      PlaySounds;
    CloseUltraSound;
  end
  else begin
    writeln('Cannot open GravisUltraSound');
    writeln('Maybe another application uses the driver already, or Manley');
    writeln('driver not installed! Program aborted.');
  end;
end.
