//
// $Header$
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSDEVIOCTL
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#pragma pack(1)
struct getdevparm_parms {
   UCHAR cmd;
   UCHAR drive;
};
#pragma pack(4)


void verify_track(FILE *out, HFILE f, USHORT c, USHORT h, USHORT heads, USHORT sectors_per_track, USHORT bytes_per_sector, USHORT sectors_per_block) {
    APIRET rc;
    ULONG  pio;
    ULONG  dio;
    ULONG  lba;
    TRACKLAYOUT tracklayout;
    int i;

    for (i = 0 ; i < sectors_per_track ; i++) {
        tracklayout.bCommand      = 0;
        tracklayout.usHead        = h;
        tracklayout.usCylinder    = c;
        tracklayout.usFirstSector = 0;
        tracklayout.cSectors      = 1;
        tracklayout.TrackTable[0].usSectorNumber = i + 1;
        tracklayout.TrackTable[0].usSectorSize   = bytes_per_sector;
        pio = sizeof(TRACKLAYOUT);
        dio = 0;
        rc = DosDevIOCtl(
                         f,
                         IOCTL_DISK,
                         DSK_VERIFYTRACK,
                         &tracklayout, pio, &pio,
                         0, dio, &dio
                        );
        if (rc != NO_ERROR) {
            lba = (ULONG) c * (ULONG) heads * (ULONG) sectors_per_track +
                  (ULONG) h * (ULONG) sectors_per_track                 +
                  (ULONG) i;

            fprintf(out, "%lu\n", lba / (ULONG) sectors_per_block);
            fprintf(stderr,  "Invalid block %lu\n", lba / (ULONG) sectors_per_block);

            /*
             * Avoids duplicate entries in bad block list
             */
            i += sectors_per_block - 1;
        }

    }
}
int glop;
int v_flag = 0;                 /* verbose */
int w_flag = 0;                 /* do r/w test */
int s_flag = 0;                 /* show progress of test */

char *program_name = "badblks.exe";

void usage (void)
{
        fprintf(stderr, "badblocks(8) utility for OS/2 - Copyright (C) 1997 Matthieu WILLM\n");
        fprintf(stderr, "(Derived from Remy Card's Linux version)\n");
        fprintf(stderr, "This program is licensed under the terms of the GNU general public license.\n");
        fprintf(stderr, "See the file COPYING for details.\n\n");

        fprintf (stderr, "Usage: %s [-b block_size] [-o output_file] [-vw] device\n",
                 program_name);

        exit (1);
}
int main(int argc, char **argv) {
    int retcode;
    int i, j, k;
    APIRET rc;
    ULONG  pio;
    ULONG  dio;
    ULONG  action;
    HFILE  f = 0;
    struct getdevparm_parms parms = {0, 0};
    BIOSPARAMETERBLOCK bpb;
    PTRACKLAYOUT       tracklayout;
    unsigned long nr_sectors;
    unsigned long nr_sectors_chs;
    char c;
    char *tmp;
    char *device_name;
    unsigned long block_size = 1024;
    char *output_file = NULL;
    FILE *out;
    int dev_ok = 0;

    setbuf(stdout, NULL);
    setbuf(stderr, NULL);
    if (argc && *argv)
        program_name = *argv;


        while ((c = getopt (argc, argv, "b:o:h:svw?")) != EOF) {
                switch (c) {
                case 'b':
                        block_size = strtoul (optarg, &tmp, 0);
                        if (*tmp || block_size > 4096) {
                                fprintf(stderr, "%s : bad block size - %s\n", program_name, optarg);
                                exit (1);
                        }
                        break;
                case 'h':
                        f = strtoul (optarg, &tmp, 0);
                        if (*tmp || !f) {
                                fprintf(stderr, "%s : invalid file handle - %s\n", program_name, optarg);
                                exit (1);
                        }
                        dev_ok = 1;
                        break;

                case 'o':
                        output_file = optarg;
                        break;
                case 's':
                        s_flag = 1;
                        break;
                case 'v':
                        v_flag = 1;
                        break;
                case 'w':
                        /* w_flag = 1; */
                        fprintf(stderr, "%s : read-write test not yet supported\n", program_name, optarg);
                        exit(1);
                        break;
                default:
                        usage ();
                }
        }


        /*
         * Device name
         */
        if (optind > argc - 1)
                usage();
        device_name = argv[optind++];

        /*
         * Output file (if any)
         */
        if (output_file && strcmp (output_file, "-") != 0)
        {
                out = fopen (output_file, "w");
                if (out == NULL)
                {
                        fprintf(stderr, "Error while trying to open %s.\n", output_file);
                        perror("The error is ");
                        exit (1);
                }
        }
        else
                out = stdout;

        /*
         * Opens the device if not passed through command line.
         */
        if (!dev_ok) {
            rc = DosOpen(
                         device_name,
                         &f,
                         &action,
                         0,
                         0,
                         OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                         OPEN_FLAGS_DASD | OPEN_FLAGS_NO_CACHE | OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
                         0
                        );
            if (rc == NO_ERROR) {
                dev_ok = 1;
            } else {
                fprintf(stderr, "Couldn't open device %s\n", device_name);
                /* os2_err(rc); */
            }
        }

        if (dev_ok) {

            /*
             * Disables hard error popups
             */
            DosError(FERR_DISABLEHARDERR);

            /*
             * Retrieves drive geometry
             */
            pio = sizeof(parms);
            dio = sizeof(bpb);
            rc = DosDevIOCtl(
                             f,
                             IOCTL_DISK,
                             DSK_GETDEVICEPARAMS,
                             &parms, pio, &pio,
                             &bpb, dio, &dio
                            );
            if (rc == NO_ERROR) {
                if (v_flag) {
                    if (bpb.fsDeviceAttr & 1) {
                        fprintf(stderr, "Media is NOT removable\n");
                    } else {
                        fprintf(stderr, "Media is removable\n");
                    }
                    fprintf(stderr, "Bytes per sector    : %d\n", bpb.usBytesPerSector);
                    fprintf(stderr, "Sectors per cluster : %d\n", bpb.bSectorsPerCluster);
                    fprintf(stderr, "Reserved sectors    : %d\n", bpb.usReservedSectors);
                    fprintf(stderr, "Number of FATs      : %d\n", bpb.cFATs);
                    fprintf(stderr, "Number of root dir entries : %d\n", bpb.cRootEntries);
                    fprintf(stderr, "Sectors           : %d\n", bpb.cSectors);
                    fprintf(stderr, "Media descriptor  : %d\n", bpb.bMedia);
                    fprintf(stderr, "Sectors per FAT   : %d\n", bpb.usSectorsPerFAT);
                    fprintf(stderr, "Sectors per track : %d\n", bpb.usSectorsPerTrack);
                    fprintf(stderr, "Heads             : %d\n", bpb.cHeads);
                    fprintf(stderr, "Hidden sectors    : %d\n", bpb.cHiddenSectors);
                    fprintf(stderr, "Large sectors     : %d\n", bpb.cLargeSectors);
                    fprintf(stderr, "Cylinders         : %d\n", bpb.cCylinders);
                }

                if (bpb.cSectors && !bpb.cLargeSectors) {
                    nr_sectors = bpb.cSectors;
                } else if (bpb.cLargeSectors && !bpb.cSectors) {
                    nr_sectors = bpb.cLargeSectors;
                } else {
                    fprintf(stderr, "WARNING : cSectors/cLargeSectors inconsistency\n");
                }

                nr_sectors_chs = (unsigned long)bpb.usSectorsPerTrack * (unsigned long)bpb.cHeads * (unsigned long)bpb.cCylinders;

                if (nr_sectors + bpb.cHiddenSectors == nr_sectors_chs) {
                    if (v_flag)
                        fprintf(stderr, "nr_sectors + cHiddenSectors = nr_sectors_chs\n");
                } else {
                    fprintf(stderr, "WARNING : track/head/cylinder - cSector inconsistency : %d != %d\n", nr_sectors + bpb.cHiddenSectors, nr_sectors_chs);
                }

                tracklayout = malloc(sizeof(TRACKLAYOUT) + 4 * (bpb.usSectorsPerTrack - 1));
                if (tracklayout) {

                    if (s_flag)
                        fprintf(stderr, "Verifying cylinder ");
                    for (i = 0 ; i < bpb.cCylinders ; i++) {
                        if (s_flag) {
                            fprintf(stderr, "%5d / %5d", i + 1, bpb.cCylinders);
                            fprintf(stderr, "\b\b\b\b\b\b\b\b\b\b\b\b\b");
                        }

                        for (j = 0 ; j < bpb.cHeads ; j++) {
                            tracklayout->bCommand      = 1;
                            tracklayout->usHead        = j;
                            tracklayout->usCylinder    = i;
                            tracklayout->usFirstSector = 0;
                            tracklayout->cSectors      = bpb.usSectorsPerTrack;
                            for (k = 0 ; k < bpb.usSectorsPerTrack ; k++) {
                                tracklayout->TrackTable[k].usSectorNumber = k + 1;
                                tracklayout->TrackTable[k].usSectorSize   = bpb.usBytesPerSector;
                            }
                            pio = sizeof(TRACKLAYOUT) + 4 * (bpb.usSectorsPerTrack - 1);
                            dio = 0;
                            rc = DosDevIOCtl(
                                             f,
                                             IOCTL_DISK,
                                             DSK_VERIFYTRACK,
                                             tracklayout, pio, &pio,
                                             0, dio, &dio
                                            );
                            if (rc != NO_ERROR) {
                                verify_track(stdout, f, i, j, bpb.cHeads, bpb.usSectorsPerTrack, bpb.usBytesPerSector, 2);
                            }
                        }
                    }
                } else {
                    perror("Error while allocating track table");
                    retcode = 1;
                }
            } else {
                fprintf(stderr, "Couldn't get BPB, rc = %d\n", rc);
                retcode = 1;
            }

            /*
             * Close the file
             */
            rc = DosClose(f);
            if (rc == NO_ERROR) {
                /*
                 * Nothing else to do
                 */
            } else {
                fprintf(stderr, "Couldn't close %s, rc = %d\n", device_name, rc);
                retcode = 1;
            }
        } else {
            fprintf(stderr, "Couldn't access device\n");
            retcode = 1;
        }
        if (s_flag)
            fprintf(stderr, "\n");
        return retcode;
}

