/* A REXX Script to create a playlist */
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Take input either from the command line */
/* or a folder dropped onto our icon */
playList = list     /* The name of our playlist */
parse arg folder       /* The folder to search for the playlist */

say "The argument we're using: "||folder;

/* gather the list of files and write it out */
rc = SysFileTree(folder||'\*.*', fileList., 'FSO');

say "Found "||fileList.0||" entires in "||folder;

do n=1 to fileList.0
    if (n == 1) then do
        rc = LINEOUT(playList, fileList.n, 1);
    end
    else do
        rc = LINEOUT(playList, fileList.n)
    end
    
    /* say "Adding -> "||fileList.n; */
end

/* Now close the file */
rc = LINEOUT(playList)

say "Playlist creation complete.";
