#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ccard.h"


static int suffix _((char *, char *));

static int
suffix(s1 , s2)
	char	*s1;
	char	*s2;
{
	int len1 = strlen(s1);
	int len2 = strlen(s2);
	return (len2 < len1 && !memcmp(s1 + len1 - len2, s2, len2));
}


int
main(argc, argv)
	int		argc;
	char		**argv;
{
	int		j;

	for (j = 1; j < argc; ++j)
	{
		ccard_type_ty	type;
		ccard_error_ty	err;

		err = ccard_valid(argv[j], &type);
		printf("\"%s\"", argv[j]);
		if (type != ccard_type_unknown)
		{
			char	*s;

			s = ccard_type_name(type);
			printf(" is ");
			if (strchr("AEIOUaeiou", s[0]))
				printf("an ");
			else
				printf("a ");
			printf("%s", s);
			if (!suffix(s, "card"))
				printf(" card");
		}
		if (err)
		{
			printf(": %s\n", ccard_error_name(err));
			exit(1);
		}
		printf("\n");
	}
	exit(0);
	return 0;
}
